package code;
import rice.pastry.AML.AggrFunc;
import java.util.Random  ;

/**
 * SDIMSSDAggrFunc.java
 *   SDIMS Spanning Directory Aggregation Function definition
 *
 *   Currently.. randomly chooses one of the child's values
 *
 * @author Praveen Yalagandula
 * @version
 */

public class SDIMSSDAggrFunc extends AggrFunc {
    
    public SDIMSSDAggrFunc(String attrType, int tup) {
	super(attrType) ;
	up = tup ;
	down = 0 ;
    }

    public SDIMSSDAggrFunc(String attrType) {
	super(attrType) ;
	up = 160 ;
	down = 0 ;
    }

    public SDIMSSDAggrFunc(String attrType, int tup, int tdown) {
	super(attrType) ;
	up = tup ;
	down = tdown ;
    }

    public Object aggregate(Object[] args) {
	// choose the smallest one as the answer
	assert(args.length > 0) ;
	NodeId small = (NodeId)args[0] ;
	for(int ii = 0 ; ii < args.length ; ii++) {
	    if(((NodeId)args[ii]).compareTo(small) < 0) {
		small = (NodeId)args[ii] ;
	    }
	}
	return small ;
    }
    
} // SDIMSSDAggrFunc

/* $Log: SDIMSSDAggrFunc.java,v $
/* Revision 1.5  2004/05/23 05:29:17  ypraveen
/* choosing smallest node as the representative
/*
/* Revision 1.4  2004/05/20 20:53:41  ypraveen
/* Trivial Aggregation Functions for Read directory and spanning directory; also added cvs logging here
/*
 */
