package code;
import rice.pastry.AML.AggrFunc;
import java.util.Random  ;

/**
 * SDIMSSDNodeNearAggrFunc.java
 *   SDIMS Spanning Directory Aggregation Function definition
 *
 *   Choose a node with node id closest to my node id
 *
 * @author Praveen Yalagandula
 * @version
 */

public class SDIMSSDNodeNearAggrFunc extends AggrFunc {
  private NodeId myNodeId;
  public SDIMSSDNodeNearAggrFunc(String attrType, int tup, NodeId myNodeId_) {
	super(attrType) ;
	up = tup ;
	down = 0 ;
        this.myNodeId = myNodeId_;
    }

  public SDIMSSDNodeNearAggrFunc(String attrType, NodeId myNodeId_) {
	super(attrType) ;
	up = 160 ;
	down = 0 ;
        this.myNodeId = myNodeId_;
    }

    public SDIMSSDNodeNearAggrFunc(String attrType, int tup, int tdown) {
	super(attrType) ;
	up = tup ;
	down = tdown ;
    }

    public Object aggregate(Object[] args) {
	//   Choose a node with node id closest to my node id
	NodeId myId = myNodeId;
	int myIdInt = new Integer(myId.toString()).intValue() ;

	assert(myId != null) ;

	assert(args.length > 0) ;
	NodeId smallId = (NodeId)args[0] ;
	int mindiff = Math.abs(new Integer(smallId.toString()).intValue() - myIdInt) ;

	for(int ii = 0 ; ii < args.length ; ii++) {
	    NodeId thisId = (NodeId) args[ii] ;
	    int diff = Math.abs(new Integer(thisId.toString()).intValue() - myIdInt) ;
	    if(diff < mindiff) {
		smallId = thisId ;
		mindiff = diff ;
	    }
	}
	return smallId ;
    }
    
} // SDIMSSDNodeNearAggrFunc

//---------------------------------------------------------------------------
/* $Log: SDIMSSDNodeNearAggrFunc.java,v $
/* Revision 1.2  2005/10/13 00:24:24  zjiandan
/* remove Config.getMy* fixed Garbage Collection and Checkpoint exchange code
/*
/* Revision 1.1  2004/05/27 01:49:10  ypraveen
/* aggr fun that picks near node based on nodeid
/*
/*
 */
//---------------------------------------------------------------------------
