package code;


import rice.pastry.PastryNode ;
import rice.pastry.NodeHandle ;
import rice.pastry.NodeName ;
import rice.pastry.AML.* ;
import rice.pastry.AML.messaging.* ;

import java.net.*;
import java.util.Random ;
import java.util.Vector ;

 /** 
 *  Select someone to supply read misses 
 **/ 
public class SDIMSSpanningDirectory implements SpanningDirectory{
    SDIMSInterface sdims = null ;
    private static final boolean TBD = false;

    public SDIMSSpanningDirectory(SDIMSInterface sdims_)
    {
	sdims = sdims_ ;
	//assert(TBD);
    }


    /*
     *------------------------------------------------------------------
     *
     *  getTargetAndSubscribeNotifyChanges --
     *
     *          Return node that is parent in the spanning tree for the
     *          specified interest set (or my node ID if I am the root 
     *          for that spanning tree).
     *
     *          Additionally, register a callback -- if my parent
     *          changes, the directory will call SpanningChangeHandler
     *
     * Arguments:
     *      SubscribeInvalRequest r -- identifies the spanning tree as well
     *                                 as info about the request (e.g., retry
     *                                 count)
     *      SpanningChangeHandler controllerToNotify -- who to callback on change
     *
     * Results:
     *      NodeId of parent in spanning tree
     *      null on error (caller should retry after timeout. No callback registered.)
     *      Return my own NodeId if I am the root of this spanning tree.
     *
     * Side effects:
     *      None.
     *
     *------------------------------------------------------------------
     */
    public NodeId getTargetAndSubscribeNotifyChanges(SubscribeInvalRequest r, 
						     SpanningChangeHandler controllerToNotify)
    {
	assert(r.getSubscriptionSet().containsExactlyOneSubdirectory()) ;
	
	// Do not comment the following line!
	PastryNode pn = sdims.getLocalNode() ;
	assert(pn != null) ;

	String attrType = sdims.spanningDirAttrType ;
	String attrName = r.getSubscriptionSet().toString() ;
	NodeId myId = sdims.getMyNodeId() ;

	sdims.sendUpdateMessage(attrType, attrName, myId) ;

	// sleep somtime after sending update message?
	  try{
	  Thread.sleep(10000) ;
	  }catch(Exception e) {
	  System.out.println(e) ;
	  }

	boolean reaggregate = false ;
	if(r.getRetryCount() > 0){
	    reaggregate = true;
	}
	SDIMSSDProbeCallBack pcb = new SDIMSSDProbeCallBack(controllerToNotify,
                                                            sdims.getSpanTreeWorkQ(),
          myId) ;
	
	sdims.sendProbeMessage(attrType, attrName, 
			       true, /* continuous */
			       reaggregate,
			       pcb,
			       100000) ; /* 100 sec timeout */
	NodeId answer = pcb.getAnswer() ;
	if(answer == null) {
	    answer = myId ;
	}
	System.out.println("Parent will be "+answer) ;
	return answer ;

	//assert(TBD); return null;
	/*
	  pseudo code works for main spanning trees only, not hole filling
	  assert(r.getWriters() == NodeId.WILDCARD_NODE_ID;

	  type = SUBSCRIBE_INVALS;
	  key = is
	  value = my node ID
	  success = sdims.insert(type, key, value)
	  if(!success)
	  return NodeId.INVALID_NODE_ID;
	  }
      
	  //
	  // Find out the parent of my subtree for this interest set;
	  // Tell SDIMS to notify my if this parent changes.
	  // Returns myNodeId if I am root (?) (note that if I am
	  // root, continuous probe still applies -- I will be notified
	  // of change)
	  //
	  boolean reaggregate = false;
	  if(r.getRetryCount() > 0){
	  reaggregate = true;
	  }
	  value = sdims.probeFirstNonmatchingAndContinuousProbeChanges(type, key, value, 
	  reaggregate, controllerToNotify);

	  return value;
	*/
    }

    public static void 
	main(String s[])
    {
	if(s.length == 0){
	    runSelfTestBoss();
	    return;
	}
	int id = (new Integer(s[0])).intValue() ;
	runSelfTestWorker(new NodeId(id));
	return;
    }

    private static void
	runSelfTestBoss()
    {
	System.err.print("SDIMSSpanningDirectory self test begins...");
	assert(TBD);
	/*
	  Read config file
	  foreach nodeId in config file
	  exec a process on that node that runs this self test with argument "worker";
	  stdout/stdin of that process should be a stream to/from boss
	  read NodeId from each stream
	  assert(these node ids form a spanning tree)
	  send "die" to each stream
	*/
	System.err.println("SDIMSSpanningDirectory self test SUCCEEDS");
	System.exit(0);
    }

    private static void
	runSelfTestWorker(NodeId myId)
    {
	
	Config.readConfig("test/SDIMS-spanning-test.config") ;
	
	SDIMSInterface sintf = null ;

	sintf = new SDIMSInterface(myId) ;
	sintf.start() ;
	
	SDIMSSpanningDirectory dir = new SDIMSSpanningDirectory(sintf) ;
	
	SubscribeInvalRequest r = 
	    new SubscribeInvalRequest(Config.getInterestSet(myId).makeSubscriptionSet(),
				      null,
				      new NodeId(0),
				      false) ;
	SDIMSSpanningDirSelfTestSpanningChangeHandler controllerToNotify = 
	    new SDIMSSpanningDirSelfTestSpanningChangeHandler() ;

	NodeId ans = dir.getTargetAndSubscribeNotifyChanges(r, controllerToNotify);
	System.out.println("Initial answer: "+ans) ;
	try{
	    Thread.sleep(50000) ; // 50 sec sleep
	}catch(Exception e) {
	    System.out.println(e) ;
	}
	    
	NodeId n = controllerToNotify.getCurrentAnswer();
	System.out.println("Worker id "+myId+" found parent "+n);  
	
	
	//assert(TBD);
	/*
	  read config file
	  start sdims
	  dir = new SDIMSSPanningDirectory(...);
	  r = new SubscribeInvalRequest(... IS = "/" ...)
	  controllerToNotify = new SDIMSSpanningDirSelfTestSpanningChangeHandler()
	  getTargetAndSubscribeNotifyChanges(r, controllerToNotify);
	  sleep(10);
	  NodeId n = controllerToNotify.getCurrentAnswer();
	  print n to stdout
	  read "die" from stdin
	*/
    }

}

/*
 *  This call back should do one of two things
 *     if this is the first time the call back invoked, then the answer should be
 *         returned to the first thread
 *     otherwise put it in the workqueue?
 *
 */
class SDIMSSDProbeCallBack implements ProbeCallBack {
    // add workqueue later
    WorkQueue wq ;
    SpanningChangeHandler sch ; // controller to notify.
    boolean firstTime = true ; // firstTime.. notify the thread that created us
    Object lastAnswer = null ;
  NodeId myNodeId = null;
    
    public SDIMSSDProbeCallBack(SpanningChangeHandler sch_,
				WorkQueue wq_, NodeId myid) {
	sch = sch_ ;
	wq = wq_ ;
        myNodeId = myid;
    }

    //
    //  This routine to be called by the spanning tree worker
    //   waiting to get atleast one answer
    //
    public synchronized NodeId getAnswer() {
	while(firstTime) {
	    try{
		wait() ;
	    }catch(InterruptedException i){
		assert(false);
	    }
	}
	return (NodeId)lastAnswer ;
    }


    //
    // firstTime.. wake the spanning tree worker
    // later.. 
    //    check if the answer changed from the previous one.
    //    if so, put the work in the workqueue
    //
    public synchronized void doWork(ProbeMessage pmsg, Object newAnswer) {

	//System.out.println("Got answer "+newAnswer+" lastanswer was "+lastAnswer) ;
	if(firstTime) {
	    // atleast should get my Nodeid
	    if(newAnswer == null) return ;
	    firstTime = false ;
	    lastAnswer = newAnswer ;
	    // wake up the thread
	    notify() ;
	}
	else {
	    if( (lastAnswer == null)? (newAnswer == null) : (newAnswer != null && 
							     lastAnswer.equals(newAnswer)) ) {
		return ;
	    }
	    else {
		// put work in the workqueue
		SpanningTreeTriggerWork sttw = new SpanningTreeTriggerWork(sch, 
									   pmsg.attr.type(), 
									   pmsg.attr.name(), 
									   newAnswer) ;
		wq.insert(sttw) ;
		lastAnswer = newAnswer ;
	    }
	}
    }

    //
    // 
    //
    public void onAnswer(ProbeMessage msg, Object answer) {
	Vector entries = (Vector) answer ;
	
	for(int ii = 0 ; ii < entries.size() ; ii++) {
	    AncestorMIBEntry amib = (AncestorMIBEntry)(entries.get(ii)) ;
	    if(amib.value != null && !((NodeId) amib.value).equals(myNodeId)) {
		doWork(msg, amib.value) ;
		return ;
	    }
	}
	AncestorMIBEntry amib = (AncestorMIBEntry)(entries.get(entries.size()-1)) ;
	doWork(msg, (NodeId)amib.value) ;
	return ;
    }
}

class SpanningTreeTriggerWork {
    SpanningChangeHandler sch ;
    String attrName ;
    String attrType ;
    Object value ;

    public SpanningTreeTriggerWork(SpanningChangeHandler sch_,
				   String attrType_,
				   String attrName_,
				   Object value_) {
	sch = sch_ ;
	attrType = attrType_ ;
	attrName = attrName_ ;
	value = value_ ;
    }

    public void doit() {
	sch.notifySpanningChange(attrType, attrName, value) ;
    }
}

class SDIMSSpanningTreeTriggerWorker extends Thread {
    WorkQueue wq ;

    public SDIMSSpanningTreeTriggerWorker (WorkQueue wq_) {
	wq = wq_ ;
    }

    public void run() {
	while(true){
	    try{
		SpanningTreeTriggerWork work  = (SpanningTreeTriggerWork)wq.getNext();
		work.doit() ;
	    }
	    catch(RuntimeException e){
		Env.warn("SpanningTreeTriggerWorker had exception: "
			 + e.toString() + "...Skipping request and continuing.");
		e.printStackTrace();
	    }
	}
    }
}





class SDIMSSpanningDirSelfTestSpanningChangeHandler implements SpanningChangeHandler
{
    private NodeId nodeId;
    private static final boolean TBD = false;

    public SDIMSSpanningDirSelfTestSpanningChangeHandler()
    {
	this.nodeId = new NodeId(NodeId.INVALID_NODE_ID);
    }

    public void
	notifySpanningChange(String attrType, String attrName, 
				Object value)
    {
	System.out.println("Spanning change notified!!!") ;
	nodeId = (NodeId) value ;
	//assert(TBD);
	/*
	  update nodeId from value
	*/
    }

    public NodeId
	getCurrentAnswer()
    {
	return nodeId;
    }


}

//---------------------------------------------------------------------------
/* $Log: SDIMSSpanningDirectory.java,v $
/* Revision 1.12  2005/10/13 00:24:24  zjiandan
/* remove Config.getMy* fixed Garbage Collection and Checkpoint exchange code
/*
/* Revision 1.10  2005/03/01 09:25:55  nayate
/* Modified for new code
/*
/* Revision 1.9  2004/05/24 20:58:20  ypraveen
/* Changes to the testing code
/*
/* Revision 1.8  2004/05/23 06:26:37  ypraveen
/* small changes
/*
/* Revision 1.7  2004/05/23 05:35:29  ypraveen
/* bug fix
/*
/* Revision 1.6  2004/05/21 05:50:53  ypraveen
/* Basic Test case succeeds with three nodes. Right now has to start three nodes manually.
/*
/* Revision 1.5  2004/05/21 04:58:34  ypraveen
/* Couple of asserts and name changes
/*
/* Revision 1.4  2004/05/21 03:12:11  ypraveen
/* First cut spanning tree building. Will do testing now
/*
/* Revision 1.3  2004/05/20 21:41:50  ypraveen
/* did indentation
/*
/* Revision 1.2  2004/05/13 20:24:02  dahlin
/* Fixed ^M formatting
/*
/* Revision 1.1  2004/05/13 18:49:17  dahlin
/* Clean SDIMSController by moving SpanningTree directory out as separate class (rather than using raw SDIMSInterface)
/*
 */
//---------------------------------------------------------------------------
