package code;
//package utils.junit;

import junit.textui.TestRunner;
import junit.framework.*;

/**
 * TBD: Update class name
 */
public class SingleWriterImpreciseInvUnit extends TestCase {
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  
  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public SingleWriterImpreciseInvUnit (final String s) {
    super (s);
  }

  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
    /* 
     * TBD: Insert other fixture code here
     * e.g., this.objectUnderTest = new ClassToBeTested(...);
     */
  }

  protected void tearDown() throws Exception{
    /* 
     * TBD: Insert other fixture cleanup code here
     */
    super.tearDown();
  }

 /** 
 *  test basic functions
 
 **/ 
  public void testBasicFunction(){
    SingleWriterImpreciseInv ii1 = null;
    GeneralInv ii2 = null;
    AcceptStamp as1 = null;
    AcceptStamp as2 = null;
    InvalTarget it1 = null;
    InvalTarget it2 = null;
    PreciseInv pi1 = null;
    AcceptVV asvv1 = null;
    AcceptVV asvv2 = null;
    AcceptStamp[] stamps = null;
    AcceptStamp[] stamps2 = null;
    NodeId nodeId1 = null;

    as1 = new AcceptStamp(10, new NodeId(200));
    as2 = new AcceptStamp(15, new NodeId(200));
    ii1 = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"), as1, as2);
    System.out.println("ii1 = " + ii1);
    System.out.println("ii1.getStartAcceptStamp() = " +
                       ii1.getStartAcceptStamp());
    System.out.println("ii1.getEndAcceptStamp() = " +
                       ii1.getEndAcceptStamp());
    System.out.println("ii1.getStartVV() = " + ii1.getStartVV());
    System.out.println("ii1.getEndVV() = " + ii1.getEndVV());
    System.out.println();

    // Test clone + chop routines
    it1 = ii1.getInvalTarget();
/*      System.out.println("ii1.cloneIntersectInvalTarget(" +
        "ii1.getInvalTarget()) = " +
        ii1.cloneIntersectInvalTarget(it1));*/
    it2 = new ObjInvalTarget(new ObjId("/obj1"), 10, 20);
    pi1 = new PreciseInv((ObjInvalTarget)it2,
                         new AcceptStamp(12, new NodeId(200)));
    System.out.println("ii1.cloneIntersectInvaltargetChopStartEnd(" +
                       pi1 + ") = " +
                       ii1.cloneIntersectInvaltargetChopStartEnd(pi1));
    stamps = new AcceptStamp[2];
    stamps[0] = new AcceptStamp(11, new NodeId(200));
    stamps[1] = new AcceptStamp(8, new NodeId(100));
    asvv1 = new AcceptVV(stamps);
    stamps[0] = new AcceptStamp(14, new NodeId(200));
    stamps[1] = new AcceptStamp(17, new NodeId(100));
    asvv2 = new AcceptVV(stamps);
    ii2 = new ImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"), asvv1, asvv2);
    System.out.println("ii2 = " + ii2);
    System.out.println("ii1.cloneIntersectInvaltargetChopStartEnd(" +
                       ii2 + ") = " +
                       ii1.cloneIntersectInvaltargetChopStartEnd(ii2));

    // Test cloneChopStartTime/cloneChopEndTime
    System.out.println("ii1.cloneChopStartTime(11) = " +
                       ii1.cloneChopStartTime(11));
    System.out.println("ii1.cloneChopEndTime(14) = " +
                       ii1.cloneChopEndTime(14));

    // Test getOneWriterSubsetFrom
    System.out.println("ii1 = " + ii1);
    nodeId1 = new NodeId(200);
    System.out.println("ii1.getOneWriterSubsetFrom(" + nodeId1 + ", 12)" +
                       " = " + ii1.getOneWriterSubsetFrom(nodeId1, 12));
    System.out.println();

    // Test totalOrderCompare
    // Case 1a:
    stamps = new AcceptStamp[2];
    stamps[0] = new AcceptStamp(160, new NodeId(300));
    stamps[1] = new AcceptStamp(190, new NodeId(200));
    stamps2 = new AcceptStamp[2];
    stamps2[0] = new AcceptStamp(190, new NodeId(300));
    stamps2[1] = new AcceptStamp(210, new NodeId(200));
    ii1 = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
                                       new AcceptStamp(190, new NodeId(200)),
                                       new AcceptStamp(210, new NodeId(200)));
    ii2 = new ImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
                           new AcceptVV(stamps),
                           new AcceptVV(stamps2));
    System.out.println("ii1 = " + ii1);
    System.out.println("ii2 = " + ii2);
    checkComparisons(ii1, ii2);

    // Case 1b:
    ii1 = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
                                       new AcceptStamp(190, new NodeId(200)),
                                       new AcceptStamp(210, new NodeId(200)));
    ii2 = new ImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
                           new AcceptVV(stamps),
                           new AcceptVV(stamps2));
    System.out.println("ii1 = " + ii1);
    System.out.println("ii2 = " + ii2);
    checkComparisons(ii1, ii2);

    // Case 2a:
    pi1 = new PreciseInv((ObjInvalTarget)it2,
                         new AcceptStamp(180, new NodeId(200)));
    ii2 = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
                                       new AcceptStamp(190, new NodeId(200)),
                                       new AcceptStamp(210, new NodeId(200)));
    System.out.println("pi1 = " + pi1);
    System.out.println("ii2 = " + ii2);
    checkComparisons(ii2, pi1);

    // Case 2b:
    stamps = new AcceptStamp[2];
    stamps[0] = new AcceptStamp(150, new NodeId(300));
    stamps[1] = new AcceptStamp(180, new NodeId(200));
    stamps2 = new AcceptStamp[2];
    stamps2[0] = new AcceptStamp(190, new NodeId(300));
    stamps2[1] = new AcceptStamp(210, new NodeId(200));
    ii1 = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
                                       new AcceptStamp(190, new NodeId(200)),
                                       new AcceptStamp(210, new NodeId(200)));
    ii2 = new ImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
                           new AcceptVV(stamps),
                           new AcceptVV(stamps2));
    System.out.println("ii1 = " + ii1);
    System.out.println("ii2 = " + ii2);
    checkComparisons(ii1, ii2);

    // Case 3:
    stamps = new AcceptStamp[2];
    stamps[0] = new AcceptStamp(190, new NodeId(100));
    stamps[1] = new AcceptStamp(200, new NodeId(200));
    stamps2 = new AcceptStamp[2];
    stamps2[0] = new AcceptStamp(190, new NodeId(300));
    stamps2[1] = new AcceptStamp(210, new NodeId(200));
    ii2 = new ImpreciseInv(new ISet(),
                           new AcceptVV(stamps),
                           new AcceptVV(stamps2));
    System.out.println("ii1 = " + ii1);
    System.out.println("ii2 = " + ii2);
    checkComparisons(ii1, ii2);

    // Case 4:
    stamps = new AcceptStamp[2];
    stamps[0] = new AcceptStamp(190, new NodeId(200));
    stamps[1] = new AcceptStamp(200, new NodeId(400));
    stamps2 = new AcceptStamp[2];
    stamps2[0] = new AcceptStamp(200, new NodeId(300));
    stamps2[1] = new AcceptStamp(209, new NodeId(200));
    ii2 = new ImpreciseInv(new ISet(),
                           new AcceptVV(stamps),
                           new AcceptVV(stamps2));
    System.out.println("ii1 = " + ii1);
    System.out.println("ii2 = " + ii2);
    checkComparisons(ii1, ii2);
  
  }
//-----------------------------------------------------------------------
  // i1 < i2
  //-----------------------------------------------------------------------
  private static final void
  checkComparisons(GeneralInv i1, GeneralInv i2){
    boolean dbg = false;
    if(dbg){
    System.out.println("i1.totalOrderCompare(i1) = " +
                       i1.totalOrderCompare(i1));
    System.out.println("i2.totalOrderCompare(i2) = " +
                       i2.totalOrderCompare(i2));
    System.out.println("i1.totalOrderCompare(i2) = " +
                       i1.totalOrderCompare(i2));
    System.out.println("i2.totalOrderCompare(i1) = " +
                       i2.totalOrderCompare(i1));
    }
    assert i1.totalOrderCompare(i1) == 0;
    assert i2.totalOrderCompare(i2) == 0;
    assert i1.totalOrderCompare(i2) == 1;
    assert i2.totalOrderCompare(i1) == -1;
  }
  public void testBasic2(){
    
   
  }
  
  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(SingleWriterImpreciseInvUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "SingleWriterImpreciseInvUnit";
    System.err.print(name + " self test begins...");
    TestRunner tr = new TestRunner();
    tr.doRun(suite());
    System.err.println(name + " self test succeeds");
  }

}



//---------------------------------------------------------------------------
/* $Log$*/
//---------------------------------------------------------------------------
