package code;

import java.util.HashMap;

import code.branchDetecting.BranchID;
import code.security.SangminConfig;


/**
 * This class is a util class to store a set of <writerId, InvalListItem>
 * to represent the current position in the per-writer-log of writerId.
 * 
 * 
 * @author zjiandan
 *
 */
public class SingleWriterLogPointers{
  HashMap<NodeId, InvalListItem> pointers = null;
  
  public SingleWriterLogPointers(HashMap<NodeId, InvalListItem> pointers){
    super();
    this.pointers = pointers;
  }

  public SingleWriterLogPointers(){
    super();
    pointers = new HashMap<NodeId, InvalListItem>();
  }
  
  public NodeId[]
  getAllNodeIds(){
    return (NodeId[]) pointers.keySet().toArray();
  }
  
  public InvalListItem
  getInvalListItem(NodeId id){
    return pointers.get(id);
  }
              
  public boolean
  contains(NodeId id){
    return pointers.containsKey(id);
  }
  
  public void
  advance(NodeId id, InvalListItem item){
    
    InvalListItem oldItem = pointers.get(id);
    assert oldItem != null;
    assert item != null;
    assert !item.isDummy();
    assert item.getInv() instanceof SingleWriterInval;
    assert oldItem.getInv() instanceof SingleWriterInval;
    assert ((SingleWriterInval)(item.getInv())).getNodeId().equals(id);
    assert ((SingleWriterInval)(oldItem.getInv())).getNodeId().equals(id);
    assert ((SingleWriterInval)(item.getInv())).getStart()
           > ((SingleWriterInval)(oldItem.getInv())).getStart();
    pointers.put(id, item);
  }
  
  public void
  add(NodeId id, InvalListItem item){
    assert !pointers.containsKey(id);
    assert item != null;
    assert !item.isDummy();
    pointers.put(id, item);
  }
  
  public void
  remove(NodeId id, InvalListItem item){
    //System.out.println(" \n\n___going to remove " + item.getInv());
    assert item.equals(pointers.get(id));
    pointers.remove(id);
  }

  public InvalListItem min(){
    
    InvalListItem ret = null;
    if (pointers.size()!=0){
      
      Object[] allItems = pointers.values().toArray();
      assert allItems.length != 0;
      AcceptStamp minTime = null;
      NodeId maxNodeId = new NodeId(Long.MAX_VALUE);
      if(SangminConfig.forkjoin){
        maxNodeId = new BranchID(maxNodeId.getIDint());
      }
      minTime = new AcceptStamp(Long.MAX_VALUE, maxNodeId);
      AcceptStamp newTime = null;
      SingleWriterInval inv = null;
      for(int i = 0; i < allItems.length; i++){
        inv = (SingleWriterInval)(((InvalListItem)allItems[i]).getInv());
        newTime = new AcceptStamp(inv.getStart(), inv.getNodeId());
        
        if(newTime.lt(minTime)){
          minTime = newTime;
          ret = (InvalListItem)allItems[i];
        }
      }
      assert ret != null;
    }
    
    return ret;
  }
  
  public int size(){
    return pointers.size();
  }
  
  
  public String toString(){
    String ret = "";
    Object[] allItems = pointers.values().toArray();
    SingleWriterInval inv = null;
    for(int i = 0; i < allItems.length; i++){
      inv = (SingleWriterInval)(((InvalListItem)allItems[i]).getInv());
      ret += inv.toString();
    }
    
    return ret;
  }
  
 /** 
 *  Return true if "this" equals "obj" 
 **/ 
  public boolean
  equals(Object obj){
    boolean result = false;
    SingleWriterLogPointers target = null;
    if(obj instanceof SingleWriterLogPointers){
      result = true;
      target = (SingleWriterLogPointers) obj;
      NodeId[] nodes = pointers.keySet().toArray(new NodeId[0]);
      for(int i = 0; i < nodes.length; i++){
        if((pointers.get(nodes[i]) != target.pointers.get(nodes[i]))){
          return false;
        }
      }
    }
    return(result);
  }
}
