package code;
//--------------------------------------------------------------------------
// Unit test for SingleWriterLogUncommittedUnit
//--------------------------------------------------------------------------

import junit.textui.TestRunner;
import junit.framework.*;
import java.util.*;
import java.io.*;

/**
 * TBD: Update class name
 */
public class SingleWriterLogUncommittedUnit extends TestCase {
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  protected static boolean verbose = false; // Start/end of test
  protected static boolean vverbose = false; // Test internals
  // private Process rmiregistry;
  
  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public SingleWriterLogUncommittedUnit (final String s) {
    super (s);
  }


  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
    /*
    //
    // Start the registry
    //
    rmiregistry = Runtime.getRuntime().exec("rmiregistry");
    Env.dprintln(verbose, "rmiregistry started");
    Thread.sleep(2000);
    */
  }

  protected void tearDown() throws Exception{
    /*
    rmiregistry.destroy();
    */
    super.tearDown();
    
  }



  //-----------------------------------------------------------------------
  // Test basic functions
  //-----------------------------------------------------------------------
  public void testSimple() throws Exception{
     //test1: basic functionalities
    SingleWriterLogUncommitted uncommitted = 
      new SingleWriterLogUncommitted(new NodeId(200));
    assert((uncommitted.getMinCounter() == SingleWriterLogUncommitted.UNINITIALIZED_COUNTER)
           && (uncommitted.getMaxCounter() == SingleWriterLogUncommitted.UNINITIALIZED_COUNTER)
           && (uncommitted.getOldest() == null)
           && (uncommitted.getNewest() == null));
		
    uncommitted.verifyInvariants();
    if(verbose){
      System.out.println("Pass test 0");
    }
    byte[] bdy1 = null;
    BoundInval bi1 = null;
    BoundInval bi2 = null;
    BoundInval bi3 = null;

    UnbindMsg ubm = null; 
		
    bdy1 = new byte[5];
    bdy1[0] = 10;
    bdy1[1] = 9;
    bdy1[2] = 8;
    bdy1[3] = 7;
    bdy1[4] = 6;
    ImmutableBytes body1 = new ImmutableBytes(bdy1);
	
    bi1 = new BoundInval(new ObjId("/d1/obj1"),
                         10,
                         body1.getLength(),
                         new AcceptStamp(500, new NodeId(200)),
                         body1);
   
    bi2 = new BoundInval(new ObjId("/d1/obj1"),
                         10,
                         body1.getLength(),
                         new AcceptStamp(503, new NodeId(200)),
                         body1);
   
    PreciseInv pi1 = new PreciseInv(new ObjInvalTarget(new ObjId("/d1/obj1"), 
                                                       10, 
                                                       20),
                                    new AcceptStamp(501, new NodeId(200)));

    PreciseInv pi2 = new PreciseInv(new ObjInvalTarget(new ObjId("/d1/obj1"), 
                                                       10, 20),
                                    new AcceptStamp(502, new NodeId(200)));
   
    try {
      uncommitted.merge(bi1);
      assert( (uncommitted.getMinCounter() == bi1.getStart())
              && (uncommitted.getMaxCounter() == bi1.getEnd())
              && (((SingleWriterInval)(uncommitted.getOldest().getInv())).getStart() == 500)
              && (((SingleWriterInval)(uncommitted.getNewest().getInv())).getEnd() == 500));
				
      uncommitted.merge(pi1);
      uncommitted.merge(pi2);
      uncommitted.merge(bi2);
		
      assert( (uncommitted.getMinCounter() == bi1.getStart())
              && (uncommitted.getMaxCounter() == bi2.getEnd())
              && (((SingleWriterInval)(uncommitted.getOldest().getInv())).getStart() == 500)
              && (((SingleWriterInval)(uncommitted.getNewest().getInv())).getEnd() == 503 ));
		
		
      uncommitted.verifyInvariants();
		
      ubm = new UnbindMsg(new ObjInvalTarget(new ObjId("/d1/obj1"), 10, 5), 
                          new AcceptStamp(500, new NodeId(200)));
      
		
      assert((((SingleWriterInval)(uncommitted.getNextByStart(500))).getEnd() == 501)
             && ( uncommitted.getNextByStart(503) == null)
             && ( ((SingleWriterInval)(uncommitted.getNextByStart(498))).getEnd() == 500));
		
      uncommitted.chopTail(499);//nothing should be changed
      assert( (uncommitted.getMinCounter() == bi1.getStart())
              && (uncommitted.getMaxCounter() == bi2.getEnd())
              && (((SingleWriterInval)(uncommitted.getOldest().getInv())).getStart() == 500)
              && (((SingleWriterInval)(uncommitted.getNewest().getInv())).getEnd() == 503 ));
      uncommitted.verifyInvariants();
		

      uncommitted.chopTail(502);	//should be 03
      uncommitted.verifyInvariants();
      
      assert( (uncommitted.getMinCounter() == 503)
              && ( uncommitted.getMaxCounter() == 503)
              && ( ((SingleWriterInval)(uncommitted.getOldest().getInv())).getStart() == 503)
              && ( ((SingleWriterInval)(uncommitted.getNewest().getInv())).getEnd() == 503)
              && ( uncommitted.getOldest().getNewer() == null)
              && ( uncommitted.getNewest().getOlder() == null));
		
      uncommitted.chopTail(503);//list is empty
      assert((uncommitted.getMinCounter() == SingleWriterLogUncommitted.UNINITIALIZED_COUNTER)
             && (uncommitted.getMaxCounter() == SingleWriterLogUncommitted.UNINITIALIZED_COUNTER)
             && (uncommitted.getOldest() == null)
             && (uncommitted.getNewest() == null));
		
      if(verbose){
	System.out.println("Pass Test 1: Precise Invalidate");
      }
		
      //--------------------------------------------------------------------
      
      //Note VV doesn't matter for this log because every invalidate have
      // startVV and endVV
		
      // Test Imprecise Invalidate
      SingleWriterImpreciseInv ii1 = null;
      SingleWriterImpreciseInv ii2 = null;
		
      InvalTarget it1 = null;
      InvalTarget it2 = null;
      //pi1 = null;
      //pi2 = null;
      NodeId nodeId1 = null;
      String[] dir=new String[1];
      dir[0] = new String("/d1/obj1");
		
      ii1 = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget(dir),
                                         new AcceptStamp(10 , new NodeId(200)),
                                         new AcceptStamp(15 , new NodeId(200)) );
				   
      /////////////////////////////////////////////
      // case 0: empty log + one invalidate
      /////////////////////////////////////////////
      uncommitted.merge(ii1);
      
      uncommitted.verifyInvariants();
      
      //should be (10, 15)
      SingleWriterInval oldInv = (SingleWriterInval)(uncommitted.getOldest().getInv());
      SingleWriterInval newInv = ((SingleWriterInval)(uncommitted.getNewest().getInv()));
      assert( (uncommitted.getMinCounter() == ii1.getStart()));
      assert(uncommitted.getMaxCounter() == ii1.getEnd());
      assert (oldInv.getStart() == ii1.getStart());
      assert (newInv.getEnd() == ii1.getEnd());
      if(verbose){
	System.out.println("Pass Test 1.0");
      }
      /////////////////////////////////////////////////////////////
      // case 1.0: oler inv --> throw CausalOrderException
      /////////////////////////////////////////////////////////////
      
      
      /////////////////////////////////////////////////////////////
      // case 1.1: one item list log + invalidat.start = log.start
      // invalidate.end < log.end
      /////////////////////////////////////////////////////////////
      ii2 = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget(dir),
					 new AcceptStamp( 10, new NodeId(200)),
					 new AcceptStamp( 12, new NodeId(200)) );
      
      uncommitted.merge(ii2);
      
      //should be (10, 12)(13, 15).
      assert(uncommitted.getMinCounter() == ii1.getStart())
	&& (uncommitted.getMaxCounter() == ii1.getEnd())
	&& (((SingleWriterInval)(uncommitted.getOldest().getInv())).getEnd() == ii2.getEnd())
	&& (((SingleWriterInval)(uncommitted.getNewest().getInv())).getStart() == ii2.getEnd()+1);
				
      uncommitted.chopTail(10);
      if (verbose) uncommitted.getOldest().showList();
      //should be (10, 12)(13,15).
      assert(uncommitted.getMinCounter() == ii1.getStart());
      assert (uncommitted.getMaxCounter() == ii1.getEnd());
      assert (((SingleWriterInval)(uncommitted.getOldest().getInv())).getEnd() == ii2.getEnd());
      assert (((SingleWriterInval)(uncommitted.getNewest().getInv())).getStart() == ii2.getEnd()+1);
      if(verbose){
	System.out.println("Pass Test 1.1");
      }
      /////////////////////////////////////////////////////////////
      // case 1.2: one item list log == one invalidate
      /////////////////////////////////////////////////////////////
      
      ii2 = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget(dir),
					 new AcceptStamp( 11, new NodeId(200)),
					 new AcceptStamp( 12, new NodeId(200)) );
      
      uncommitted.merge(ii2);
      
      //should be (10, 10) (11, 12) (13, 15).
      assert (uncommitted.getMinCounter() == ii1.getStart());
      assert (uncommitted.getMaxCounter() == ii1.getEnd());
      assert (((SingleWriterInval)(uncommitted.getOldest().getInv())).getEnd() == ii2.getStart()-1);
      assert (((SingleWriterInval)(uncommitted.getNewest().getInv())).getStart() == ii2.getEnd()+1);
    
      uncommitted.verifyInvariants();
      
      uncommitted.chopTail(12);
      //should be (13, 15)
      
      
      assert( (uncommitted.getMinCounter() == 13)
	      && (uncommitted.getMaxCounter() == 15)
	      && (((SingleWriterInval)(uncommitted.getOldest().getInv())).getEnd() == 15)
	      && (((SingleWriterInval)(uncommitted.getNewest().getInv())).getStart() == 13 ));
      uncommitted.verifyInvariants();
      if(verbose){
	System.out.println("Pass Test 1.2");
      }
      /////////////////////////////////////////////////////////////
      // case 1.3: one item list log + one invalidate.start= log.start
      // inval.end > log.end
      /////////////////////////////////////////////////////////////
      ii2 = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget(dir),
					 new AcceptStamp(13 , new NodeId(200)),
					 new AcceptStamp(30, new NodeId(200)) );
      
      uncommitted.merge(ii2);
      
      //should be (13, 15)(16, 30) 
      assert( (uncommitted.getMinCounter() == 13)
	      && (uncommitted.getMaxCounter() == 30)
	      && (((SingleWriterInval)(uncommitted.getOldest().getInv())).getEnd() == 15)
	      && (((SingleWriterInval)(uncommitted.getNewest().getInv())).getStart() == 16 ));
      uncommitted.verifyInvariants();
      if(verbose){
	System.out.println("Pass Test 1.3");
      }
      /////////////////////////////////////////////////////////////
      // case 1.4.0: one item list log + one invalidate.end within
      // the item
      /////////////////////////////////////////////////////////////
      ii2 = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget(dir),
					 new AcceptStamp(20 , new NodeId(200)),
					 new AcceptStamp(25 , new NodeId(200)) );
      
      uncommitted.merge(ii2);
      
      //should be (13, 15)(16, 19)(20, 25)(26,30)
      assert( (uncommitted.getMinCounter() == 13)
	      && (uncommitted.getMaxCounter() == 30)
	      && (((SingleWriterInval)(uncommitted.getOldest().getInv())).getEnd() == 15)
	      && (((SingleWriterInval)(uncommitted.getNewest().getInv())).getStart() == 26));
      uncommitted.verifyInvariants();
      if(verbose){
	System.out.println("Pass Test 1.4.0");
      }
      /////////////////////////////////////////////////////////////
      // case 1.4.1: one item list log + one invalidate.start within
      // one item and end >log.end
      /////////////////////////////////////////////////////////////
      
      ii2 = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget(dir),
					 new AcceptStamp( 22, new NodeId(200)),
					 new AcceptStamp( 49, new NodeId(200)) );
      
      uncommitted.merge(ii2);
      
      //should be (13, 15)(16, 19)(20, 21)(22,25)(26, 30)(31, 49)
      uncommitted.verifyInvariants();
      assert( (uncommitted.getMinCounter() == 13)
	      && (uncommitted.getMaxCounter() == 49)
	      && (((SingleWriterInval)(uncommitted.getOldest().getInv())).getEnd() == 15)
	      && (((SingleWriterInval)(uncommitted.getNewest().getInv())).getStart() == 31 ));
      uncommitted.verifyInvariants();
      if(verbose){
	System.out.println("Pass Test 1.4.1");
      }
      ////////////////////////////////////////////////////////////////
      // case 1.5: one item list log + one invalidate.start =log.end
      ////////////////////////////////////////////////////////////////
      
      ii2 = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget(dir),
					 new AcceptStamp( 50, new NodeId(200)),
					 new AcceptStamp( 80, new NodeId(200)) );
      
      uncommitted.merge(ii2);
      
      //should be (13, 15)(16, 19)(20, 21)(22,25)(26, 30)(31, 49)(50, 80)
      uncommitted.verifyInvariants();
      assert( (uncommitted.getMinCounter() == 13)
	      && (uncommitted.getMaxCounter() == 80)
	      && (((SingleWriterInval)(uncommitted.getOldest().getInv())).getEnd() == 15)
	      && (((SingleWriterInval)(uncommitted.getNewest().getInv())).getStart() == 50 ));
      uncommitted.verifyInvariants();
      if(verbose){
	System.out.println("Pass Test 1.5");
      }
      /////////////////////////////////////////////////////////////
      // case 1.6: one item list log + one invalidate.start =log.end +1
      /////////////////////////////////////////////////////////////
      
      
      ii2 = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget(dir),
					 new AcceptStamp( 81, new NodeId(200)),
					 new AcceptStamp( 90, new NodeId(200)) );
      
      uncommitted.merge(ii2);
      
      //should be (13, 15)(16, 19)(20, 21)(22,25)(26, 30)(31, 49)(50, 80)(81,90) 
      assert(uncommitted.getMinCounter() == 13)//min
	&& (uncommitted.getMaxCounter() == 90)//max
	&& (((SingleWriterInval)(uncommitted.getOldest().getInv())).getEnd() == 15)//first end
	&& (((SingleWriterInval)(uncommitted.getNewest().getInv())).getStart() == 81); //last start
      uncommitted.verifyInvariants();
      if(verbose){
	System.out.println("Pass Test 1.6");
      }
      ///////////////////////////////////////////////////////////////////
      // case 1.7: one item list log + one invalidate.start >log.end +1
      // this is a special case for Uncommitted log that's different from
      // committed log.:::create dummy entry (91,94) to fill the gap
      ///////////////////////////////////////////////////////////////////
      
      
      ii2 = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget(dir),
					 new AcceptStamp( 95, new NodeId(200)),
					 new AcceptStamp( 100, new NodeId(200)) );
      
      uncommitted.merge(ii2);
      
      SingleWriterInval secondLastInv = null;
      secondLastInv = (SingleWriterInval)(uncommitted.getNewest().getOlder().getInv());
      //should be  (13, 15)(16, 19)(20, 21)(22,25)(26, 30)
      //			 (31, 49)(50, 80)(81,90)(91,94)(95,100); 
      assert(uncommitted.getMinCounter() == 13)//min
	&& (uncommitted.getMaxCounter() == 100)//max
	&& (((SingleWriterInval)(uncommitted.getOldest().getInv())).getEnd() == 15)//first end
	&& (((SingleWriterInval)(uncommitted.getNewest().getInv())).getStart() == 95 )//last start
	&& (secondLastInv.getInvalTarget().isEmpty()); 
      uncommitted.verifyInvariants();
      if(verbose){
	System.out.println("Pass Test 1.7");
      }
      //////////////////////////////////////////////////////////////////
      // case 2.0: multi item list log + one invalidate.start =log.start
      // inv.end within another item
      //////////////////////////////////////////////////////////////////
      
	
      ii2 = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget(dir),
					 new AcceptStamp( 20, new NodeId(200)),
					 new AcceptStamp( 70, new NodeId(200)) );
      
      uncommitted.merge(ii2);
      
      //should be  (13, 15)(16, 19)(20, 21)(22,25)(26, 30)
      //			 (31, 49)(50, 70)(71, 80)(81,90)(91,94)(95,100); 
      InvalListItem thirdLastItem = null;
      thirdLastItem = (InvalListItem)(uncommitted.getNewest().getOlder().getOlder().getOlder());
      SingleWriterInval thirdLastInv = null;
      thirdLastInv = (SingleWriterInval)(thirdLastItem.getInv());
      assert( (uncommitted.getMinCounter() == 13)//min
	      && (uncommitted.getMaxCounter() == 100)//max
	      && (thirdLastInv.getStart() == 71)); //last start
      uncommitted.verifyInvariants();
      if(verbose){
	System.out.println("Pass Test 2.0");
      }
      /////////////////////////////////////////////////////////////
      // case 2.1: multi item list log + one invalidate.start within
      // one item and inv.end within another item
      /////////////////////////////////////////////////////////////
      //This test should end up with CausalOrderException
      
      ii2 = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget(dir),
					 new AcceptStamp( 40, new NodeId(200)),
					 new AcceptStamp( 93, new NodeId(200)) );
      
      uncommitted.merge(ii2);
      InvalListItem thirdItem = null;
      thirdItem = uncommitted.getOldest().getNewer().getNewer().getNewer().getNewer().getNewer();
      
      secondLastInv=((SingleWriterInval)(uncommitted.getNewest().getOlder().getInv()));
      
      //should create CausalOrderExeption
      if (verbose) uncommitted.getOldest().showList();
      //should be  (13, 15)(16, 19)(20, 21)(22,25)(26, 30)
      //			 (31, 39)(40, 49)(50, 70)(71, 80)(81,90)(91, 93)(94,94)(95,100); 
      assert( (uncommitted.getMinCounter() == 13)//min
	      && (uncommitted.getMaxCounter() == 100)//max
	      && (((SingleWriterInval)thirdItem.getInv()).getEnd() == 39)//first end
	      && (secondLastInv.getStart() == 94 )); //last start
      uncommitted.verifyInvariants();
      if(verbose){
	System.out.println("Pass Test 2.1");
      }
      /////////////////////////////////////////////////////////////
      // case 2.2: two item list log + one invalidate.start == 
      // one item.end, inv.end = one item.end
      /////////////////////////////////////////////////////////////
      
	
      ii2 = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget(dir),
					 new AcceptStamp( 90, new NodeId(200)),
					 new AcceptStamp( 100, new NodeId(200)) );
      
      uncommitted.merge(ii2);
      //should create CausalOrderExeption
      
      //should be  (13, 15)(16, 19)(20, 21)(22,25)(26, 30)(31, 39)(40, 49)(50, 70)(71, 80)(81,89)
      //           (90, 90)(91, 93)(94,94)(95,100); 
      assert( (uncommitted.getMinCounter() == 13)//min
	      && (uncommitted.getMaxCounter() == 100)//max
	      && (((SingleWriterInval)(uncommitted.getNewest().getOlder().getOlder().getOlder().getInv())).getStart() == 90)); 
      uncommitted.verifyInvariants();
      if(verbose){
	System.out.println("Pass test 2: imprecise invalidate");
      }
      
      //---------------------------------------------------------------------------
      //     Test getNextByStart() ==> dummy entry is skipped.
      //---------------------------------------------------------------------------
      // for the current list, (91,94) is dummy entry.
      
      
      //add one more dummy entry
      ii2 = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget(dir),
					 new AcceptStamp( 110, new NodeId(200)),
					 new AcceptStamp( 120, new NodeId(200)) );
      
      uncommitted.merge(ii2);
      
      //should be  (13, 15)(16, 19)(20, 21)(22,25)(26, 30)
      //			 (31, 39)(40, 49)(50, 70)(71,80)(81,89)(90,90)
      //           |*(91,93)*||*(94, 94)*|(95,100)|*(101, 109)*|(110, 120); 
      assert( (uncommitted.getMinCounter() == 13)//min
	      && (uncommitted.getMaxCounter() == 120)//max
	      && (((SingleWriterInval)(uncommitted.getOldest().getInv())).getEnd() == 15)//first end
	      && (((SingleWriterInval)(uncommitted.getNewest().getOlder().getInv())).getStart() == 101 )//last start
	      && (((SingleWriterInval)(uncommitted.getNewest().getOlder().getInv())).getInvalTarget().isEmpty()));
      
      uncommitted.verifyInvariants();
      long oe = uncommitted.getOrderError(90);
      assert oe == 2;
      oe = uncommitted.getOrderError(0);
      assert oe ==13;
      oe = uncommitted.getOrderError(24);
      //System.err.println("OE:"+oe);
      assert oe == 10;
      
      
      if (vverbose) {
	System.out.println("testing getNextByStart");
	System.out.println(uncommitted.getNextByStart(80));
	//should be (81,89)
	System.out.println(uncommitted.getNextByStart(90));
	//should be (95,100)
	System.out.println(uncommitted.getNextByStart(95));
	//should be (95,100)
	System.out.println(uncommitted.getNextByStart(101));
	//should be (110,120)
	System.out.println(uncommitted.getNextByStart(111));
	//should be (110,120)
	System.out.println(uncommitted.getNextByStart(120));
	//should be null
      }
      assert( (((SingleWriterInval)(uncommitted.getNextByStart(80))).getEnd() == 89)
	      &&  (((SingleWriterInval)(uncommitted.getNextByStart(90))).getEnd() == 100)
	      &&  (((SingleWriterInval)(uncommitted.getNextByStart(95))).getEnd() == 100)
	      &&  (((SingleWriterInval)(uncommitted.getNextByStart(101))).getEnd() == 120)
	      &&  (((SingleWriterInval)(uncommitted.getNextByStart(111))).getEnd() == 120)
	      &&  ( uncommitted.getNextByStart(120) == null));
      if(verbose){
	System.out.println("Pass getNextByStart Test");
      }
      //-------------------------------------------------------
      // test findBoundInval
      if (verbose) {
	System.out.println(" uncommited =\n"+uncommitted.getOldest());
			  }
      
      if (verbose) System.out.println("Testing findBoundInval");
      
      bi1 = new BoundInval(new ObjId("/d1/obj1"),
			   10,
			   body1.getLength(),
			   new AcceptStamp(13, new NodeId(200)),
			   body1);
      
      bi2 = new BoundInval(new ObjId("/d1/obj1"),
			   10,
			   body1.getLength(),
			   new AcceptStamp(115, new NodeId(200)),
			   body1);
      
      bi3 = new BoundInval(new ObjId("/d1/obj1"),
			   10,
			   body1.getLength(),
			   new AcceptStamp(130, new NodeId(200)),
			   body1);
      
      pi1 = new PreciseInv(new ObjInvalTarget(new ObjId("/d1/obj1"), 10, 20),
			   new AcceptStamp(120, new NodeId(200)));
      
      pi2 = new PreciseInv(new ObjInvalTarget(new ObjId("/d1/obj1"), 10, 20),
			   new AcceptStamp(90, new NodeId(200)));
      
      ii2 = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget(dir),
					 new AcceptStamp( 131, new NodeId(200)),
					 new AcceptStamp( 140, new NodeId(200)) );
      
      
      //uncommitted.merge(bi3);	 
      
      uncommitted.merge(bi1);  //merge boundinval to imprecise inval
      uncommitted.merge(bi2);	 
      uncommitted.merge(bi3);	 
      uncommitted.merge(pi1); //merge precise inval to imprecise inval
      uncommitted.merge(pi2); 
      uncommitted.merge(ii2); //merge imprecise inval to precise inval
      
      bi3 = new BoundInval(new ObjId("/d1/obj1"),
			   10,
			   body1.getLength(),
			   new AcceptStamp(141, new NodeId(200)),
			   body1);
      uncommitted.merge(bi3);
      
      bi3 = new BoundInval(new ObjId("/d1/obj1"),
			   10,
			   body1.getLength(),
			   new AcceptStamp(145, new NodeId(200)),
			   body1);
      uncommitted.merge(bi3);
      
      //should be (13, 13 )(14,15)(16, 19)(20, 21)(22,25)(26,30)
      //			 (31, 39)(40, 49)(50, 70)(71,80)(81,89)(90,90)
      //           |*(91,93)*||*(94, 94)*|(95,100)|*(101, 109)*|(110, 114)(115, 115 )
      //			 (116, 119)(120, 120) |*(121, 129)*| (130, 130 b)(131, 140)(141, 141 b)
      //           (142, 144)(145, 145b); 
      
      
      if (verbose) {
	System.out.println(" uncommited =\n"+uncommitted.getOldest());
      }
      ubm = new UnbindMsg(new ObjInvalTarget(new ObjId("/d1/obj1"), 10, 5), 
			  new AcceptStamp(13, new NodeId(200)));
      
      if (verbose) {
	System.out.println("finding 13:");
	System.out.println(uncommitted.findBoundInval(ubm));//null
      }
      assert(uncommitted.findBoundInval(ubm) != null);
      
      ubm = new UnbindMsg(new ObjInvalTarget(new ObjId("/d1/obj1"), 10, 5), 
			  new AcceptStamp(115, new NodeId(200)));
      if (verbose) {
	System.out.println("finding 115:");
	System.out.println(uncommitted.findBoundInval(ubm));//null
      }
      assert(uncommitted.findBoundInval(ubm) != null);
      
      ubm = new UnbindMsg(new ObjInvalTarget(new ObjId("/d1/obj1"), 10, 5), 
			  new AcceptStamp(130, new NodeId(200)));
      if (verbose) {
	System.out.println("finding 130:");
	System.out.println(uncommitted.findBoundInval(ubm).getInv());//130
      }
      
      assert(((BoundInval)(uncommitted.findBoundInval(ubm).getInv())).getStart() == 130);
      
      ubm = new UnbindMsg(new ObjInvalTarget(new ObjId("/d1/obj1"), 10, 5), 
			  new AcceptStamp(120, new NodeId(200)));
      
      assert(uncommitted.findBoundInval(ubm) == null);
      
      ubm = new UnbindMsg(new ObjInvalTarget(new ObjId("/d1/obj1"), 10, 5), 
			  new AcceptStamp(141, new NodeId(200)));
      
      assert(((BoundInval)(uncommitted.findBoundInval(ubm).getInv())).getStart() == 141);
      
      ubm = new UnbindMsg(new ObjInvalTarget(new ObjId("/d1/obj1"), 10, 5), 
			  new AcceptStamp(145, new NodeId(200)));
      
      assert(((BoundInval)(uncommitted.findBoundInval(ubm).getInv())).getStart() == 145);
      
      
      
    } catch (CausalOrderException e){
      if (verbose) {
	System.out.println(e);
      }
      e.printStackTrace();
      assert false;
    }		
  }
  
  //----------------------------------------------------------------
  // test the track of totMemCharge through chopTail or merge
  //----------------------------------------------------------------
  public void testMemSize()
    throws Exception{
    SingleWriterLogUncommitted l = 
      new SingleWriterLogUncommitted(new NodeId(10));
    ObjInvalTarget oit;
    oit = new ObjInvalTarget(new ObjId(new String("/a")),
                             0,
                             500);
    
    PreciseInv pi = new PreciseInv(oit,
                                   new AcceptStamp(10, new NodeId(10)),
                                   new AcceptStamp(10, new NodeId(10)),
                                   false);

    byte[] data = new byte[500];
    BoundInval bi = new BoundInval(oit,
                                   new AcceptStamp(11, new NodeId(10)),
                                   new ImmutableBytes(data),
                                   0.2,
                                   new AcceptStamp(11, new NodeId(10)),
                                   false);

    UnbindMsg um = new UnbindMsg(oit,
                                 new AcceptStamp(11, new NodeId(10)));

    AcceptStamp[] as = new AcceptStamp[1];
    as[0] = new AcceptStamp(14, new NodeId(10));
    
    AcceptStamp[] as3 = new AcceptStamp[1];
    as3[0] = new AcceptStamp(100, new NodeId(10));
    
    HierInvalTarget hit = HierInvalTarget.makeHierInvalTarget("/a");
    SingleWriterImpreciseInv ii= new SingleWriterImpreciseInv(hit,
                                                              as[0],
                                                              as3[0],
                                                              as[0]);
    as[0] = new AcceptStamp(11, new NodeId(10));
    as3[0] = new AcceptStamp(20, new NodeId(10));
    SingleWriterImpreciseInv ii1= new SingleWriterImpreciseInv(hit,
                                                               as[0],
                                                               as3[0],
                                                               as[0]);

    as[0] = new AcceptStamp(30, new NodeId(10));
    as3[0] = new AcceptStamp(40, new NodeId(10));
    SingleWriterImpreciseInv ii2= new SingleWriterImpreciseInv(hit,
                                                               as[0],
                                                               as3[0],
                                                               as[0]);
    
    assert l.merge(pi) == 216;
    
    assert l.memSize() == 216;
    assert l.merge(bi) == 724;
    
    assert l.merge(ii) == 864;
    
    assert l.unbind(um);
   
    assert l.merge(ii1) == 528;
    
    assert l.merge(ii2) == 1056;
    
    assert l.chopTail(11) == 432;
    
    assert l.chopTail(30) == 1392;
    assert l.memSize() == 1056;
  }
  
  public void testIteratorCallbacks()
  throws Exception{
    //case 1: 1 log, 1 iter, write one, get one, write two, get two
    SingleWriterLogUncommitted log =
      new SingleWriterLogUncommitted(new NodeId(200));
    DummyInMemLogIterator iter1 = new DummyInMemLogIterator();
    iter1.addSingleWriterLogUncommitted(new NodeId(200), log);
    assert !iter1.hasNext();
    assert iter1.next() == null;
    
    log.register(iter1);
    
    PreciseInv pi1 = new PreciseInv(new ObjInvalTarget(new ObjId("/d1/obj1"), 
                                    10, 
                                    20),
                                    new AcceptStamp(0, new NodeId(200)));
    
    log.merge(pi1);
    assert iter1.hasNext();
    SingleWriterInval inv = iter1.next();
    assert inv.equals(pi1);
    assert !iter1.hasNext();
    
    PreciseInv pi2 = new PreciseInv(new ObjInvalTarget(new ObjId("/d1/obj1"), 
                                    10, 
                                    20),
                                    new AcceptStamp(1, new NodeId(200)));
    log.merge(pi2);
    assert iter1.hasNext();
    inv = iter1.next();
    assert inv.equals(pi2);
    assert !iter1.hasNext();
    
    //case 2: 2 log, 1 iter, write 1 pi, 1 ii to the second log, get 2
    SingleWriterLogUncommitted log2 =
      new SingleWriterLogUncommitted(new NodeId(300));
    
    DummyInMemLogIterator iter2 = new DummyInMemLogIterator();
    DummyInMemLogIterator iter3 = new DummyInMemLogIterator();
    iter2.addSingleWriterLogUncommitted(new NodeId(200), log);
    iter2.addSingleWriterLogUncommitted(new NodeId(300), log2);
    iter3.addSingleWriterLogUncommitted(new NodeId(200), log);
    iter3.addSingleWriterLogUncommitted(new NodeId(300), log2);
    iter1.addSingleWriterLogUncommitted(new NodeId(300), log2);
    HashSet iters = new HashSet();
    iters.add(iter1);
    iters.add(iter2);
    iters.add(iter3);
    log2.registerAll(iters);
    log.register(iter2);
    log.register(iter3);
    PreciseInv pi3 = new PreciseInv(new ObjInvalTarget(new ObjId("/300/obj1"), 
        10, 
        20),
        new AcceptStamp(0, new NodeId(300)));
    
    SingleWriterImpreciseInv ii4 = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
        new AcceptStamp( 1, new NodeId(300)),
        new AcceptStamp( 10, new NodeId(300)) );

    log2.merge(pi3);
    log2.merge(ii4);
    assert iter1.next().equals(pi3);
    assert iter1.next().equals(ii4);
    assert iter1.next() == null;
    
    
    //test getNextItemByStart
    InvalListItem nextItem = log2.getNextItemByStart(0);
    assert nextItem.getInv().equals(ii4);
    nextItem = log2.getNextItemByStart(-1);
    assert nextItem.getInv().equals(pi3);
    nextItem = log2.getNextItemByStart(1);
    assert nextItem.getInv().equals(ii4);
    nextItem = log2.getNextItemByStart(2);
    assert nextItem.getInv().equals(ii4);
    nextItem = log2.getNextItemByStart(10);
    assert nextItem==null;
    nextItem = log2.getNextItemByStart(11);
    assert nextItem == null;
    
    
    //now iter1 points to the end
    //    iter3 points to the start
    //make iter2 points to the first item
    assert iter2.next().equals(pi3);
    //case 3: log: 
    //        
    //        300: 0  1-10
    //    (1) merge: 300: 0-3
    //         
    //          0 1-3 4-10
    //          
    //          iter3 -> 0   next= 0
    //          iter2 -> 1    next = 1-3
    //          iter1 -> null    next = null
    //
    ii4 = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
        new AcceptStamp( 0, new NodeId(300)),
        new AcceptStamp( 3, new NodeId(300)) );

    log2.merge(ii4);
    SingleWriterImpreciseInv exptII = null;
    exptII = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
        new AcceptStamp( 1, new NodeId(300)),
        new AcceptStamp( 3, new NodeId(300)) );
    
    assert iter3.next().equals(pi3);
    SingleWriterInval iter2Next = iter2.next();
    assert iter2Next.equals(exptII): iter2Next + " exptected: " + exptII;
    
    assert iter1.next() == null;
    
    //    (2) merge: 300: 8-20
    //
    //               0 1-3 4-7 8-10 11-20
    //
    //          iter3 -> 1   next= 1-3
    //          iter2 -> 4    next = 4-7
    //          iter1 -> null    next = 11-20
    //
    
    ii4 = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
        new AcceptStamp( 8, new NodeId(300)),
        new AcceptStamp( 20, new NodeId(300)) );

    log2.merge(ii4);
    
    exptII = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
        new AcceptStamp( 1, new NodeId(300)),
        new AcceptStamp( 3, new NodeId(300)) );
    
    assert iter3.next().equals(exptII);
    exptII = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
        new AcceptStamp( 4, new NodeId(300)),
        new AcceptStamp( 7, new NodeId(300)) );
    
    iter2Next = iter2.next();
    assert iter2Next.equals(exptII): iter2Next + " exptected: " + exptII;
    
    exptII = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
        new AcceptStamp( 11, new NodeId(300)),
        new AcceptStamp( 20, new NodeId(300)) );
    
    SingleWriterInval iter1Next = iter1.next();
    assert iter1Next.equals(exptII): iter1Next + " exptected: " + exptII;
    assert iter1.next() == null;
    

    exptII = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
        new AcceptStamp( 8, new NodeId(300)),
        new AcceptStamp( 10, new NodeId(300)) );
    //      move iter2 one step to point to 11
    iter2.next().equals(exptII);
    
    //    (3) merge: 300: 18
    //           0 1-3 4-7 8-10 11-17 18 19-20
    //
    //          iter3 -> 4   next= 4-7 
    //          iter2 -> 11    next = 11-17
    //          iter1 -> null    next = null
    //
    ii4 = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
        new AcceptStamp( 18, new NodeId(300)),
        new AcceptStamp( 18, new NodeId(300)) );

    log2.merge(ii4);
    
    exptII = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
        new AcceptStamp( 4, new NodeId(300)),
        new AcceptStamp( 7, new NodeId(300)) );
    
    assert iter3.next().equals(exptII);
    exptII = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
        new AcceptStamp( 11, new NodeId(300)),
        new AcceptStamp( 17, new NodeId(300)) );
    
    iter2Next = iter2.next();
    assert iter2Next.equals(exptII): iter2Next + " exptected: " + exptII;
    
    
    assert iter1.next() == null;
    
    //    (4) merge: 300: 22
    //          iter2 -> 18    next = 18
    //          iter1 -> null    next = 22
    ii4 = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
        new AcceptStamp( 22, new NodeId(300)),
        new AcceptStamp( 22, new NodeId(300)) );

    log2.merge(ii4);
    
    
    exptII = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
        new AcceptStamp( 18, new NodeId(300)),
        new AcceptStamp( 18, new NodeId(300)) );
    
    iter2Next = iter2.next();
    assert iter2Next.equals(exptII): iter2Next + " exptected: " + exptII;
    
    exptII = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
        new AcceptStamp( 22, new NodeId(300)),
        new AcceptStamp( 22, new NodeId(300)) );
    
    assert iter1.next().equals(exptII);
    
  }
  
  public static void testPerformance()
  throws Exception{
    int nWrites = 10000;
    SingleWriterLogUncommitted l = 
      new SingleWriterLogUncommitted(new NodeId(10));
    ObjInvalTarget oit = null;
    oit = new ObjInvalTarget(new ObjId(new String("/a")),
                             0,
                             500);
    
    PreciseInv pi = null;
    long start = System.currentTimeMillis();
    for(int i = 0; i < nWrites; i++){
      pi = new PreciseInv(oit,
                          new AcceptStamp(i, new NodeId(10)),
                          new AcceptStamp(i, new NodeId(10)),
                          false);
      l.merge(pi);
    }
    long end = System.currentTimeMillis();
    System.out.println("---- " + nWrites + " merge takes:" + (end-start));
  }
  
  private static void makePractiConfig(){
    Config.createEmptyConfig();
    long NODE_0_ID = 0;
    long NODE_1_ID = 1;
    long NODE_2_ID = 2;
    long NODE_3_ID = 3;
    long NODE_4_ID = 4;
    String NODE_0_IP = "localhost";
    String NODE_1_IP = "localhost";
    String NODE_2_IP = "localhost";
    String NODE_3_IP = "localhost";
    String NODE_4_IP = "localhost";
    Config.addOneNodeConfig(new NodeId(NODE_0_ID),
                            NODE_0_IP,
                            9988,
                            9989,
                            9991,
                            9992,
                            9990,
                            "test" + File.separatorChar + "local-" + 
			    NODE_0_ID + ".db",
                            "/*",
                            -1L,
                            NODE_0_IP,
                            9993,
                            9994,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
 
   Config.addOneNodeConfig(new NodeId(NODE_1_ID),
			   NODE_1_IP,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "local-" + 
			   NODE_1_ID+".db",
			   "/*",
			   -1L,
			   NODE_1_IP,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);
   Config.addOneNodeConfig(new NodeId(NODE_2_ID),
			   NODE_2_IP,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "local-" + 
			   NODE_2_ID+".db",
			   "/*",
			   -1L,
			   NODE_2_IP,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);

   Config.addOneNodeConfig(new NodeId(NODE_3_ID),
			   NODE_3_IP,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "local-" + 
			   NODE_3_ID+".db",
			   "/*",
			   -1L,
			   NODE_3_IP,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);
    
   
   
   
   Config.addOneNodeConfig(new NodeId(NODE_4_ID),
			   NODE_4_IP,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "local-" + 
			   NODE_4_ID+".db",
			   "/*",
			   -1L,
			   NODE_4_IP,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);
   //Config.writeToFile(configPath);
  }

  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(SingleWriterLogUncommittedUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * usage: java <classname> [-verbose] [-vverbose] [testName]*
   * 
   *   If verbose or vverbose are included, print info to screen
   *
   *   If [testName]* are included, then run test called "test[testName]"
   *   for each such [testName]. E.g., "java SingleWriterLogUncommittedUnit foo" runs
   *   SingleWriterLogUncommittedUnit.testfoo() as a TestCase.
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "SingleWriterLogUncommittedUnit";
    System.err.print(name + " self test begins...");
    Env.verifyAssertEnabled();
    //
    // Default: run all tests
    //
    TestSuite ste = new TestSuite();
    Test test;
    boolean doAllTests = true;

    if(s.length > 0){
      int ii;
      for(ii = 0; ii < s.length; ii++){
        if(s[ii].equals("-verbose")){
          verbose = true;
        }
        else if(s[ii].equals("-vverbose")){
          verbose = true;
        }
        else{
          doAllTests = false;
          ste.addTest(new SingleWriterLogUncommittedUnit("test" + s[ii]));
        }
        
      }
    }
    if(doAllTests){
      test = suite();
    }
    else{
      test = ste;
    }
    TestRunner tr = new TestRunner();
    tr.doRun(test);
    //System.err.println(name + " self test succeeds");
    System.exit(0); 
  }

  class DummyInMemLogIterator implements InMemLogIterator{

    private SingleWriterLogPointers nextPointers;

    private CounterVV cvv;
    
    private HashMap<NodeId, SingleWriterLogUncommitted> perWriterLogs;
    
    public DummyInMemLogIterator(){
      cvv = new CounterVV();
      nextPointers = new SingleWriterLogPointers();
      perWriterLogs = new HashMap<NodeId, SingleWriterLogUncommitted>();
    }
    
    public DummyInMemLogIterator(VV vv, SingleWriterLogPointers p){
      cvv = new CounterVV(vv);
      nextPointers = p;
      perWriterLogs = new HashMap<NodeId, SingleWriterLogUncommitted>();
    }
    
    public void reset(){
      cvv = new CounterVV();
      nextPointers = new SingleWriterLogPointers();
    }

    public AcceptVV getCurrentVV(){
      return cvv.cloneAcceptVV();
    }
    
    public void addSingleWriterLogUncommitted(NodeId nid, SingleWriterLogUncommitted l){
      perWriterLogs.put(nid, l);
    }
    
    public void addPointer(NodeId nodeId, InvalListItem item){
      
      nextPointers.add(nodeId, item);
      System.out.println("get New item:" + nextPointers.toString());
    }

    public boolean hasNext(){
      return !(nextPointers.size()==0);
    }

    public SingleWriterInval next(){
      
      SingleWriterInval ret = null;
      if(vverbose){
	System.out.println("---before next:" + nextPointers.toString());
      }
      InvalListItem nextItem = nextPointers.min();
    
      if(nextItem != null){
        ret = (SingleWriterInval)nextItem.getInv();
        NodeId nid = ret.getNodeId();
        //update the pointers
        assert !this.cvv.includes(ret.getStartVV());
        this.cvv.advanceTimestamps(ret.getEndVV());
        InvalListItem newNextItem = nextItem.getNewer();
        if(newNextItem != null){
          while(newNextItem.isDummy()){
            newNextItem = newNextItem.getNewer();
            assert newNextItem != null;//no single writer log 
                                       //will end with a dummy inv
          }
          nextPointers.advance(nid, newNextItem);
        }else{//no new inval --> reach the end of the writer's updates

          //register in per-writer-log so that it will get a new one
          //whenever the writer gets a new update
          SingleWriterLogUncommitted log = perWriterLogs.get(nid);
          log.register(this);
          nextPointers.remove(nid, nextItem);
        }
      }
     if(vverbose){ 
      System.out.println("---after return next=" + ret 
          + "\n pointers= " + nextPointers.toString());
     } 
     return ret;
    }

    public void remove(){
      assert false; //not supported yet
    } //summarize all sent invals
  }
}
