package code;

 /** 
 *  SocketServer: Listens to incoming socket connections 
 **/ 
public class SocketServer
{
  private InvalStreamReceiver invalRecvr;
  //private CPReceiver cpRecvr;
  private BodyReceiver bodyRecvr;
  //private NiceReceiver niceRecvr;
  private SyncRplyReceiver syncRplyReceiver;

 /** 
 *  Right now we do the simple thing and 
 *  have a separate socket for each type   
 *  of incoming message that could affect our 
 *  state. It might be more efficient 
 *  to have a single socket and single thread 
 *  between each pair of nodes, but the buffering 
 *  (to enforce the required ordering constraints 
 *  across different message types) would be  
 *  trickier. (Also, we probably want the updates 
 *  on a low-priority channel.) 
 *  Note that the sync messages handled by the 
 *  syncReceiver don't affect our local state. 
 *  Originally, the plan was to just have a simple 
 *  RMI interface to call core.sync() on a remote 
 *  node, but the worry was that some RMI implementations 
 *  serialize calls at the clients, and the sync call 
 *  needs to block. 
 **/ 
  public SocketServer(Core core, Controller controller){
    invalRecvr = new InvalStreamReceiver(core, controller);
    invalRecvr.start();
    //cpRecvr = new CPReceiver(core, controller);
    //cpRecvr.start();
    bodyRecvr = new BodyReceiver(core, controller);
    bodyRecvr.start();
    //niceRecvr = new NiceReceiver(core, controller);
    //niceRecvr.start();
    syncRplyReceiver = new SyncRplyReceiver(core, controller);
    syncRplyReceiver.start();
  }

 /** 
 *  Shutdown -- tell all of the workers to close their sockets and 
 *  die. We use this primarily for testing code so that we can 
 *  run a series of unit tests in junit without conflicts for ports. 
 **/ 
  public void shutdown(){
    invalRecvr.shutdown();
    bodyRecvr.shutdown();
    //niceRecvr.shutdown();
    syncRplyReceiver.shutdown();
    
  }
  
 /** 
 *  Used for testing 
 **/ 
  public static void main(String[] argv){
/*
    InvalStreamReceiver ir = null;

    assert(argv.length > 1);
    NodeId myid = new NodeId(new Integer(argv[1]).intValue());
    Config.readConfig(argv[0]);
    RMIClient rmiClient = new RMIClient(); // Not used but needed for constructor
    new SocketServer(new InvalReceiverFakeCore(rmiClient, false, myid),
                     new LocalController(new InvalReceiverFakeCore(rmiClient, false, myid)));
*/
  }
}

//---------------------------------------------------------------------------
/* $Log */
//---------------------------------------------------------------------------
