package code;

 /** 
 *  Select someone to supply read misses 
 **/ 
public interface SpanningDirectory{

/*
 *------------------------------------------------------------------
 *
 *  getTargetAndSubscribeNotifyChanges --
 *
 *          Return node that is parent in the spanning tree for the
 *          specified interest set (or my node ID if I am the root 
 *          for that spanning tree).
 *
 *          Additionally, register a callback -- if my parent
 *          changes, the directory will call SpanningChangeHandler
 *
 * Arguments:
 *      SubscribeInvalRequest r -- identifies the spanning tree as well
 *                                 as info about the request (e.g., retry
 *                                 count)
 *      SpanningChangeHandler controllerToNotify -- who to callback on change
 *
 * Results:
 *      NodeId of parent in spanning tree
 *      null on error (caller should retry after timeout. No callback registered.)
 *      Return my own NodeId if I am the root of this spanning tree.
 *
 * Side effects:
 *      None.
 *
 *------------------------------------------------------------------
 */
public NodeId getTargetAndSubscribeNotifyChanges(SubscribeInvalRequest r, 
						 SpanningChangeHandler controllerToNotify);


}


//---------------------------------------------------------------------------
/* $Log: SpanningDirectory.java,v $
/* Revision 1.2  2004/05/13 18:49:37  dahlin
/* Fix ^M Formatting
/*
/* Revision 1.1  2004/05/13 18:49:17  dahlin
/* Clean SDIMSController by moving SpanningTree directory out as separate class (rather than using raw SDIMSInterface)
/*
 */
//---------------------------------------------------------------------------
