package code;

/* SplitJoinUnithelper.java
 * 
 * Helper for SplitJoinUnit -- when invoked by that code, start
 * a process that do the job for alpha, beta, or gamma according
 * to the parameter which is a nodeId predefined in SplitJoinUnit
 * 
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */


import java.util.*;
import java.io.*;

public class SplitJoinUnitHelper {
  private static boolean verbose = false;
  private static boolean vverbose = false;
  
  

 /** 
 *  Write the specified PRACTI files. Then wait until reading done. Then write
 
 *  more stuff. Then die. When restarted, read the old stuff and write some 
 
 *  different stuff.
 
 **/ 
  public static void main(String s[]) {
    
    if(s.length !=1){
      System.err.println("illegal argument for SplitJoinUnitHelper " + s.length);
      System.exit(-1);

    }else{
      long myNodeId = new Long(s[0]).longValue();
      if(myNodeId == SplitJoinUnit.ALPHA_ID){
	doAlpha();
      }else if(myNodeId == SplitJoinUnit.BETA_ID){
	doBeta(new NodeId(myNodeId));
      }else if(myNodeId == SplitJoinUnit.GAMMA_ID){
	doBeta(new NodeId(myNodeId));
      }else{
	System.err.println("illegal nodeId " + myNodeId + " for SplitJoinUnitHelper");
	System.exit(-1);
      }

    }
    
    System.exit(0);
  }
  

 /** 
 *  Beta/gamma, subscribe from alpha for "/a"/"c"
 
 **/ 
  private static void doBeta(NodeId myNodeId){
        
    NodeId alphaNodeId = new NodeId(SplitJoinUnit.ALPHA_ID);
    AcceptStamp finalStamp = new AcceptStamp(SplitJoinUnit.TOTALWRITES-1, alphaNodeId);
    String tag = null;
    SubscriptionSet ss = null;
    int bcID = 2;
    ObjId checkObj = null;
    ObjId impreciseObj = null;
    if(myNodeId.equals(new NodeId(SplitJoinUnit.BETA_ID))){
      tag = "BETA";
      ss = SubscriptionSet.makeSubscriptionSet("/a");
      checkObj = new ObjId("/a");
      impreciseObj = new ObjId("/c");
      bcID = 2;
    }else{
      tag = "GAMMA";
      ss = SubscriptionSet.makeSubscriptionSet("/c");
      checkObj = new ObjId("/c");
      impreciseObj = new ObjId("/a");
      bcID = 3;
    }

    BarrierClient c = new BarrierClient("127.0.0.1", SplitJoinUnit.BARRIER_PORT, bcID);

    if(vverbose){
      System.out.println(tag + " ID: " + myNodeId.toString());
    }
    assert(myNodeId.equals(new NodeId(SplitJoinUnit.BETA_ID)) 
	   || myNodeId.equals(new NodeId(SplitJoinUnit.GAMMA_ID)));

    URANode node = new URANode(SplitJoinUnit.CONFIG_PATH, myNodeId, 
                               Controller.NULL_CONTROLLER, true, true);
    
    node.getCore().setMaxAccumulateTime(2000);
    LocalInterface li = node.getLocalInterface();
    RMIClient ci = node.getRMIClientInterface();
    if(verbose){
      System.out.println("HELLO from " + tag + ": " + myNodeId);
    } 
    

    if(verbose){
      System.out.println("SplitJoinUnithelper " + tag + " constructor done");
    }
    
    try{
      c.sendBarrierRequest(0, bcID); // 1 We are up and running 
      if(verbose){
	System.out.println(" 1 All nodes up and running.");
      }
      
      
      //
      // Subscribe
      //
      try{
	ci.subscribeInval(alphaNodeId, myNodeId, ss, 
			  AcceptVV.makeVVAllNegatives(), false);
      }
      catch(Exception e){
	System.out.println("Exception on subscribe: " + e.toString());
	assert(false);
      }
      
      if(vverbose){
	System.out.println("Alpha::subscribe of subscribeId= " + ss
                         + " done.");
      }

      c.sendBarrierRequest(0, bcID);  // 2 beta and gamma subscribed from alpha and done
      if(verbose){
	System.out.println(" 2 Beta and gamma subscriptions from alpha are done");
      }
      
      //
      // wait syncCheck read /a|/c precise
      //
      SplitJoinUnit.syncCheck(finalStamp, node);
      
      //make sure /a or /c precise
      SplitJoinUnit.waitForPreciseInvalid(checkObj, li, tag);
      
      //make sure the other two objects imprecise
      assert !li.isPrecise(impreciseObj);
      assert !li.isPrecise(new ObjId("/b"));

      c.sendBarrierRequest(0, bcID);  // 3 beta and gamma subscribed from alpha and done
      if(verbose){
	System.out.println(" 3 Beta and gamma subscriptions from alpha are done");
      }
      
      
    
      c.sendBarrierRequest(0, bcID);  // 4 all finished
      if(verbose){
	System.out.println(" 4 all finish");
      }
    
    }finally{
      //
      // Make sure we release all of the ports and mem so that next
      // unit test can run.
      //
      node.shutdown();
      node = null;
      System.gc();
      
    }
  }
  
 /** 
 *  Alpha:
 
 *    Randomly issue SplitJoinUnit.TOTALWRITE writes to /a, /b, /c
 
 **/ 
  private static void doAlpha(){
    BarrierClient c = new BarrierClient("127.0.0.1", SplitJoinUnit.BARRIER_PORT, 1);
    NodeId myNodeId = new NodeId(SplitJoinUnit.ALPHA_ID);
      
    if(vverbose){
      System.out.println("ALPHA ID: " + myNodeId.toString());
    }
    assert(myNodeId.equals(new NodeId(SplitJoinUnit.ALPHA_ID)));
    URANode node = new URANode(SplitJoinUnit.CONFIG_PATH, myNodeId, 
                               Controller.NULL_CONTROLLER, true, true);
    
    node.getCore().setMaxAccumulateTime(4000);
    LocalInterface li = node.getLocalInterface();
    RMIClient ci = node.getRMIClientInterface();
    if(verbose){
      System.out.println("HELLO from Alpha: " + myNodeId);
    } 
    if(verbose){
      System.out.println("SplitJoinUnithelper alpha constructor done");
    }

    c.sendBarrierRequest(0, 1); // 1 We are up and running and Alpha has written; helpers are up
    if(verbose){
      System.out.println(" 1 All nodes up and running.");
    }

    c.sendBarrierRequest(0, 1); // 2 beta and gamma subscribe to alpha
    if(verbose){
      System.out.println(" 2 beta and gamma subscribe to alpha");
    }

    
    

    try{
      ObjId[] obj = new ObjId[3];
      obj[0] = new ObjId("/a");
      obj[1] = new ObjId("/b");
      obj[2] = new ObjId("/c");
      
      byte firstWriteByte = 32;
      byte lastWriteByte = 42;
    
      byte b1[] = new byte[1];
      b1[0] = firstWriteByte;

      byte b2[] = new byte[1];
      b2[0]= lastWriteByte;

      Random r = new Random();
      for(int i = 0; i < SplitJoinUnit.TOTALWRITES; i++){
	try{
	  int writeObj = r.nextInt(3);
	  li.write(obj[writeObj], 0, b1.length, b1, false);
	
	}catch(Exception e){
	  assert false: "Alpha write fail";
	}
      }

      if(verbose){
	System.out.println("Alpha wrote " + SplitJoinUnit.TOTALWRITES );
      }
      

      c.sendBarrierRequest(0, 1);  // 3 beta and gamma subscribed from alpha and done
      if(verbose){
	System.out.println(" 3 Beta and gamma subscriptions from alpha are done");
      }
    
      c.sendBarrierRequest(0, 1);  // 4 all finished
      if(verbose){
	System.out.println(" 4 All nodes finish");
      }
      
    }finally{
      //
      // Make sure we release all of the ports and mem so that next
      // unit test can run.
      //
      node.shutdown();
      node = null;
      System.gc();
      
    }
  }





}

//---------------------------------------------------------------------------
/*$Log: SplitJoinUnitHelper.java,v $
/*Revision 1.2  2007/07/04 21:47:48  zjiandan
/*fix unittests
/**/
//---------------------------------------------------------------------------
