package code;

import java.util.*;
import java.io.*;

public class Stats{
    
    static Hashtable h = new Hashtable();
    
    public static void reset(){
	h = new Hashtable();
    }

    public static synchronized Object put(Object type, long len){
	Long newL = null;
	Long oldL = (Long)h.get(type);
	if(oldL == null){
	    newL = new Long(len);
	} else {
	    newL = new Long(len + oldL.longValue());
	}
	return h.put(type, newL);
    }

    public static synchronized Object get(Object type){
	return h.get(type);
    }

    public static StatsRecord createRecord(){
	String s = null;
	long demandData = 0;
	long prefetchData = 0;
	long controlData = 0;
	long impreciseData = 0;
        long preciseData = 0;
	for(Enumeration e = h.keys(); e.hasMoreElements();){
	    s = (String)e.nextElement();
	    long l = ((Long)h.get(s)).longValue();
	    if(s.equalsIgnoreCase("Demand-BodyMsg")){
	      demandData += l;
	    } else if(s.equalsIgnoreCase("BodyMsg")){
	      prefetchData += l;
	    } else  if(s.startsWith("Imprecise-")){
              impreciseData += l;
            } else  if(s.startsWith("Precise-")){
              preciseData += l;
	    } else { 
		controlData += l;
	    }
	}
	return new StatsRecord(demandData,
			       prefetchData,
			       controlData,
			       impreciseData,
                               preciseData);
    }
	

    public static Hashtable getStats(){
	return h;
    }

 /** 
 *  CountBytes -- serialize an object to find its size and then increment 
 *                stats for specified tag 
 **/ 
  public static long countBytes(String tag, Object o){
    try{
      ByteArrayOutputStream baos;
      ObjectOutputStream buffer;
      baos = new ByteArrayOutputStream();	
      buffer = new ObjectOutputStream(baos);
      buffer.writeObject(o);
      buffer.flush();
      long len = baos.size();
      put(tag, len);
      return len;
    }
    catch(IOException e){
      put("IOException-in-countBytes-"+tag, Long.MAX_VALUE);
      return Long.MAX_VALUE;
    }
  }
  
}


/*$Log: Stats.java,v $
/*Revision 1.9  2007/07/15 06:21:29  zjiandan
/*optimize bw for cp exchange
/*
/*Revision 1.8  2007/03/15 21:58:31  dahlin
/*Added experimetn to test BW for subscribe for SOSP paper
/*
/*Revision 1.7  2005/01/13 22:41:15  zjiandan
/*fixed Makefile problem and add precise invalidate statistic collection facility.
/*
/*Revision 1.6  2004/05/23 22:04:46  nayate
/*Added accounting mechanisms for imprecise invalidates
/*
/*Revision 1.5  2004/05/19 20:43:11  lgao
/*Add StatsRecord class to maintain stats
/*
/*Revision 1.4  2004/05/15 00:23:17  lgao
/*Add flag to distingurish demand fetch from prefetch data.
/*
/*Revision 1.3  2004/05/13 01:12:35  nayate
/*Changed the code to not return null stats
/*
/*Revision 1.2  2004/05/12 20:44:24  lgao
/*Add rmi interface for distributed stats collection at the coordinator.
/*
/*Revision 1.1  2004/05/10 21:17:38  lgao
/*Initial implementation
/**/
