package code;

import java.io.BufferedWriter;
import java.io.FileWriter;

public class StatsRecord{
  long demandData;
  long prefetchData;
  long controlData;
  long impreciseData;
  long preciseData;
  
  public StatsRecord(long d, long p, long c, long i, long precise){
    demandData = d;
    prefetchData = p;
    controlData = c;
    impreciseData = i;
        this.preciseData = precise;
  }
  
  public long getTotal(){
    return (demandData + prefetchData + controlData + impreciseData
            + preciseData);
  }

    public StatsRecord getDiff(StatsRecord sr){
	return new StatsRecord(demandData - sr.demandData, 
			      prefetchData - sr.prefetchData,
			      controlData - sr.controlData,
			       impreciseData - sr.impreciseData,
                               preciseData - sr.preciseData);
    }

    public StatsRecord addStats(StatsRecord sr){
	return new StatsRecord(demandData + sr.demandData, 
			       prefetchData + sr.prefetchData,
			       controlData + sr.controlData,
			       impreciseData + sr.impreciseData,
                               preciseData + sr.preciseData);
    }

    public String toString(){
	String d = "Demand " + demandData;
	String p = "Prefetch " + prefetchData;
	String c = "Control " + controlData;
	String i = "Imprecise " + impreciseData;
        String precise = "Precise " + preciseData;
        long total = demandData + prefetchData + controlData + impreciseData
          + preciseData;
	return new String(d + " "+ p + " " + c + " " + i + " " + precise 
                          + "\n TOTAL: " + total 
                          + "  Invalidates: " + (impreciseData + preciseData));
    }
    
  public long getDemandData(){
    return demandData;
  }

  public long getPrefetchData(){
    return prefetchData;
  }

  public long getControlData(){
    return controlData;
  }

  public long getImpreciseData(){
    return impreciseData;
  }

  public long getPreciseData(){
    return preciseData;
  }

  
  public long getInvData(){
    return impreciseData + preciseData;
  }
    public void writeToFile(String filename){
	try{
	    BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
	    assert bw!=null;
	    bw.write(this.toString(), 0, this.toString().length());
	    bw.flush();
	    
	} catch (Exception e){
	    e.printStackTrace();
	    assert(false);
	}
    }
}

/*** 
$Log: StatsRecord.java,v $
Revision 1.11  2005/03/07 21:00:08  lgao
Planet lab exp check-in

Revision 1.10  2005/02/28 20:25:59  zjiandan
Added Garbage Collection code and part of Checkpoint exchange protocol code

****/

