package code;

 /** 
 *  StreamId: Used to store a Stream ID 
 **/ 

public class StreamId implements Comparable, Immutable
{
 /** 
 *  Data members 
 **/ 
  private long id;
  private static long nextId = 1;

 /** 
 *  Constructor (private; use makeNewStreamId()) 
 **/ 
  private
  StreamId(long newId){
    this.id = newId;
  }

 /** 
 *  Create a new StreamId 
 **/ 
  public static synchronized StreamId
  makeNewStreamId(){
    StreamId newStreamId = null;

    newStreamId = new StreamId(StreamId.nextId);
    StreamId.nextId++;
    return(newStreamId);
  }

 /** 
 *  Get the long ID stored in this instance (Used for testing) 
 **/ 
  public long
  getId(){
    return(this.id);
  }

 /** 
 *  Return -1, 0, 1 if this StreamId is less than, equal to, or greater 
 *  than, respectively, than the passed-in value 
 *  
 *  Note: "return(this.id - streamId.id);" could have worked 
 *  but might cause long-to-int conversion problems. 
 **/ 
  public int
  compareTo(Object o) throws ClassCastException{
    long val = 0;
    int retVal = 0;
    StreamId streamId = null;

    if(o instanceof StreamId){
      streamId = (StreamId)o;
      val = this.id - streamId.id;
      if(val < 0){
        retVal = -1;
      }else if(val > 0){
        retVal = 1;
      }else{
        retVal = 0;
      }
    }else{
      throw new ClassCastException();
    }
    return(retVal);
  }

 /** 
 *  Return true if the passed-in object is equal to this one. 
 **/ 
  public boolean
  equals(Object o){
    StreamId streamId = null;
    boolean eq = false;

    if(o instanceof StreamId){
      streamId = (StreamId)o;
      eq = (this.id == streamId.id);
    }else{
      throw new ClassCastException();
    }
    return(eq);
  }

 /** 
 *  Return a hashcode for this instance 
 **/ 
  public int
  hashCode(){
    Long idLong = null;

    idLong = new Long(this.id);
    return(idLong.hashCode());
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    StreamId.testMakeNewStreamId();
    StreamId.testEquals();
    StreamId.testCompareTo();
    StreamId.testHashCode();
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testMakeNewStreamId(){
    StreamId streamId1 = null;
    StreamId streamId2 = null;

    Env.verifyAssertEnabled();
    streamId1 = StreamId.makeNewStreamId();
    assert(streamId1.getId() == 1);
    streamId2 = StreamId.makeNewStreamId();
    assert(streamId2.getId() == 2);
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testEquals(){
    StreamId streamId1 = null;
    StreamId streamId2 = null;
    Object o = null;

    Env.verifyAssertEnabled();
    streamId1 = StreamId.makeNewStreamId();
    assert(streamId1.equals(streamId1));
    streamId2 = StreamId.makeNewStreamId();
    assert(!streamId1.equals(streamId2));
    assert(!streamId2.equals(streamId1));
    assert(streamId2.equals(streamId2));
    try{
      o = new Integer(1);
      streamId1.equals(o);
      // Should not be here; previous line should have thrown an exception
      assert(false);
    }catch(ClassCastException e){
      // Do nothing; correct behavior
    }
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testCompareTo(){
    StreamId streamId1 = null;
    StreamId streamId2 = null;

    Env.verifyAssertEnabled();
    streamId1 = StreamId.makeNewStreamId();
    streamId2 = StreamId.makeNewStreamId();

    assert(streamId1.compareTo(streamId2) < 0);
    assert(streamId2.compareTo(streamId1) > 0);
    assert(streamId1.compareTo(streamId1) == 0);
    assert(streamId2.compareTo(streamId2) == 0);
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testHashCode(){
    StreamId streamId1 = null;
    StreamId streamId2 = null;

    Env.verifyAssertEnabled();
    streamId1 = StreamId.makeNewStreamId();
    streamId2 = StreamId.makeNewStreamId();

    assert(streamId1.hashCode() == streamId1.hashCode());
    assert(streamId2.hashCode() == streamId2.hashCode());
    assert(streamId1.hashCode() != streamId2.hashCode());
  }
}
