package code;

//package utils.junit;

import junit.textui.TestRunner;
import junit.framework.*;
import java.util.*;

/**
 * TBD: Update class name
 */
public class StreamIdUnit extends TestCase {
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  protected static boolean verbose = false; // Start/end of test
  protected static boolean vverbose = false; // Test internals
  
  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public StreamIdUnit (final String s) {
    super (s);
  }

  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
    /* 
     * TBD: Insert other fixture code here
     * e.g., this.objectUnderTest = new ClassToBeTested(...);
     */
  }

  protected void tearDown() throws Exception{
    /* 
     * TBD: Insert other fixture cleanup code here
     */
    super.tearDown();
  }

  /* 
   * Test the makeNewStreamId() method
   */
  public void testMakeNewStreamId(){
    StreamId streamId1 = null;
    StreamId streamId2 = null;

    Env.verifyAssertEnabled();
    streamId1 = StreamId.makeNewStreamId();
    streamId2 = StreamId.makeNewStreamId();
    assert(streamId2.getId() != streamId1.getId());
  }

  /* 
   * Test the equals() method
   */
  public void testEquals(){
    StreamId streamId1 = null;
    StreamId streamId2 = null;
    Object o = null;

    Env.verifyAssertEnabled();
    streamId1 = StreamId.makeNewStreamId();
    assert(streamId1.equals(streamId1));
    streamId2 = StreamId.makeNewStreamId();
    assert(!streamId1.equals(streamId2));
    assert(!streamId2.equals(streamId1));
    assert(streamId2.equals(streamId2));
    try{
      o = new Integer(1);
      streamId1.equals(o);
      // Should not be here; previous line should have thrown an exception
      assert(false);
    }catch(ClassCastException e){
      // Do nothing; correct behavior
    }
  }
  
  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(StreamIdUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * usage: java <classname> [-verbose] [-vverbose] [testName]*
   * 
   *   If verbose or vverbose are included, print info to screen
   *
   *   If [testName]* are included, then run test called "test[testName]"
   *   for each such [testName]. E.g., "java TestEmtpy foo" runs
   *   StreamIdUnit.testfoo() as a TestCase.
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "StreamIdUnit";
    System.err.print(name + " self test begins...");
    //
    // Default: run all tests
    //
    TestSuite ste = new TestSuite();
    Test test;
    boolean doAllTests = true;

    if(s.length > 0){
      int ii;
      for(ii = 0; ii < s.length; ii++){
        if(s[ii].equals("-verbose")){
          verbose = true;
        }
        else if(s[ii].equals("-vverbose")){
          verbose = true;
        }
        else{
          doAllTests = false;
          ste.addTest(new RandomAccessStateUnit("test" + s[ii]));
        }
        
      }
    }
    if(doAllTests){
      test = suite();
    }
    else{
      test = ste;
    }
    TestRunner tr = new TestRunner();
    tr.doRun(test);
    System.err.println(name + " self test succeeds");
  }

}
