package code;

 /** 
 *  Represent a pool of streams 
 **/ 
import java.util.Hashtable;

public class StreamPool
{
  private Hashtable ht;
  private NodeId myNodeId;
  private static final boolean dbg = false;

    //
    // Because of network latencies, locking is a bit weird.
    // the public method (send) is not synchronized
    // helper functions accessing the hash table are synchronized
    // the streams themselves are also synchronized
    //

 /** 
 *  Constructor 
 **/ 
    public StreamPool(NodeId myid){
	ht = new Hashtable();
        myNodeId = myid;
    }

 /** 
 *  Send msg to the machine with address dns:port 
 **/ 
    public void send(String dns, int port, Object msg)
	throws UnableToConnectException
    {
        NetAddr netAddr = new NetAddr(dns, port);
        //Env.dprintln(false, "StreamPool: trying to send to "+ netAddr);
	ReconnectConnection rc = getReconnectConnection(netAddr);
	rc.send(msg);
    }

 /** 
 *  Return a new ReconnectConnection object 
 **/ 
    private synchronized ReconnectConnection
	getReconnectConnection(NetAddr netAddr) throws UnableToConnectException
    {
	ReconnectConnection rc = (ReconnectConnection)ht.get(netAddr);

	if(rc == null){
          rc = new ReconnectConnection(netAddr, myNodeId);
	    ht.put(netAddr, rc);
	}
	return rc;
    }
}

//---------------------------------------------------------------------------
/* $Log: StreamPool.java,v $
/* Revision 1.11  2007/04/02 21:11:39  zjiandan
/* snapshort for sosp2007.
/*
/* Revision 1.10  2006/08/15 21:46:24  dahlin
/* Added PicShare Reader and a simple unit test.
/*
/* Revision 1.9  2006/06/14 22:50:09  nalini
/* Changed nice sockets to normal sockets for outgoing body connections
/*
/* Revision 1.8  2006/04/20 03:52:53  zjiandan
/* Callbacks merged with runTime.
/*
/* Revision 1.7  2005/10/13 00:24:24  zjiandan
/* remove Config.getMy* fixed Garbage Collection and Checkpoint exchange code
/*
/* Revision 1.6  2004/05/14 00:12:43  zjiandan
/* Changes for second experiments.
/*
/* Revision 1.5  2004/04/30 19:18:17  nayate
/* Minor comment changes
/*
/* Revision 1.4  2004/04/26 23:08:47  nayate
/* Finished but haven't tested StreamPool.java
/*
/* Revision 1.3  2004/04/19 23:30:05  lgao
/* Initial implementation of the RMI package and modification to Makefile.
/*
/* Revision 1.2  2004/04/15 20:04:25  nayate
/* New Makefile; added provision to allow CVS to append file modification
/* logs to files.
/* */
//---------------------------------------------------------------------------
