package code;

/* SubscribeBWUnitHelper.java
 * 
 * Helper for SubscribeBWUnit -- when invoked by that code, start
 * a PicShareWriterProcess that writes a bunch of known files.
 * 
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */

import java.util.*;
import java.io.*;
import code.security.SecureURANode;
import code.security.holesync.filter.Filter;
import code.security.holesync.filter.SubscriptionSetFilter;

public class SubscribeBWUnitHelper {
  private static boolean verbose = true;
  private static boolean vverbose = true;

  private static Core core;

 /** 
 *  Write the specified PRACTI files. Then wait until reading done. Then write
 
 *  more stuff. Then die. When restarted, read the old stuff and write some 
 
 *  different stuff.
 
 **/ 
  public static void main(String s[]) {
    doFirst();
    System.exit(0);
  }

 /** 
 *  First time around -- write a bunch of stuff.
 
 **/ 
  private static void doFirst(){
    BarrierClient c = new BarrierClient("127.0.0.1", SubscribeBWUnit.BARRIER_PORT, 1);
    NodeId myNodeId = new NodeId(SubscribeBWUnit.HELPER_NODE_ID);
    NodeId unitNodeId = new NodeId(SubscribeBWUnit.UNIT_NODE_ID);
    int ni = SubscribeBWUnit.ni;
    int nj = SubscribeBWUnit.nj;
    int nk = SubscribeBWUnit.nk;
  
    if(vverbose){
      System.out.println("UNIT ID: " + myNodeId.toString());
    }
    assert(myNodeId.equals(new NodeId(SubscribeBWUnit.HELPER_NODE_ID)));
    
    URANode node;
    if(SubscribeBWUnit.useSecure){
      SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
      LinkedList<Filter> f = new LinkedList<Filter>();
      f.add(ssf);
      node = new SecureURANode(SubscribeBWUnit.CONFIG_PATH, myNodeId, 
          Controller.NULL_CONTROLLER, 
          true,//cleanDB 
          true,
          new code.security.liveness.TrustedServerTraceLivenessFilter(null), 
          f);//noSynLog
    }else{
       node = new URANode(SubscribeBWUnit.CONFIG_PATH, myNodeId, 
          Controller.NULL_CONTROLLER, 
          true,//cleanDB 
          true);//noSynLog
    }
    // make sure the accumulate time is long enoug so that we don't
    // get PInvals when we are expecting ImpInval
    core = node.getCore();
    node.getCore().setMaxAccumulateTime(2000);
    LocalInterface li = node.getLocalInterface();
    RMIClient ci = node.getRMIClientInterface();
    if(verbose){
      System.out.println("HELLO from SubscribeBWUnitHelper");
    }


    if(verbose){
      System.out.println("SubscribeBWUnitHelper constructor done");
    }

    if(verbose){
      System.out.println("barrier 1");
    }
    c.sendBarrierRequest(0, 1); // 1 Tell SubscribeBWUnit that we are up and running

    String waitPath = SubscribeBWUnit.COARSE_PATH + "/"+(ni-1)+"/"+(nj-1)+"/"+(nk-1);

    if(verbose){
      System.out.println("Both nodes up and running. Initial " + ni*nj*nk + " writes done.");
      System.out.println("Helper will wait to see " +  ni*nj*nk + " writes " + waitPath);
    }
    try{
      if(verbose){
        System.out.println("3 wait for " + waitPath);
      }
      SubscribeBWUnit.subscribeAndWait(SubscribeBWUnit.COARSE_PATH +"/*", 
				       unitNodeId, myNodeId,
				       waitPath,
				       li, ci,
				       true);
      
     if(verbose){ 
        System.out.println("3 wait for return " + waitPath);
	System.out.println("Helper has subscribed and received " + ni*nj*nk + " invals");
      }
      c.sendBarrierRequest(0, 1);  // 2
      if(verbose){ 
          System.out.println("Helper going to write COARSE_PATH");
        }
      
//      SubscribeBWUnit.write(SubscribeBWUnit.COARSE_PATH, 
//			    0, SubscribeBWUnit.ni-1,
//			    0, SubscribeBWUnit.nj-1,
//			    0, 0,
//			    li);
      
      SubscribeBWUnit.resetStats();
      
      if(verbose){
	System.out.println("Helper has updated " + ni*nj + " objects");
      }
      c.sendBarrierRequest(0, 1); 

      // unit does reset stats, subscribe and wait, print stats
      
      c.sendBarrierRequest(0, 1);  // 98
      if(verbose){
	System.out.println("Unit has received " + ni*nj + " invals. Helper grabbing stats");
      }
      
      SubscribeBWUnit.printStats("TOTAL_BW_COARSE_HELPER " + ni*nj*nk);
      

      c.sendBarrierRequest(0, 1);  // 99 Make sure helper has stats

      int ipass; 
      String passTag;
      boolean catchupWithCP;
      for(ipass = 0; ipass < 2; ipass++){
        if(ipass == 0){
          passTag = "LOG";
          //core.setCatchupTypeToCP(false);
          if(SubscribeBWUnit.useSecure)
          {
        	  catchupWithCP = true;
          }
          else
          {
        	  catchupWithCP = false;
          }
        }
        else{
          passTag = "CHECKPOINT";
          //core.setCatchupTypeToCP(true);
	  catchupWithCP = true;
        }

        String FINE_PATH = SubscribeBWUnit.FINE_PATH_PREFIX + passTag;

        c.sendBarrierRequest(0, 1);  // 100 Unit did write of ni*nj*nk objects
        waitPath = FINE_PATH +"/"+ (ni-1)+"/"+(nj-1)+"/"+(nk-1);
        if(verbose){
          System.out.println("Waiting for write of " + waitPath 
                             + " (" + passTag + ")");
        }
        if(verbose){ 
	  System.out.println("4 wait for " + waitPath);
        }
	SubscribeBWUnit.subscribeAndWait(FINE_PATH+"/*", 
                                         unitNodeId, myNodeId,
                                         waitPath,
                                         li, ci, catchupWithCP);
	if(verbose){
	  System.out.println("4 wait for " + waitPath);
          System.out.println("Got write of " + FINE_PATH + (ni-1)+"/"+(nj-1)+"/"+(nk-1)
                             + " (" + passTag + ")");
        }
        c.sendBarrierRequest(0, 1);  // 101 Helper read ni*nj*nk objects
      
        if(verbose){
          System.out.println("Doing write of various in " + FINE_PATH 
                             + (ni-1)+"/"+(nj-1)+"/*"
                             + " (" + passTag + ")");
        }
//        SubscribeBWUnit.write(FINE_PATH, 
//                              0, SubscribeBWUnit.ni-1,
//                              0, SubscribeBWUnit.nj-1,
//                              0, SubscribeBWUnit.nk-1,
//                              li);
      
        System.out.println("**********TBD: update helper to only write right number of objects *****");
      
        if(verbose){
          System.out.println("Done writing various in " + FINE_PATH + "/9/9/*");
        }
        c.sendBarrierRequest(0, 1);  // 102 Helper wrote ni*nj objects
        SubscribeBWUnit.resetStats();
        c.sendBarrierRequest(0, 1);  // 103 Everyone reset stats
        int ii;
        for(ii = 0; ii <  ni*nj*nk; ii++){
          c.sendBarrierRequest(0, 1);  // 104 Unit done reading [ii]
          SubscribeBWUnit.printStats("TOTAL_BW_FINE_HELPER " + ii + " " + passTag);
          c.sendBarrierRequest(0, 1);  // 105 done stats [ii]
        }
        c.sendBarrierRequest(0, 1);  // 106; done
      }
    }finally{
      //
      // Make sure we release all of the ports and mem so that next
      // unit test can run.
      //
      node.shutdown();
      node = null;
      System.gc();
      
    }
  }





}
