package code;

 /** 
 *  SubscriptionRequest.java -- 
 *    Msg marks the start of a Checkpoint stream. 
 **/ 
public class SubscriptionRequest{

  final public static short CP = 0;
  final public static short LOG = 1;
  final public static short REMOVE = 2;
  private final SubscriptionSet ss;
  private final AcceptVV startVV;
  private short type;
  private boolean includeBodiesIfCPSent;
//  private boolean includeAll;
// /** 
// *  Constructor 
// **/ 
//  public SubscriptionRequest(short type, SubscriptionSet ss, AcceptVV startVV,
//                             boolean includeCPBodies/*, boolean includeAll*/){
//    this.type = type;
//    this.ss = ss;
//    this.startVV = startVV;
//    this.includeBodiesIfCPSent = includeCPBodies;
////    this.includeAll = includeAll;
//  }
//  
  /** 
   *  Constructor 
   **/ 
    public SubscriptionRequest(short type, SubscriptionSet ss, AcceptVV startVV,
                               boolean includeCPBodies){
      this.type = type;
      this.ss = ss;
      this.startVV = startVV;
      this.includeBodiesIfCPSent = includeCPBodies;
//      this.includeAll = false;
    }

  public SubscriptionSet getSubscriptionSet(){
    return this.ss;
  }

  public AcceptVV getStartVV(){
    return this.startVV;
  }

  public short getType(){
    return this.type;
  }

  public boolean getCPBodies(){
    return includeBodiesIfCPSent;
  }

 /** 
 *  Convert this exception to a string 
 **/ 
  public String toString(){
    String typeStr = "CP";
    if(type == LOG){
      typeStr = "LOG";
    }else if(type == REMOVE){
      typeStr = "REMOVE";
    }else if(type == CP){
      typeStr = "CP";
    }else{
      assert false;
    }
    return("SubscriptionRequest: (" + typeStr + ", " 
	   + ss + ", " + startVV + " )" );
  }
//
//public boolean isIncludeAll(){
//  return includeAll;
//}
}

//---------------------------------------------------------------------------
/* $Log: SubscriptionRequest.java,v $
/* Revision 1.2  2007/05/30 20:30:19  dahlin
/* Added checkpoint to SubscribeBWUnit. Changed outgoingconnection checkpoint send to not send body by default. Told barrier to close sockets when done with them.
/*
/* Revision 1.1  2006/04/20 03:52:53  zjiandan
/* Callbacks merged with runTime.
/* */
//---------------------------------------------------------------------------
