package code;

 /** 
 *  Unit test for SubscriptionSetUnit
 
 **/ 

import junit.textui.TestRunner;
import junit.framework.*;
import java.util.*;
import java.io.*;

/**
 * TBD: Update class name
 */
public class SubscriptionSetUnit extends TestCase {
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  protected static boolean verbose = false; // Start/end of test
  protected static boolean vverbose = false; // Test internals
  // private Process rmiregistry;
  
  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public SubscriptionSetUnit (final String s) {
    super (s);
  }


  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
    
    /*
    //
    // Start the registry
    //
    rmiregistry = Runtime.getRuntime().exec("rmiregistry");
    Env.dprintln(verbose, "rmiregistry started");
    Thread.sleep(2000);
    */
  }

  protected void tearDown() throws Exception{
    /*
    rmiregistry.destroy();
    */
    super.tearDown();
    
  }



 /** 
 *  Test basic functions
 
 **/ 
  public void testBasics(){
    
    
    SubscriptionSet ss = null;
    SubscriptionSet ss2 = null;
    SubscriptionSet ss3 = null;
    SubscriptionSet ssChild1 = null;
    SubscriptionSet ssGChild1 = null;
    SubscriptionSet ssGChild2 = null;
    Iterator childValues = null;
    String allNames[] = null;


    // Test data structure integrity
    ss = SubscriptionSet.makeSubscriptionSet("/a/b:/a/c:/a/b/*");
    assert((ss.getChildrenSize() == 1) && (ss.getChild("a")!=null));
    ssChild1 = (SubscriptionSet)ss.getChild("a");
    assert((ssChild1.getChildrenSize() == 2) &&
           (ssChild1.getChild("b")!=null) &&
           (ssChild1.getChild("c")!=null));
    ssGChild1 = (SubscriptionSet)ssChild1.getChild("b");
    assert(ssGChild1.hasNoChildren());
    assert((ssGChild1.containsSelf()) && (ssGChild1.containsChildren()));
    ssGChild2 = (SubscriptionSet)ssChild1.getChild("c");
    assert(ssGChild2.hasNoChildren());
    assert((ssGChild2.containsSelf()) && (!ssGChild2.containsChildren()));

    // Test simple methods
    assert(!ss.hasNoChildren());
    assert(ssGChild2.hasNoChildren());
    assert(ssGChild1.containsChildren());
    assert(!ssGChild2.containsChildren());
    assert(ssGChild1.containsSelf());
    assert(ssGChild2.containsSelf());
    assert(!ss.containsSelf());
    assert(ss.getChild("a") == ssChild1);
    assert(ssChild1.getChild("b") == ssGChild1);

    childValues = (ssChild1.getChildValues()).iterator();
    assert(childValues.hasNext());
    ss2 = (SubscriptionSet)childValues.next();
    assert((ss2 == ssGChild1) || (ss2 == ssGChild2));
    assert(childValues.hasNext());
    ss3 = (SubscriptionSet)childValues.next();
    assert((ss3 == ssGChild1) || (ss3 == ssGChild2));
    assert(ss2 != ss3);
    assert(!childValues.hasNext());

    // Test the second version of makeSubsciptionSet, equals(), and hashCode()
    allNames = new String[1];
    allNames[0] = "/a/b/c";
    ss = SubscriptionSet.makeSubscriptionSet(allNames);
    ss2 = SubscriptionSet.makeSubscriptionSet("/a/b/c");
    assert(ss.equals(ss2));
    assert(ss2.equals(ss));
    assert(ss.hashCode() == ss2.hashCode());

    allNames = new String[4];
    allNames[0] = "/a/b/c";
    allNames[1] = "/a/b";
    allNames[2] = "/e/f/*";
    allNames[3] = "/g/*";
    ss = SubscriptionSet.makeSubscriptionSet(allNames);
    ss2 = SubscriptionSet.makeSubscriptionSet("/a/b/c:/a/b:/e/f/*:/g/*");
    assert(ss.equals(ss2));
    assert(ss2.equals(ss));
    assert(ss.hashCode() == ss2.hashCode());

    allNames = new String[2];
    allNames[0] = "/a/b/*";
    allNames[1] = "/a/d/c";
    ss = SubscriptionSet.makeSubscriptionSet(allNames);
    ss2 = SubscriptionSet.makeSubscriptionSet("/a/d/*:/a/b");
    assert(!ss.equals(ss2));
    assert(!ss2.equals(ss));
    // Note: This last test need not be true! (But it should be true
    // with high probability)
    assert(ss.hashCode() != ss2.hashCode());

  }


  //-------------------------------------------------------------------------
  // Test the containsExactlyOneSubdirectory() method
  //-------------------------------------------------------------------------
  public void
  testContainsExactlyOneSubdirectory(){
    SubscriptionSet ss = null;

    ss = SubscriptionSet.makeSubscriptionSet("/a/b/c/*");
    assert(ss.containsExactlyOneSubdirectory());

    ss = SubscriptionSet.makeSubscriptionSet("/a/b/c");
    assert(ss.containsExactlyOneSubdirectory());

    ss = SubscriptionSet.makeSubscriptionSet("/a/b/c:/a/b");
    assert(!ss.containsExactlyOneSubdirectory());

    ss = SubscriptionSet.makeSubscriptionSet("/a/b/c:/a/b/d/*");
    assert(!ss.containsExactlyOneSubdirectory());
  }


  //-------------------------------------------------------------------------
  // Test the containsExactlyOneSubdirectory() method
  //-------------------------------------------------------------------------
  public void
  testGetParentSS(){
    SubscriptionSet ss = null;
    SubscriptionSet parentSS = null;
    SubscriptionSet endSS = null;
    SubscriptionSet ssClone = null;
    SubscriptionSet ssCloneChild = null;
    SubscriptionSet ssCloneGChild = null;
    SubscriptionSet ssCloneGGChild = null;

    // Start by testing cloneUntilEndSS
    ss = SubscriptionSet.makeSubscriptionSet("/a/b/c");
    endSS = (SubscriptionSet)ss.getChild("a");
    endSS = (SubscriptionSet)endSS.getChild("b");
    ssClone = ss.cloneUntilEndSS(endSS, true, false);
    ssCloneChild = ssClone.getChild("a");
    assert(ssCloneChild != null);
    ssCloneGChild = ssCloneChild.getChild("b");
    assert(ssCloneGChild != null);
    assert(ssCloneGChild.hasNoChildren());

    // Test 2
    ss = SubscriptionSet.makeSubscriptionSet("/a/b/c/d/*");
    endSS = (SubscriptionSet)ss.getChild("a");
    assert(endSS != null);
    endSS = (SubscriptionSet)endSS.getChild("b");
    assert(endSS != null);
    endSS = (SubscriptionSet)endSS.getChild("c");
    assert(endSS != null);
    ssClone = ss.cloneUntilEndSS(endSS, false, true);
    ssCloneChild = ssClone.getChild("a");
    assert(ssCloneChild != null);
    ssCloneGChild = ssCloneChild.getChild("b");
    assert(ssCloneGChild != null);
    ssCloneGGChild = ssCloneGChild.getChild("c");
    assert(ssCloneGGChild != null);
    assert(ssCloneGGChild.hasNoChildren());

    // Test getParentSS()
    ss = SubscriptionSet.makeSubscriptionSet("/a/b/c");
    parentSS = ss.getParentSS();
    assert(parentSS.containsExactlyOneSubdirectory());
    assert(parentSS.getChild("a") != null);
    assert((parentSS.getChild("a")).getChild("b") != null);
    assert((parentSS.getChild("a")).getChild("b").hasNoChildren());
    assert((parentSS.getChild("a")).getChild("b").containsSelf());
    assert(!(parentSS.getChild("a")).getChild("b").containsChildren());

    ss = SubscriptionSet.makeSubscriptionSet("/f/g/h/e/l/*");
    parentSS = ss.getParentSS();
    assert(parentSS.equals(SubscriptionSet.makeSubscriptionSet("/f/g/h/e/*")));
  }

  //-------------------------------------------------------------------------
  // Test the remove() method
  //-------------------------------------------------------------------------
  public void
  testRemove(){
    SubscriptionSet ss1 = null;
    SubscriptionSet ss2 = null;
    SubscriptionSet ss3 = null;

    try{
      // Test 1
      // ":/a:/a/*" - ":/a" == "/a/*"
      ss1 = SubscriptionSet.makeSubscriptionSet(":/a:/a/*");
      ss2 = SubscriptionSet.makeSubscriptionSet(":/a");
      ss3 = SubscriptionSet.makeSubscriptionSet("/a/*");
      assert(ss1.remove(ss2, true).equals(ss3));

      // Test 2
      // "/a" - "/a" == <empty>
      ss1 = SubscriptionSet.makeSubscriptionSet("/a");
      ss2 = SubscriptionSet.makeSubscriptionSet("/a");
      ss3 = SubscriptionSet.makeEmptySet();
      assert(ss1.remove(ss2, true).equals(ss3));

      // Test 3
      // "/a/*" - "/a/*" == <empty>
      ss1 = SubscriptionSet.makeSubscriptionSet("/a/*");
      ss2 = SubscriptionSet.makeSubscriptionSet("/a/*");
      ss3 = SubscriptionSet.makeEmptySet();
      assert(ss1.remove(ss2, true).equals(ss3));

      // Test 4
      // "/a:/a/*" - "/a/*" == "/a"
      ss1 = SubscriptionSet.makeSubscriptionSet("/a:/a/*");
      ss2 = SubscriptionSet.makeSubscriptionSet("/a/*");
      ss3 = SubscriptionSet.makeSubscriptionSet("/a");
      assert(ss1.remove(ss2, true).equals(ss3));

      // Test 5
      // "/a/*" - "/a/*" == <empty>
      ss1 = SubscriptionSet.makeSubscriptionSet("/a/*");
      ss2 = SubscriptionSet.makeSubscriptionSet("/a/*");
      ss3 = SubscriptionSet.makeEmptySet();
      assert(ss1.remove(ss2, true).equals(ss3));

      // Test 6
      // "/a:/a/*" - "/a/b" == <Exception>
      ss1 = SubscriptionSet.makeSubscriptionSet("/a:/a/*");
      ss2 = SubscriptionSet.makeSubscriptionSet("/a/b");
      try{
        ss3 = ss1.remove(ss2, true);
        assert(false);
      }catch(IllegalRemoveSubscriptionSetException e){
        // Do nothing; correct behavior
      }

      // Test 7
      // ":/*" - ":/a" == <Exception>
      ss1 = SubscriptionSet.makeSubscriptionSet(":/*");
      ss2 = SubscriptionSet.makeSubscriptionSet(":/a");
      try{
        ss3 = ss1.remove(ss2, true);
        assert(false);
      }catch(IllegalRemoveSubscriptionSetException e){
        // Do nothing; correct behavior
      }

      // Test 8
      // ":/a:/a/*" - ":/a" == "/a/*"
      ss1 = SubscriptionSet.makeSubscriptionSet(":/a:/a/*");
      ss2 = SubscriptionSet.makeSubscriptionSet(":/a");
      ss3 = SubscriptionSet.makeSubscriptionSet("/a/*");
      assert(ss1.remove(ss2, true).equals(ss3));

      // Test 9
      // ":/a" - "" == "/a"
      ss1 = SubscriptionSet.makeSubscriptionSet(":/a");
      ss2 = SubscriptionSet.makeSubscriptionSet("");
      ss3 = SubscriptionSet.makeSubscriptionSet("/a");
      assert(ss1.remove(ss2, true).equals(ss3));

      // Test 10
      // "/a/b/c" - "/a/b/*" == <empty>
      ss1 = SubscriptionSet.makeSubscriptionSet("/a/b/c");
      ss2 = SubscriptionSet.makeSubscriptionSet("/a/b/*");
      ss3 = SubscriptionSet.makeEmptySet();
      assert(ss1.remove(ss2, true).equals(ss3));
 
      // Test 11
      // "/apple:/cherry" - "/apple" == "/cherry"
      ss1 = SubscriptionSet.makeSubscriptionSet("/apple:/cherry");
      ss2 = SubscriptionSet.makeSubscriptionSet("/apple");
      ss3 = SubscriptionSet.makeSubscriptionSet("/cherry");
      assert(ss1.remove(ss2, true).equals(ss3));
 
      // Test 12
      // "/apple/banana/*:/cherry" - "/cherry" == "/apple/banana/*"
      ss1 = SubscriptionSet.makeSubscriptionSet("/apple/banana/*:/cherry");
      ss2 = SubscriptionSet.makeSubscriptionSet("/cherry");
      ss3 = SubscriptionSet.makeSubscriptionSet("/apple/banana/*");
      assert(ss1.remove(ss2, true).equals(ss3));

      // Test 13
      // "/a/b" - "/a/b" == <empty>
      ss1 = SubscriptionSet.makeSubscriptionSet("/a/b");
      ss2 = SubscriptionSet.makeSubscriptionSet("/a/b");
      ss3 = SubscriptionSet.makeEmptySet();
      assert(ss1.remove(ss2, true).equals(ss3));

      // Test 14
      // "/a" - "/a/*" == "/a"
      ss1 = SubscriptionSet.makeSubscriptionSet("/a");
      ss2 = SubscriptionSet.makeSubscriptionSet("/a/*");
      ss3 = SubscriptionSet.makeSubscriptionSet("/a");
      assert(ss1.remove(ss2, true).equals(ss3));

      // Test 15
      // "/a/b/*" - "/a/b" == "/a/b/*"
      ss1 = SubscriptionSet.makeSubscriptionSet("/a/b/*");
      ss2 = SubscriptionSet.makeSubscriptionSet("/a/b");
      ss3 = SubscriptionSet.makeSubscriptionSet("/a/b/*");
      assert(ss1.remove(ss2, true).equals(ss3));

      // Test 16
      // "/a/b" - "/a/*" == <empty>
      ss1 = SubscriptionSet.makeSubscriptionSet("/a/b");
      ss2 = SubscriptionSet.makeSubscriptionSet("/a/*");
      ss3 = SubscriptionSet.makeEmptySet();
      assert(ss1.remove(ss2, true).equals(ss3));

      // Test 17
      // "/a/*" - "/a" == "/a/*"
      ss1 = SubscriptionSet.makeSubscriptionSet("/a/*");
      ss2 = SubscriptionSet.makeSubscriptionSet("/a");
      ss3 = SubscriptionSet.makeSubscriptionSet("/a/*");
      assert(ss1.remove(ss2, true).equals(ss3));

      // Test 18
      // "/a/b" - "/a" == "/a/b"
      ss1 = SubscriptionSet.makeSubscriptionSet("/a/b");
      ss2 = SubscriptionSet.makeSubscriptionSet("/a");
      ss3 = SubscriptionSet.makeSubscriptionSet("/a/b");
      assert(ss1.remove(ss2, true).equals(ss3));

      // Test 19
      // "/a" - "/a/b/*" == "/a"
      ss1 = SubscriptionSet.makeSubscriptionSet("/a");
      ss2 = SubscriptionSet.makeSubscriptionSet("/a/b/*");
      ss3 = SubscriptionSet.makeSubscriptionSet("/a");
      assert(ss1.remove(ss2, true).equals(ss3));

      // Test 20
      // "/a/*" - "/a:/a/b/*" == <Exception>
      ss1 = SubscriptionSet.makeSubscriptionSet("/a/*");
      ss2 = SubscriptionSet.makeSubscriptionSet("/a/b/*");
      try{
        ss3 = ss1.remove(ss2, true);
        assert(false);
      }catch(IllegalRemoveSubscriptionSetException e){
        // Do nothing; correct behavior
      }

      // Test 21
      // "/a/*" - "/a/*" == <empty>
      ss1 = SubscriptionSet.makeSubscriptionSet("/a/*");
      ss2 = SubscriptionSet.makeSubscriptionSet("/a/*");
      ss3 = SubscriptionSet.makeEmptySet();
      assert(ss1.remove(ss2, true).equals(ss3));

      // Test 22
      // "/a/*" - "/a" == "/a/*"
      ss1 = SubscriptionSet.makeSubscriptionSet("/a/*");
      ss2 = SubscriptionSet.makeSubscriptionSet("/a");
      ss3 = SubscriptionSet.makeSubscriptionSet("/a/*");
      assert(ss1.remove(ss2, true).equals(ss3));

      // Test 23
      // "/a:/a/b" - "/a/*" == "/a"
      ss1 = SubscriptionSet.makeSubscriptionSet("/a:/a/b");
      ss2 = SubscriptionSet.makeSubscriptionSet("/a/*");
      ss3 = SubscriptionSet.makeSubscriptionSet("/a");
      assert(ss1.remove(ss2, true).equals(ss3));

    }catch(IllegalRemoveSubscriptionSetException e){
      System.out.println("" + e);
      assert(false);
    }
  }

  
  //-------------------------------------------------------------------------
  // Test the getIntersection(SubscriptionSet) method
  //-------------------------------------------------------------------------
  public void
  testGetIntersection1(){
    SubscriptionSet ss1 = null;
    SubscriptionSet ss2 = null;
    SubscriptionSet ss3 = null;

    // Test 1
    // "" intersection "" == ""
    ss1 = SubscriptionSet.makeSubscriptionSet("");
    ss2 = SubscriptionSet.makeSubscriptionSet("");
    ss3 = SubscriptionSet.makeSubscriptionSet("");
    assert(ss1.getIntersection(ss2).equals(ss3));
    assert(ss2.getIntersection(ss1).equals(ss3));

    // Test 2
    // "" intersection "/*" == <empty>
    ss1 = SubscriptionSet.makeSubscriptionSet("");
    ss2 = SubscriptionSet.makeSubscriptionSet("/*");
    ss3 = SubscriptionSet.makeEmptySet();
    assert(ss1.getIntersection(ss2).equals(ss3));
    assert(ss2.getIntersection(ss1).equals(ss3));

    // Test 3
    // ":/*" intersection "" == ""
    ss1 = SubscriptionSet.makeSubscriptionSet(":/*");
    ss2 = SubscriptionSet.makeSubscriptionSet("");
    ss3 = SubscriptionSet.makeSubscriptionSet("");
    assert(ss1.getIntersection(ss2).equals(ss3));
    assert(ss2.getIntersection(ss1).equals(ss3));

    // Test 4
    // "/a" intersection "/b" == <empty>
    ss1 = SubscriptionSet.makeSubscriptionSet("/a");
    ss2 = SubscriptionSet.makeSubscriptionSet("/b");
    ss3 = SubscriptionSet.makeEmptySet();
    assert(ss1.getIntersection(ss2).equals(ss3));
    assert(ss2.getIntersection(ss1).equals(ss3));

    // Test 5
    // ":/a" intersection ":/b" == <empty>
    ss1 = SubscriptionSet.makeSubscriptionSet(":/a");
    ss2 = SubscriptionSet.makeSubscriptionSet(":/b");
    ss3 = SubscriptionSet.makeSubscriptionSet("");
    assert(ss1.getIntersection(ss2).equals(ss3));
    assert(ss2.getIntersection(ss1).equals(ss3));

    // Test 6
    // ":/a/*" intersection ":/a/*:/b" == ":/a/*"
    ss1 = SubscriptionSet.makeSubscriptionSet(":/a/*");
    ss2 = SubscriptionSet.makeSubscriptionSet(":/a/*:/b");
    ss3 = SubscriptionSet.makeSubscriptionSet(":/a/*");
    assert(ss1.getIntersection(ss2).equals(ss3));
    assert(ss2.getIntersection(ss1).equals(ss3));

    // Test 7
    // ":/a/*" intersection ":/a:/b" == ""
    ss1 = SubscriptionSet.makeSubscriptionSet(":/a/*");
    ss2 = SubscriptionSet.makeSubscriptionSet(":/a:/b");
    ss3 = SubscriptionSet.makeSubscriptionSet("");
    assert(ss1.getIntersection(ss2).equals(ss3));
    assert(ss2.getIntersection(ss1).equals(ss3));

    // Test 8
    // ":/a/*" intersection "/*" == "/a/*"
    ss1 = SubscriptionSet.makeSubscriptionSet(":/a/*");
    ss2 = SubscriptionSet.makeSubscriptionSet("/*");
    ss3 = SubscriptionSet.makeSubscriptionSet("/a/*");
    assert(ss1.getIntersection(ss2).equals(ss3));
    assert(ss2.getIntersection(ss1).equals(ss3));



    HierInvalTarget hit1 = null;

    // Test 9
    // "" intersection HIT("") == ""
    ss1 = SubscriptionSet.makeSubscriptionSet("");
    hit1 = HierInvalTarget.makeHierInvalTarget("");
    ss2 = SubscriptionSet.makeSubscriptionSet("");
    assert(ss1.getIntersection(hit1).equals(ss2));

    // Test 10
    // ":/a/b/*:/a/c/*" intersection HIT("/a/b/*") == "/a/b/*"
    ss1 = SubscriptionSet.makeSubscriptionSet(":/a/b/*:/a/c/*");
    hit1 = HierInvalTarget.makeHierInvalTarget("/a/b/*");
    ss2 = SubscriptionSet.makeSubscriptionSet("/a/b/*");
    assert(ss1.getIntersection(hit1).equals(ss2));

    // Test 11
    // "/a/b/*" intersection HIT("/a/b") == <empty>
    ss1 = SubscriptionSet.makeSubscriptionSet("/a/b/*");
    hit1 = HierInvalTarget.makeHierInvalTarget("/a/b");
    ss2 = SubscriptionSet.makeEmptySet();
    assert(ss1.getIntersection(hit1).equals(ss2));

    // Test 12
    // "/a/*" intersection HIT("/a/b") == "/a/b"
    ss1 = SubscriptionSet.makeSubscriptionSet("/a/*");
    hit1 = HierInvalTarget.makeHierInvalTarget("/a/b");
    ss2 = SubscriptionSet.makeSubscriptionSet("/a/b");
    assert(ss1.getIntersection(hit1).equals(ss2));

    // Test 13
    // "/*" intersection HIT("/a") == "/a"
    ss1 = SubscriptionSet.makeSubscriptionSet("/*");
    hit1 = HierInvalTarget.makeHierInvalTarget("/a");
    ss2 = SubscriptionSet.makeSubscriptionSet("/a");
    assert(ss1.getIntersection(hit1).equals(ss2));
  }

  //-------------------------------------------------------------------------
  // Test the getFullPaths() method
  //-------------------------------------------------------------------------
  public void
  testGetFullPaths(){
    SubscriptionSet ss1 = null;
    Vector vec1 = null;

    // Test 1: Empty set
    ss1 = SubscriptionSet.makeEmptySet();
    vec1 = ss1.getFullPaths();
    assert(vec1.size() == 0);

    // Test 2: Singleton
    ss1 = SubscriptionSet.makeSubscriptionSet("");
    vec1 = ss1.getFullPaths();
    assert(vec1.size() == 1);
    assert(vec1.get(0).equals(""));

    // Test 3: Another singleton
    ss1 = SubscriptionSet.makeSubscriptionSet("/a/*");
    vec1 = ss1.getFullPaths();
    assert(vec1.size() == 1);
    assert(vec1.get(0).equals("/a/*"));

    // Test 4: Multiple entries
    ss1 = SubscriptionSet.makeSubscriptionSet("/a/*:/b/*");
    vec1 = ss1.getFullPaths();
    assert(vec1.size() == 2);
    assert((vec1.get(0).equals("/a/*") && vec1.get(1).equals("/b/*")) ||
           (vec1.get(0).equals("/b/*") && vec1.get(1).equals("/a/*")));

    // Test 5: Multiple entries; single node in tree
    ss1 = SubscriptionSet.makeSubscriptionSet("/b:/b/*");
    vec1 = ss1.getFullPaths();
    assert(vec1.size() == 2);
    assert((vec1.get(0).equals("/b") && vec1.get(1).equals("/b/*")) ||
           (vec1.get(0).equals("/b/*") && vec1.get(1).equals("/b")));

    // Test 6: Multiple entries
    ss1 = SubscriptionSet.makeSubscriptionSet(":/a/b:/a/c/*");
    vec1 = ss1.getFullPaths();
    assert(vec1.size() == 3);
    assert((vec1.get(0).equals("") &&
            vec1.get(1).equals("/a/b") &&
            vec1.get(2).equals("/a/c/*")) ||
           (vec1.get(0).equals("") &&
            vec1.get(2).equals("/a/b") &&
            vec1.get(1).equals("/a/c/*")) ||
           (vec1.get(1).equals("") &&
            vec1.get(0).equals("/a/b") &&
            vec1.get(2).equals("/a/c/*")) ||
           (vec1.get(1).equals("") &&
            vec1.get(2).equals("/a/b") &&
            vec1.get(0).equals("/a/c/*")) ||
           (vec1.get(2).equals("") &&
            vec1.get(0).equals("/a/b") &&
            vec1.get(1).equals("/a/c/*")) ||
           (vec1.get(2).equals("") &&
            vec1.get(1).equals("/a/b") &&
            vec1.get(0).equals("/a/c/*")));
  }

  //-------------------------------------------------------------------------
  // Test the constructor that builds a copy of a HierInvalTarget
  //-------------------------------------------------------------------------
  public void
  testHITConstructor(){
    SubscriptionSet ss1 = null;
    SubscriptionSet ss2 = null;
    SubscriptionSet ss3 = null;
    SubscriptionSet ss4 = null;
    HierInvalTarget hit1 = null;
    HierInvalTarget hit2 = null;

    // Test 1: Make a HIT of "/a/b:/a/c"
    hit1 = HierInvalTarget.makeHierInvalTarget("/a/b:/a/c");
    ss1 = new SubscriptionSet(hit1);
    ss2 = SubscriptionSet.makeSubscriptionSet("/a/b:/a/c");
    assert(ss1.getChildrenSize() == 1);
    assert(ss1.equals(ss2));
    assert(ss2.equals(ss1));

    // Test 2: Make an empty HierInvalTarget
    hit2 = new HierInvalTarget();
    ss3 = new SubscriptionSet(hit2);
    ss4 = SubscriptionSet.makeEmptySet();
    assert(ss3.equals(ss4));
    assert(ss4.equals(ss3));
  }

  
  //-------------------------------------------------------------------------
  // create a config file
  //-------------------------------------------------------------------------
  private static void makePractiConfig(){
    Config.createEmptyConfig();
    long NODE_0_ID = 0;
    long NODE_1_ID = 1;
    long NODE_2_ID = 2;
    long NODE_3_ID = 3;
    long NODE_4_ID = 4;
    String NODE_0_IP = "localhost";
    String NODE_1_IP = "localhost";
    String NODE_2_IP = "localhost";
    String NODE_3_IP = "localhost";
    String NODE_4_IP = "localhost";
    Config.addOneNodeConfig(new NodeId(NODE_0_ID),
                            NODE_0_IP,
                            9988,
                            9989,
                            9991,
                            9992,
                            9990,
                            "test" + File.separatorChar + "local-" + 
			    NODE_0_ID + ".db",
                            "/*",
                            -1L,
                            NODE_0_IP,
                            9993,
                            9994,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
 
   Config.addOneNodeConfig(new NodeId(NODE_1_ID),
			   NODE_1_IP,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "local-" + 
			   NODE_1_ID+".db",
			   "/*",
			   -1L,
			   NODE_1_IP,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);
   Config.addOneNodeConfig(new NodeId(NODE_2_ID),
			   NODE_2_IP,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "local-" + 
			   NODE_2_ID+".db",
			   "/*",
			   -1L,
			   NODE_2_IP,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);

   Config.addOneNodeConfig(new NodeId(NODE_3_ID),
			   NODE_3_IP,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "local-" + 
			   NODE_3_ID+".db",
			   "/*",
			   -1L,
			   NODE_3_IP,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);
    
   
   
   
   Config.addOneNodeConfig(new NodeId(NODE_4_ID),
			   NODE_4_IP,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "local-" + 
			   NODE_4_ID+".db",
			   "/*",
			   -1L,
			   NODE_4_IP,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);
   //Config.writeToFile(configPath);
  }

  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(SubscriptionSetUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * usage: java <classname> [-verbose] [-vverbose] [testName]*
   * 
   *   If verbose or vverbose are included, print info to screen
   *
   *   If [testName]* are included, then run test called "test[testName]"
   *   for each such [testName]. E.g., "java SubscriptionSetUnit foo" runs
   *   SubscriptionSetUnit.testfoo() as a TestCase.
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "SubscriptionSetUnit";
    System.err.print(name + " self test begins...");
    
    Env.verifyAssertEnabled();
    makePractiConfig();
    
    //
    // Default: run all tests
    //
    TestSuite ste = new TestSuite();
    Test test;
    boolean doAllTests = true;

    if(s.length > 0){
      int ii;
      for(ii = 0; ii < s.length; ii++){
        if(s[ii].equals("-verbose")){
          verbose = true;
        }
        else if(s[ii].equals("-vverbose")){
          verbose = true;
        }
        else{
          doAllTests = false;
          ste.addTest(new SubscriptionSetUnit("test" + s[ii]));
        }
        
      }
    }
    if(doAllTests){
      test = suite();
    }
    else{
      test = ste;
    }
    TestRunner tr = new TestRunner();
    tr.doRun(test);
    System.err.println(name + " self test succeeds");
    System.exit(0); 
  }

}

//---------------------------------------------------------------------------
/* $Log: SubscriptionSetUnit.java,v $
/* Revision 1.1  2007/06/25 05:25:04  zjiandan
/* *** empty log message ***
/* */
//---------------------------------------------------------------------------