package code;

import java.security.MessageDigest;
import java.io.Serializable;
import java.util.Arrays;
import code.security.SangminConfig;
import code.security.ahs.DVVMapEntry;

public class SummaryHash implements Serializable{
  private byte[] digest;

  public SummaryHash(){
    digest = null;
  }
  
  public SummaryHash(byte[] data, boolean doHashing){
    
    if(doHashing){
      byte[] tmp = null;
      try{
        MessageDigest md = MessageDigest.getInstance("SHA");
        tmp = md.digest(data);
      }catch (Exception e){      
        System.out.println(e.toString());
        e.printStackTrace();
        System.exit(1);
      }
      this.digest = tmp;

    }else{
      digest = data;
    }

  }


  public byte[] getValue(){
    return this.digest;
  }

  public void putValue(byte[] _digest){
	  this.digest = _digest;
//    assert(false);    
  }

  public boolean equals(Object o){
    if(o instanceof SummaryHash && 
        MessageDigest.isEqual(this.digest, ((SummaryHash)o).getValue())){
      //System.out.println("SH matched!!!");
      return true;
    }
    return false;
  }
  
  public String toString(){
    if(SangminConfig.printDebugHashes){ 
      return DVVMapEntry.byteString(digest);
      /*
      String ret = "";
      for(int i=0; i < digest.length; i++){
        ret += "[" + i + ":"+ digest[i]+"]";
      }
      return ret;*/
    }else{
      return "SH";
    }
    //return digest.toString();
  }
}
