package code;

import java.util.Hashtable;

 /** 
 **/ 
public class SyncPool
{
    //
    // Per-node list of pending sync requests along
    // with a worker thread per list
    //

    Hashtable h;
    StreamPool streamPool;
    Core core;

    public SyncPool(Core core_){
	core = core_;
	streamPool = new StreamPool(core.getMyNodeId());
	h = new Hashtable();
    }

    public synchronized SyncRequestQ get(NodeId nodeId){
	SyncRequestQ syncRQ = (SyncRequestQ)h.get(nodeId);
	if(syncRQ == null){
	    syncRQ = new SyncRequestQ();
	    h.put(nodeId, syncRQ);
	    // create a SyncRequestThread to drain the queue
	    Thread t = new SyncRequestThread(syncRQ, streamPool, core);
	    t.start();
	}
	return syncRQ;
    }
}

//---------------------------------------------------------------------------
/* $Log: SyncPool.java,v $
/* Revision 1.4  2005/10/13 00:24:24  zjiandan
/* remove Config.getMy* fixed Garbage Collection and Checkpoint exchange code
/*
/* Revision 1.3  2004/04/19 23:30:05  lgao
/* Initial implementation of the RMI package and modification to Makefile.
/*
/* Revision 1.2  2004/04/15 20:04:25  nayate
/* New Makefile; added provision to allow CVS to append file modification
/* logs to files.
/* */
//---------------------------------------------------------------------------
