package code;

 /** 
 **/ 
public abstract class SyncRequest implements Immutable
{
  final NodeId requestingNode;
  
  public SyncRequest(NodeId nid) {
  assert(nid instanceof Immutable);
  requestingNode = nid;
  }
    
  public NodeId getNodeId(){
    return requestingNode;
  }
  
  public Object clone(){
    assert(this instanceof Immutable);
    return this;
  }
   
}

//---------------------------------------------------------------------------
/* $Log: SyncRequest.java,v $
/* Revision 1.6  2007/01/05 01:18:41  nalini
/* support for sync with VV added
/*
/* Revision 1.5  2004/07/28 14:27:35  dahlin
/* Added sanity checks for immutable objects
/*
/* Revision 1.4  2004/04/30 19:10:07  nayate
/* Added method getNodeId()
/*
/* Revision 1.3  2004/04/19 23:30:05  lgao
/* Initial implementation of the RMI package and modification to Makefile.
/*
/* Revision 1.2  2004/04/15 20:04:25  nayate
/* New Makefile; added provision to allow CVS to append file modification
/* logs to files.
/* */
//---------------------------------------------------------------------------
