package code;

 /** 
 **/ 

import java.util.LinkedList;

public class SyncRequestQ{
    //just a FIFO queue that is synchronized to be producer/consumer queue

    private LinkedList localQueue;

    public SyncRequestQ()
    {
	this.localQueue = new LinkedList();
    }
    
    public synchronized void enqueue(SyncRequest sr)
    {
	this.localQueue.add(sr);
	this.notifyAll();
    }

    public synchronized Object remove()
    {
	while(this.localQueue.isEmpty()){
	    try{
		this.wait();
	    }catch(InterruptedException e){
		System.err.println("" + e);
	    }
	}
	return(this.localQueue.removeFirst());
    }
}

//---------------------------------------------------------------------------
/* $Log: SyncRequestQ.java,v $
/* Revision 1.4  2004/04/30 19:09:22  nayate
/* Wrote SyncRequestQ.java
/*
/* Revision 1.3  2004/04/19 23:30:05  lgao
/* Initial implementation of the RMI package and modification to Makefile.
/*
/* Revision 1.2  2004/04/15 20:04:25  nayate
/* New Makefile; added provision to allow CVS to append file modification
/* logs to files.
/* */
//---------------------------------------------------------------------------
