package code;

 /** 
 **/ 
public class SyncRequestThread extends Thread
{
    SyncRequestQ myQ;
    StreamPool pool;
    Core core; 
    public SyncRequestThread(SyncRequestQ q, StreamPool pool_, 
			     Core core_)
    {
	myQ = q;
	pool = pool_;
	core = core_;
    }

    public void run()
    {
	while(true){
	    try{
		SyncRequest r = (SyncRequest)myQ.remove();
                if(r instanceof SyncRequestForAS) { 
                  core.syncCheck(((SyncRequestForAS)r).getStamp());
                  pool.send(Config.getDNS(r.getNodeId()), 
                            Config.getPortSync(r.getNodeId()), ((SyncRequestForAS)r).getStamp());
                }
                else if (r instanceof SyncRequestForVV) {
                  VV vv = ((SyncRequestForVV)r).getVV();
                  core.syncCheck(vv);
                  // Note: we just send the first acceptstamp of the VV
                  //       to make things simpler for the receiver
                  VVIterator vvI = vv.getIterator();
                  Object token = vvI.getNext();
                  NodeId nodeId = vv.getServerByIteratorToken(token);
                  assert(vv.containsNodeId(nodeId));
                  AcceptStamp  as = new AcceptStamp (vv.getStampByServer(nodeId), nodeId);    
                  pool.send(Config.getDNS(r.getNodeId()), 
                            Config.getPortSync(r.getNodeId()), as);
                }
	    }catch(InterruptedException e1){
		System.err.println("" + e1);
		assert(false);
	    }catch(UnableToConnectException e2){
		System.err.println("" + e2);
		assert(false);
	    }catch(Exception e3){
              System.err.println("" + e3);
              assert(false);
            }            
	}
    }
}

//---------------------------------------------------------------------------
/* $Log: SyncRequestThread.java,v $
/* Revision 1.4  2007/01/05 01:18:41  nalini
/* support for sync with VV added
/*
/* Revision 1.3  2004/04/30 19:26:24  nayate
/* Added code to catch some previously-uncaught exceptions
/*
/* Revision 1.2  2004/04/15 20:04:25  nayate
/* New Makefile; added provision to allow CVS to append file modification
/* logs to files.
/* */
//---------------------------------------------------------------------------
