package code;

 /** 
 *  Thread that listens for socket connections to receive inval streams 
 **/ 
import java.net.Socket;
import java.net.ServerSocket;
import java.io.IOException;
import java.io.ObjectInputStream;

public class SyncRplyReceiver extends Thread
{
    private Core core;
    private Controller controller;
  private ServerSocket ss;
  private boolean shutdown;
 /** 
 *  Constructor 
 **/ 
    public SyncRplyReceiver(Core core_, Controller controller_)
    {
	this.core = core_;
	this.controller = controller_;
	this.ss = null;
	this.shutdown = false;
    }
  
  public void shutdown(){
    shutdown = true;
    if (ss != null){
      try{
	ss.close();// this call will make any thread currently blocked in accept()
	// throw a SocketException
      }catch(IOException ioe){
	System.err.println(" InvalStreamReceiver shutting down ignore Exception: " 
			   +ioe.toString());
      }
      ss = null;
    }
  }

  static boolean warnedHB = false;
 /** 
 *  Main thread method 
 **/ 
    public void run()
    {
	Socket connection = null;
	
	TaggedInputStream ois = null;
	SyncRplyRecvWorker t = null;

	try{
	  
          

	  if(OutgoingConnection.USE_HEARTBEATS){
	    ss = new HeartbeatServerSocket(Config.getPortSync(core.getMyNodeId()));
	    
        }else{
	  if(!warnedHB){
	    Env.warn("InvalReciver -- heartbeats turned off");
	    warnedHB = true;
	  }
          ss = new ServerSocket(Config.getPortSync(core.getMyNodeId()));
        }

          while(!shutdown){
		connection = ss.accept(); // Gets a HeartbeatSocket
		connection.setTcpNoDelay(true);
		ois = new TaggedInputStream(connection.getInputStream());
		t = new SyncRplyRecvWorker(ois, core, controller, connection);
		t.start();
	    }
	}catch(IOException e){
	  if(!shutdown){
	    System.err.println(" SyncRplyReceiver: " + e);
	  }
	}
        finally{
          if(ss != null){
            try{
              ss.close();
            }
            catch(IOException ioe){
            }
            ss = null;
          }
          if(t != null){
            t.interrupt();
            t = null;
          }
        }
    }
}

//---------------------------------------------------------------------------
/* $Log: SyncRplyReceiver.java,v $
/* Revision 1.9  2007/08/05 04:43:54  zjiandan
/* SocketServer shutdown quietly
/*
/* Revision 1.8  2006/09/12 22:18:05  dahlin
/* Working to get the unit tests to all run. Up to RandomAccessState now go through. Note that to encourage people to run RASUnit, I have changed the parameters to --quick-- versions that are less extensive tests.
/*
/* Revision 1.7  2005/10/13 00:24:24  zjiandan
/* remove Config.getMy* fixed Garbage Collection and Checkpoint exchange code
/*
/* Revision 1.6  2005/01/18 22:49:43  zjiandan
/* Rewrited Class Serialization for network deliveringto reduce the overall bandwidth.
/*
/* Revision 1.5  2004/05/11 23:45:44  nayate
/* Made the interface to HeartbeatSocket match that of Socket, and changed
/* classes to use HeartbeatSockets.
/*
/* Revision 1.4  2004/05/11 17:22:04  nayate
/* (1) Added "setTcpNoDelay(true)" calls at socket creation
/* (2) Changed "ObjectOutputStream" to "TaggedOutputStream" where appropriate
/*
/* Revision 1.3  2004/04/26 20:04:24  nayate
/* Finished but didn't test classes that receive invals, updates, and
/* sync messages.
/*
/* Revision 1.2  2004/04/15 20:04:25  nayate
/* New Makefile; added provision to allow CVS to append file modification
/* logs to files.
/* */
//---------------------------------------------------------------------------
