package code;

import java.io.*;
import java.net.*;


public class TaggedInputStream 
extends ObjectInputStream
implements TaggedClassConstant{

  ByteArrayOutputStream baos;
  ObjectOutputStream buffer;
  private boolean measureIncomingBW = true;  

  public TaggedInputStream()
  throws IOException, SecurityException{
    super();

    baos = new ByteArrayOutputStream();     
    buffer = new ObjectOutputStream(baos);
  }

  public TaggedInputStream(InputStream in)
  throws IOException{
    super(in);

    baos = new ByteArrayOutputStream();     
    buffer = new ObjectOutputStream(baos);
  }

  public final Object readTaggedObject() 
  throws IOException, ClassNotFoundException{
    /*
    short classType = super.readShort();
    Object ret = null;
    switch(classType){
    case LONG:
      ret = new Long(super.readLong());
      break;
    case NODEID:
      ret = new NodeId(super.readLong());
      break;

    case ACCEPTSTAMP:
      long clock = super.readLong();
      ret = new AcceptStamp(clock, 
                            new NodeId(super.readLong()));
      break;

    case ACCEPTVV:
      int avvSize = super.readInt();
      AcceptStamp[] vvTime = new AcceptStamp[avvSize];
      for(int i=0; i<avvSize; i++){
        NodeId nodeId = new NodeId(super.readLong());
        vvTime[i] = new AcceptStamp(super.readLong(), nodeId);
      }
      ret = new AcceptVV(vvTime);
      break;

    case HIERINVALTARGET:
      ret = new HierInvalTarget(this);
      break;

    case BODYMSG:
      String objStr = (String)(super.readObject());
      long offs = super.readLong();
      long len = super.readLong();

      long c = super.readLong();
      AcceptStamp as = new AcceptStamp(c, new NodeId(super.readLong()));

      int bodySize = super.readInt();
      byte[] data = new byte[bodySize];
      super.readFully(data);

      boolean isDemand = super.readBoolean();
      double priority = super.readDouble();
      ret = new BodyMsg(new ObjId(objStr),
                        offs,
                        len,
                        as,
                        new ImmutableBytes(data),
                        isDemand,
                        priority);
      break;

    case BOUNDINVAL:

      String objIdString = (String)(super.readObject());
      long offset = super.readLong();
      long length = super.readLong();
      long localClock = super.readLong();
      long nodeIdInt = super.readLong();

      long realTime = super.readLong();
      double newPriority = super.readDouble();
      boolean embargoed = super.readBoolean();

      int strLength = super.readInt();
      byte [] b = new byte[strLength];
      super.readFully(b);

      ret = new BoundInval(new ObjId(objIdString),
                            offset,
                            length,
                            new AcceptStamp(localClock, new NodeId(nodeIdInt)),
                            new ImmutableBytes(b),
                            newPriority,
                            new AcceptStamp(realTime, new NodeId(nodeIdInt)),
                            embargoed);

      break;

    case PRECISEINV:
      objIdString = (String)(super.readObject());
      offset = super.readLong();
      length = super.readLong();
      localClock = super.readLong();
      nodeIdInt = super.readLong();

      realTime = super.readLong();
      embargoed = super.readBoolean();

      ret = new PreciseInv(new ObjInvalTarget(new ObjId(objIdString),
                                               offset,
                                               length),
                            new AcceptStamp(localClock, new NodeId(nodeIdInt)),
                            new AcceptStamp(realTime, new NodeId(nodeIdInt)),
                            embargoed);
      break;

    case IMPRECISEINV:
      HierInvalTarget hit = null;
      hit = new HierInvalTarget(this);
      int vvSize = super.readInt();
      AcceptStamp[] startTime = new AcceptStamp[vvSize];
      AcceptStamp[] endTime = new AcceptStamp[vvSize];
      AcceptStamp[] rtTime = new AcceptStamp[vvSize];
      for(int i=0; i<vvSize; i++){
        NodeId nodeId = new NodeId(super.readLong());
        startTime[i] = new AcceptStamp(super.readLong(), nodeId);
        endTime[i] = new AcceptStamp(super.readLong(), nodeId);
        rtTime[i] = new AcceptStamp(super.readLong(), nodeId);
      }
      ret = new ImpreciseInv(hit,
                             new AcceptVV(startTime),
                             new AcceptVV(endTime),
                             new AcceptVV(rtTime));
      break;

    case UNBINDMSG:
      objIdString = (String)(super.readObject());
      offset = super.readLong();
      length = super.readLong();
      localClock = super.readLong();
      nodeIdInt = super.readLong();
      ret = new UnbindMsg(new ObjInvalTarget(new ObjId(objIdString),
                                              offset,
                                              length),
                           new AcceptStamp(localClock, new NodeId(nodeIdInt)));

      break;
    case DEBARGOMSG:
      objIdString = (String)(super.readObject());
      offset = super.readLong();
      length = super.readLong();
      localClock = super.readLong();
      nodeIdInt = super.readLong();
      ret = new DebargoMsg(new ObjInvalTarget(new ObjId(objIdString),
                                              offset,
                                              length),
                           new AcceptStamp(localClock, new NodeId(nodeIdInt)));

      break;
    case NOTPROCESSED:
      ret = super.readObject();
      break;
    default:
      System.err.println("incoming packet type " + classType);
      System.err.println("UnTaggedStreamObject, something wrong!!!!!!!!!!!");
      assert false;
    }
     */

    Object o = super.readObject();

    if(measureIncomingBW ){
      baos.reset();
      buffer.reset();

      buffer.writeObject(o);
      buffer.flush();
      long len = baos.size();

      if(o instanceof PreciseInv){
        Stats.put("Incoming PreciseInv", len);
      }else if(o instanceof ImpreciseInv){
        Stats.put("Incoming ImpreciseInv", len);
      }else{
        Stats.put("Incoming " + o.getClass().getName(), len);
      }
    }


    return o;
  }

  public static void main(String [] argv){
    if(argv.length < 1){
      System.out.println("Usage: [client][port] or [server]");
    }
    try{
      if(argv[0].equals("client")){
        String s = "XXXXXXXXXXXXXx";
        Socket socket = new Socket(argv[1], 5566);
        socket.setTcpNoDelay(true);
        OutputStream send = socket.getOutputStream();
        TaggedOutputStream tos = new TaggedOutputStream(send);
        //(1) Long
        tos.writeObject(new Long(100));

        //(2) NodeID
        tos.writeObject(new NodeId(9));

        //(3) AcceptStamp
        tos.writeObject(new AcceptStamp(1, new NodeId(10)));

        //(4) HierInvalTarget
        tos.writeObject(HierInvalTarget.makeHierInvalTarget("/a/b/c:/d"));

        //(5) BodyMsg
        byte[] data = new byte[2];
        data[0] = 0;
        data[1] = 1;
        tos.writeObject(new BodyMsg(new ObjId("/a"),
            0,
            2,
            new AcceptStamp(1, new NodeId(10)),
            new ImmutableBytes(data),
            true,
            0.7));

        //(6) PreciseInv
        tos.writeObject(new PreciseInv(new ObjInvalTarget(new ObjId("/b"),
            0,
            2),
            new AcceptStamp(1, new NodeId(10))));


        //(7) ImpreciseInv
        AcceptStamp[] as1 = new AcceptStamp[2];
        as1[0] = new AcceptStamp(190, new NodeId(9));
        as1[1] = new AcceptStamp(19, new NodeId(10));
        AcceptStamp[] as2 = new AcceptStamp[2];
        as2[0] = new AcceptStamp(220, new NodeId(9));
        as2[1] = new AcceptStamp(22, new NodeId(10));
        String[] dirStrs1 = new String[2];
        dirStrs1[0] = "/0";
        dirStrs1[1] = "/1";
        tos.writeObject(new ImpreciseInv(HierInvalTarget.makeHierInvalTarget(dirStrs1),
            new AcceptVV(as1),
            new AcceptVV(as2)));

        //(8) String
        tos.writeObject(new String("/0"));

        //(9) BoundInval
        tos.writeObject(new BoundInval(new ObjId("/a"),
            0,
            2,
            new AcceptStamp(1, new NodeId(10)),
            new ImmutableBytes(data),
            0.9));

        //(10)AcceptVV
        tos.writeObject(new AcceptVV(as2));

        //(11)UnbindMsg
        tos.writeObject(new UnbindMsg(new ObjInvalTarget(new ObjId("/a"),
            0,
            2),
            new AcceptStamp(1, new NodeId(10))));

        //(12)DebargoMsg
        tos.writeObject(new DebargoMsg(new ObjInvalTarget(new ObjId("/a"),
            0,
            2),
            new AcceptStamp(1, new NodeId(10))));
      } else {
        ServerSocket ss = new ServerSocket(5566);
        Socket recv = (Socket) ss.accept();

        TaggedInputStream tis = new TaggedInputStream(recv.getInputStream());
        //Long
        System.out.println(tis.readTaggedObject());

        //NodeId

        System.out.println( tis.readTaggedObject());


        //AcceptStamp

        System.out.println(tis.readTaggedObject());

        //HierInvalTarget

        System.out.println(tis.readTaggedObject());

        //BodyMsg

        System.out.println(tis.readTaggedObject());

        //PreciseInv

        System.out.println(tis.readTaggedObject());
        //ImpreciseInv

        System.out.println(tis.readTaggedObject());

        System.out.println(tis.readTaggedObject());

        System.out.println(tis.readTaggedObject());
        //AcceptVV
        System.out.println(tis.readTaggedObject());

        System.out.println(tis.readTaggedObject());

        System.out.println(tis.readTaggedObject());
      }
    } catch (Exception e){
      e.printStackTrace();
    }
  }

}

//---------------------------------------------------------------------------
/* $Log: TaggedInputStream.java,v $
/* Revision 1.10  2006/09/12 14:57:59  zjiandan
/* Move object custom serialization into individual classes from TaggedOutputStream
/* and TaggedInputStream. The new serialization code consumes a little bit more
/* bytes than the original approach because of java's default object information
/* overhead (I have excluded the field name and type information).
/* The major changes are using java reflection API to serialize "private final"
/* fields (which are very common among our objects that need to custom serialization).
/* Also add sanity check for each class so that we will remember to update
/* the serialization methods when we change the class definitions.
/*
/* Revision 1.9  2005/07/19 02:12:45  zjiandan
/* Add Logic to stop outgoing invalidates streams whenever
/* log garbage collector outperforms InvalIterator, i.e.
/* Log.inMemOmitVV > InvalIterator.currentVV.
/*
/* Revision 1.8  2005/07/18 05:10:23  zjiandan
/* Embargoed Writes etc. features implementation plus
/* log overhead measurement with disk size and in-memory size.
/*
/* Revision 1.7  2005/03/10 19:38:55  lgao
/* *** empty log message ***
/*
/* Revision 1.6  2005/03/09 00:40:57  nayate
/* Added a priority field to BodyMsg
/*
/* Revision 1.5  2005/03/09 00:15:36  nayate
/* Added a priority to BoundInvals
/*
/* Revision 1.4  2005/03/05 00:17:40  nayate
/* Added code to compress serialization
/*
/* Revision 1.3  2005/03/01 10:40:35  nayate
/* First successful compilation
/*
/* Revision 1.2  2005/02/28 20:25:59  zjiandan
/* Added Garbage Collection code and part of Checkpoint exchange protocol code
/*
/* Revision 1.1  2005/01/18 22:49:43  zjiandan
/* Rewrited Class Serialization for network deliveringto reduce the overall bandwidth.
/* */
//---------------------------------------------------------------------------
