package code;

/* 
 * TaggedOutputStream --
 *
 *   Used to collecting the aggregated network bandwidth and break-down
 *
 */


import java.io.*;
import java.net.*;

import code.security.SangminConfig;
import code.security.SecureImpreciseInv;
import code.security.SecureInv;


public class TaggedOutputStream implements TaggedClassConstant{
  final static boolean SHOWSTATSDETAIL = false;
  final static boolean dbgPrefetch = false;
  final static boolean dbgSerial = false;
  final static boolean SHOW_OUTGOING_DATA = false;
  OutputStream hbos;
  ByteArrayOutputStream baos;
  ObjectOutputStream buffer;

  private static boolean warnedI = false;
  
  public TaggedOutputStream(OutputStream os) throws IOException{
    if(!warnedI){
      Env.performanceWarning("TaggedOutputStream may be inefficient while collecting byte sizes of outputs!");
      warnedI = true;
    }
    hbos = os;
    baos = new ByteArrayOutputStream();	
    buffer = new ObjectOutputStream(baos);

    /* We need the following to make the InputObjectStream happy at the 
       receiving end.
       This call will send control/stream header information to the 
       receiving end */
    new ObjectOutputStream(hbos); 
  }

  public void writeObject(Object o) throws IOException{
   
    baos.reset(); // reset the buffer in the bytearrayoutputstream.
                 
    buffer.reset(); // reset the buffer in the objectoutputstream. 
                    //If not, array, hashtable will not be sent correctly, 
                    //sometimes.  -- as Dmitri discovered, if not, also cause a mem-leak
                    // at the receiver side.
/*
 *Serialization moved to individual classes.

    if (o instanceof Long){
      buffer.writeShort(LONG);
      buffer.writeLong(((Long)o).longValue());
    
    }else if(o instanceof NodeId){
      buffer.writeShort(NODEID);
      buffer.writeLong(((NodeId)o).getIDint());
    
    }else if (o instanceof AcceptStamp){
      buffer.writeShort(ACCEPTSTAMP);
      AcceptStamp as = (AcceptStamp)o;
      buffer.writeLong(as.getLocalClock());
      buffer.writeLong(as.getNodeId().getIDint());

    }else if (o instanceof AcceptVV){
      buffer.writeShort(ACCEPTVV);
     
      AcceptVV acceptVV = (AcceptVV)o;
      buffer.writeInt(acceptVV.size());

      Object token = null;
      for(VVIterator vvIter = acceptVV.getIterator(); vvIter.hasMoreElements();){
	    token = vvIter.getNext();
            buffer.writeLong(acceptVV.getServerByIteratorToken(token).getIDint());
            buffer.writeLong(acceptVV.getStampByIteratorToken(token));
      }
      
    }else if (o instanceof HierInvalTarget){

      buffer.writeShort(HIERINVALTARGET);
      HierInvalTarget hit = (HierInvalTarget)o;
      hit.copySelfOntoOOS(buffer);

    }else if ( o instanceof BodyMsg ){
      buffer.writeShort(BODYMSG);
      BodyMsg bm = (BodyMsg) o;
      //objInvalTarget
      buffer.writeObject(bm.getObjId().getPath());
      buffer.writeLong(bm.getObjInvalTarget().getOffset());
      buffer.writeLong(bm.getObjInvalTarget().getLength());
      //acceptStamp
      buffer.writeLong(bm.getAcceptStamp().getLocalClock());
      buffer.writeLong(bm.getAcceptStamp().getNodeId().getIDint());

      buffer.writeInt(bm.getBody().getLength());
      buffer.write(bm.getBody().dangerousGetReferenceToInternalByteArray());
      buffer.writeBoolean(bm.isDemandReply());
      buffer.writeDouble(bm.getPriority());

    }else if ( o instanceof BoundInval){ 
      buffer.writeShort(BOUNDINVAL);
      
      BoundInval bi = (BoundInval)o;
      buffer.writeObject(bi.getObjId().getPath());
      buffer.writeLong(bi.getOffset());
      buffer.writeLong(bi.getLength());
      buffer.writeLong(bi.getAcceptStamp().getLocalClock());
      buffer.writeLong(bi.getAcceptStamp().getNodeId().getIDint());
      
      //new members added for tact/embargoed write
      // realtime AcceptStamp
      buffer.writeLong(bi.getRTAcceptStamp().getLocalClock());
      buffer.writeDouble(bi.getPriority());
      //embargoed flag
      buffer.writeBoolean(bi.isEmbargoed());

      buffer.writeInt(bi.getBody().getLength());
      buffer.write(bi.getBody().dangerousGetReferenceToInternalByteArray());
      
    }else if ( o instanceof PreciseInv){
      assert !(o instanceof BoundInval);
      assert !(o instanceof DeleteInv);
      buffer.writeShort(PRECISEINV);
      //tbd: process subclass of PreciseInv first
      PreciseInv pi = (PreciseInv)o;
      buffer.writeObject(pi.getObjId().getPath());
      buffer.writeLong(pi.getOffset());
      buffer.writeLong(pi.getLength());
      buffer.writeLong(pi.getAcceptStamp().getLocalClock());
      buffer.writeLong(pi.getAcceptStamp().getNodeId().getIDint());

      // realtime AcceptStamp & embargoed flag for tact/embargoed write
      buffer.writeLong(pi.getRTAcceptStamp().getLocalClock());
      buffer.writeBoolean(pi.isEmbargoed());

    }else if ( o instanceof ImpreciseInv){
      buffer.writeShort(IMPRECISEINV);
      ImpreciseInv ii = (ImpreciseInv)o;
      
      assert ii.getInvalTarget() instanceof HierInvalTarget;

      HierInvalTarget hit = (HierInvalTarget)ii.getInvalTarget();
      hit.copySelfOntoOOS(buffer);

      //startVV endVV
      AcceptVV startVV = ii.getStartVV();

      Object token = null;
      AcceptVV endVV = ii.getEndVV();
      AcceptVV rtVV = ii.getRTVV();
      assert startVV.size() == endVV.size();
      assert rtVV.size() == startVV.size();
      int numVVEntriesToSend = 0;

      for(VVIterator vvIter = startVV.getIterator();
          vvIter.hasMoreElements();){
        token = vvIter.getNext();
        // No need to send this entry of startVV and endVV if
        // their timestamps are uninitialized
        if((startVV.getStampByIteratorToken(token) !=
            AcceptStamp.BEFORE_TIME_BEGAN)||
           (endVV.getStampByIteratorToken(token) !=
            AcceptStamp.BEFORE_TIME_BEGAN)){

          assert (startVV.getStampByIteratorToken(token) !=
                  AcceptStamp.BEFORE_TIME_BEGAN);

          assert (endVV.getStampByIteratorToken(token) !=
                  AcceptStamp.BEFORE_TIME_BEGAN);

          assert (rtVV.getStampByIteratorToken(token) != 
                  AcceptStamp.BEFORE_TIME_BEGAN);
          numVVEntriesToSend++;
        }else{
          assert rtVV.getStampByIteratorToken(token) == 
            AcceptStamp.BEFORE_TIME_BEGAN;
        }
      }
      assert numVVEntriesToSend == startVV.size();
      buffer.writeInt(numVVEntriesToSend);

      for(VVIterator vvIter = startVV.getIterator();
          vvIter.hasMoreElements();){
        token = vvIter.getNext();
        // No need to send this entry of startVV and endVV if
        // their timestamps are uninitialized
        if(startVV.getStampByIteratorToken(token) !=
           AcceptStamp.BEFORE_TIME_BEGAN){
          buffer.writeLong(startVV.getServerByIteratorToken(token).getIDint());
          buffer.writeLong(startVV.getStampByIteratorToken(token));
          buffer.writeLong(endVV.getStampByIteratorToken(token));
          buffer.writeLong(rtVV.getStampByIteratorToken(token));
          numVVEntriesToSend--;
        }
      }
      assert(numVVEntriesToSend == 0);

  }else if ( o instanceof UnbindMsg){
      UnbindMsg ubm = (UnbindMsg)o;
      
      buffer.writeShort(UNBINDMSG);
      buffer.writeObject(ubm.getObjId().getPath()); // -- objid
      buffer.writeLong(ubm.getOffset()); // -- offset
      buffer.writeLong(ubm.getLength());// -- length
      buffer.writeLong(ubm.getTime()); //--AcceptStamp.localClock
      buffer.writeLong(ubm.getNodeId().getIDint());//--AcceptStamp.nodeId
    
    }else if ( o instanceof DebargoMsg){
      DebargoMsg ubm = (DebargoMsg)o;
      
      buffer.writeShort(DEBARGOMSG);
      buffer.writeObject(ubm.getObjId().getPath()); // -- objid
      buffer.writeLong(ubm.getOffset()); // -- offset
      buffer.writeLong(ubm.getLength());// -- length
      buffer.writeLong(ubm.getTime()); //--AcceptStamp.localClock
      buffer.writeLong(ubm.getNodeId().getIDint());//--AcceptStamp.nodeId
    }else{//object not known
      buffer.writeShort(NOTPROCESSED);
      buffer.writeObject(o); // transform object into byte array.
    }
*/
    buffer.writeObject(o);
    buffer.flush();

    long len = baos.size(); // get the size of the array

    if(dbgSerial){
	System.out.println(o + " size : " + len); 
    }
    boolean isDemand = false;
    String prefix = "";
    String key = null;

    if(o instanceof BodyMsg){ // need to distigurish demand-fetch from prefetch
      isDemand = ((BodyMsg)o).isDemandReply();
      if(isDemand){
        prefix = prefix.concat("Demand-");
      }
    }else if(o instanceof GeneralInv){
      GeneralInv gi = (GeneralInv)o;
      if(!gi.isPrecise()){
        // If it is imprecise, credit its bytes toward imprecise
        // invalidates
        //System.out.println("--->" + gi);
        prefix = prefix.concat("Imprecise-");
        if(o instanceof SecureInv && SangminConfig.securityLevel == SangminConfig.COMPLETE){
          int n = 0;
          SecureImpreciseInv sii = (SecureImpreciseInv)o;
          for(NodeId nodeId : sii.getIHTuples().keySet()){
            n += sii.getIH(nodeId).size();
          }
          Stats.put("NumOfIHes", n);
        }
        Stats.put("NumOfImpreciseInv", 1);
        long n = 0;
        
        if(o instanceof ImpreciseInv){
          ImpreciseInv ii = (ImpreciseInv)o;
          AcceptVV startVV = ii.getStartVV();
          AcceptVV endVV = ii.getEndVV();
          VVIterator vvi = startVV.getIterator();
          while(vvi.hasMoreElements()){
            NodeId nodeId = vvi.getNext();
            try{
              long start = startVV.getStampByServer(nodeId);
              long end = endVV.getStampByServer(nodeId);          
              n += end-start+1;
            }catch(Exception e){            
            }
          }
        }else{
          SingleWriterImpreciseInv si = (SingleWriterImpreciseInv)o;
          n += si.getEnd() - si.getStart() + 1; 
        }
        Stats.put("ImpreciseInvSize", n);
      }else{//precise invalidate traffic
        prefix = prefix.concat("Precise-");
        //System.out.println("SecurePreciseInv len:"+len);
      }
    }
    key = prefix.concat(o.getClass().getName()); // get class name
    Stats.put(key, len); 
    if(SHOWSTATSDETAIL){
      System.err.println("stats is going to put: (" + key + ", " + len +")"
                         + "for object: " + o);
    }
    if(SHOW_OUTGOING_DATA){
      System.err.println(" outgoing object:" + o);
    }
    baos.writeTo(hbos); // write the byte array out to the network
  
    hbos.flush();
  }

  public void close() throws IOException{
    hbos.close();
    buffer.close();
    baos.close();
  }

 /** 
 *  Unit test with TaggedInputStream in TaggedInputStream.java 
 **/ 
}


/*$Log: TaggedOutputStream.java,v $
/*Revision 1.29  2007/05/25 21:06:01  dahlin
/*fixed 1 second delay on serializing start catchup stream; SubscribeBWUnit runs much faster -- though still nto as fast as I would like. Probably also need to convert catchup stream to catchup checkpoint
/*
/*Revision 1.28  2006/09/12 14:57:59  zjiandan
/*Move object custom serialization into individual classes from TaggedOutputStream
/*and TaggedInputStream. The new serialization code consumes a little bit more
/*bytes than the original approach because of java's default object information
/*overhead (I have excluded the field name and type information).
/*The major changes are using java reflection API to serialize "private final"
/*fields (which are very common among our objects that need to custom serialization).
/*Also add sanity check for each class so that we will remember to update
/*the serialization methods when we change the class definitions.
/*
/*Revision 1.27  2006/08/31 14:54:13  dahlin
/*DataStore restore from checkpoint seems to work now (including ISStatus and cVV)
/*
/*Revision 1.26  2005/10/13 00:24:24  zjiandan
/*remove Config.getMy* fixed Garbage Collection and Checkpoint exchange code
/*
/*Revision 1.25  2005/07/19 02:12:45  zjiandan
/*Add Logic to stop outgoing invalidates streams whenever
/*log garbage collector outperforms InvalIterator, i.e.
/*Log.inMemOmitVV > InvalIterator.currentVV.
/*
/*Revision 1.24  2005/07/18 05:10:23  zjiandan
/*Embargoed Writes etc. features implementation plus
/*log overhead measurement with disk size and in-memory size.
/*
/*Revision 1.23  2005/03/22 23:00:03  zjiandan
/*Changes for TactExpt.
/*
/*Revision 1.22  2005/03/16 00:50:27  nayate
/*Turned off debug printing
/*
/*Revision 1.21  2005/03/15 21:15:34  zjiandan
/*Automatic GC checked in.
/*
/*Revision 1.20  2005/03/09 00:40:57  nayate
/*Added a priority field to BodyMsg
/*
/*Revision 1.19  2005/03/09 00:15:36  nayate
/*Added a priority to BoundInvals
/*
/*Revision 1.18  2005/03/07 21:00:08  lgao
/*Planet lab exp check-in
/*
/*Revision 1.17  2005/03/05 00:17:40  nayate
/*Added code to compress serialization
/*
/*Revision 1.16  2005/03/01 10:40:35  nayate
/*First successful compilation
/*
/*Revision 1.15  2005/02/28 20:25:59  zjiandan
/*Added Garbage Collection code and part of Checkpoint exchange protocol code
/*
/*Revision 1.14  2005/01/18 22:49:43  zjiandan
/*Rewrited Class Serialization for network deliveringto reduce the overall bandwidth.
/*
/*Revision 1.13  2005/01/13 22:41:15  zjiandan
/*fixed Makefile problem and add precise invalidate statistic collection facility.
/*
/*Revision 1.12  2005/01/13 20:55:40  zjiandan
/*Reorganized sosp experiments files into sosp subdirectory under experiments.
/*
/*Revision 1.11  2005/01/10 03:47:47  zjiandan
/*Fixed some bugs. Successfully run SanityCheck and Partial Replication experiments.
/*
/*Revision 1.10  2004/07/07 21:18:51  nayate
/*Changed code to separate Imprecise Inval message counting from regular
/*inval message counting
/*
/*Revision 1.9  2004/05/26 04:42:23  arun
/**** empty log message ***
/*
/*Revision 1.8  2004/05/25 12:59:37  lgao
/*Add chain mechanism to filter the duplicated update forwarding.
/*
/*Revision 1.7  2004/05/25 07:36:39  zjiandan
/*Minor changes.
/*
/*Revision 1.6  2004/05/24 00:30:24  nayate
/*Bug fix
/*
/*Revision 1.5  2004/05/23 22:04:46  nayate
/*Added accounting mechanisms for imprecise invalidates
/*
/*Revision 1.4  2004/05/20 01:57:54  nayate
/*Added calls to flush()
/*
/*Revision 1.3  2004/05/15 00:23:17  lgao
/*Add flag to distingurish demand fetch from prefetch data.
/*
/*Revision 1.2  2004/05/11 21:46:38  lgao
/*Implementation of TaggedOutputStream which counts bytes sent over the wire.
/*
/*Revision 1.1  2004/05/10 21:17:38  lgao
/*Initial implementation
/**/
