package code;

/*
 * TestStringOrder   -- Test Basic Cursor Operation
 * 
 */

import com.sleepycat.je.DatabaseException;
import java.io.UnsupportedEncodingException;

import com.sleepycat.je.DuplicateDataException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.OperationFailureException;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.bind.tuple.IntegerBinding;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;

import java.io.File;
import java.io.IOException;

public class TestStringOrder{
  Environment env;
  Database db;
  Cursor cursor;
  // private SerialBinding logRecordBinding;
  private SerialBinding vvBinding;
  private SerialBinding invBinding;
  private StoredClassCatalog classCatalog;
  final private String classDbName = "StoredClassCatalog";
  


    public 
    TestStringOrder()
    throws IOException{
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setTransactional(true);
        envConfig.setAllowCreate(true);

        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setTransactional(true);
        dbConfig.setAllowCreate(true);

        File dbDir = new File("/tmp/testStringOrder");
        
        try{
            dbDir.mkdirs();
            env = new Environment(dbDir, 
                                  envConfig);
	    db = env.openDatabase(null, "PerObjState", dbConfig);
	    cursor = db.openCursor(null, null);

                        
        }catch(DatabaseException dbe){
            String msg = dbe.toString();
    
            throw new IOException("Exception opening berkeleyDB Environment: " 
                                  + msg);
        }

    }
    
    public void 
    populateDB()
    throws DatabaseException{
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry(); 
        
	ObjId oid = new ObjId("/root.data");
	try{
	  key = new DatabaseEntry(oid.getPath().getBytes("UTF-8"));
	}catch(UnsupportedEncodingException uee){
	  assert(false);
	}
	IntegerBinding.intToEntry(0, data);
	OperationStatus status =
	  db.put(null, key, data);
	if (status != OperationStatus.SUCCESS) {
	  throw new DuplicateDataException("Data insert Status: " +
				      status);
	}

	oid = new ObjId("/root.data/dir2.meta");
	try{
	  key = new DatabaseEntry(oid.getPath().getBytes("UTF-8"));
	}catch(UnsupportedEncodingException uee){
	  assert(false);
	}
	IntegerBinding.intToEntry(3, data);
	status = db.put(null, key, data);
	if (status != OperationStatus.SUCCESS) {
	  throw new DuplicateDataException("Data insert Status: " +
				      status);
	}

	oid = new ObjId("/root.data/dir1.data/file1.meta");
	try{
	  key = new DatabaseEntry(oid.getPath().getBytes("UTF-8"));
	}catch(UnsupportedEncodingException uee){
	  assert(false);
	}
	IntegerBinding.intToEntry(1, data);
	status = db.put(null, key, data);
	if (status != OperationStatus.SUCCESS) {
	  throw new DuplicateDataException("Data insert Status: " +
				      status);
	}

	oid = new ObjId("/root.data/dir1.data/file.meta");
	try{
	  key = new DatabaseEntry(oid.getPath().getBytes("UTF-8"));
	}catch(UnsupportedEncodingException uee){
	  assert(false);
	}
	IntegerBinding.intToEntry(2, data);
	status = db.put(null, key, data);
	if (status != OperationStatus.SUCCESS) {
	  throw new DuplicateDataException("Data insert Status: " +
				      status);
	}

	
    
	
    }

    public void
    testCursor(String searchsub)
    throws DatabaseException {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        OperationStatus status;
	ObjId oid = null;
	int order = -1;
	populateDB();
        status = cursor.getFirst(key, data, null);
        if(status == OperationStatus.SUCCESS){
          oid = new ObjId(new String(key.getData()));
	  order = IntegerBinding.entryToInt(data);
	  assert oid.equals(new ObjId("/root.data")):oid;
	    assert order == 0: order;
        }
	
	status = cursor.getNext(key, data, null);
        if(status == OperationStatus.SUCCESS){
          oid = new ObjId(new String(key.getData()));
	  order = IntegerBinding.entryToInt(data);
	  assert oid.equals(new ObjId("/root.data/dir1.data/file.meta")):oid;
	    assert order == 2: order;
        }

        status = cursor.getNext(key, data, null);
        if(status == OperationStatus.SUCCESS){
          oid = new ObjId(new String(key.getData()));
	  order = IntegerBinding.entryToInt(data);
	  assert oid.equals(new ObjId("/root.data/dir1.data/file1.meta")):oid;
	    assert order == 1: order;
        }
	
	
	status = cursor.getNext(key, data, null);
        if(status == OperationStatus.SUCCESS){
          oid = new ObjId(new String(key.getData()));
	  order = IntegerBinding.entryToInt(data);
	  assert oid.equals(new ObjId("/root.data/dir2.meta")):oid;
	    assert order == 3: order;
        }
	
	

        status = cursor.getLast(key, data, null);
        if(status == OperationStatus.SUCCESS){
          oid = new ObjId(new String(key.getData()));
	  order = IntegerBinding.entryToInt(data);
	  assert oid.equals(new ObjId("/root.data/dir2.meta")):oid;
	    assert order == 3: order;
        }
	
	ObjId myss = new ObjId("/root.data");
	try{
	  key = new DatabaseEntry(myss.getPath().getBytes("UTF-8"));
	}catch(UnsupportedEncodingException uee){
	  assert(false);
	}
	status = cursor.getSearchKeyRange(key, data, null);
	if(status == OperationStatus.SUCCESS){
          oid = new ObjId(new String(key.getData()));
	  order = IntegerBinding.entryToInt(data);
	  assert oid.equals(new ObjId("/root.data")):oid;
	    assert order == 0: order;
        }

        myss = new ObjId("/root.data/z");
	try{
	  key = new DatabaseEntry(myss.getPath().getBytes("UTF-8"));
	}catch(UnsupportedEncodingException uee){
	  assert(false);
	}
	status = cursor.getSearchKeyRange(key, data, null);
	assert (status == OperationStatus.NOTFOUND);

	myss = new ObjId("/root.data/dir");
	try{
	  key = new DatabaseEntry(myss.getPath().getBytes("UTF-8"));
	}catch(UnsupportedEncodingException uee){
	  assert(false);
	}
	status = cursor.getSearchKeyRange(key, data, null);
	if(status == OperationStatus.SUCCESS){
          oid = new ObjId(new String(key.getData()));
	  order = IntegerBinding.entryToInt(data);
	  assert oid.equals(new ObjId("/root.data/dir1.data/file.meta")):oid;
	    assert order == 2: order;
        }
	
	myss = new ObjId("/root.data/dir1.data");
	try{
	  key = new DatabaseEntry(myss.getPath().getBytes("UTF-8"));
	}catch(UnsupportedEncodingException uee){
	  assert(false);
	}
	status = cursor.getSearchKeyRange(key, data, null);
	if(status == OperationStatus.SUCCESS){
          oid = new ObjId(new String(key.getData()));
	  order = IntegerBinding.entryToInt(data);
	  assert oid.equals(new ObjId("/root.data/dir1.data/file.meta")):oid;
	    assert order == 2: order;
        }

	myss = new ObjId("/root.data/dir1.data/file1.");
	try{
	  key = new DatabaseEntry(myss.getPath().getBytes("UTF-8"));
	}catch(UnsupportedEncodingException uee){
	  assert(false);
	}
	status = cursor.getSearchKeyRange(key, data, null);
	if(status == OperationStatus.SUCCESS){
          oid = new ObjId(new String(key.getData()));
	  order = IntegerBinding.entryToInt(data);
	  assert oid.equals(new ObjId("/root.data/dir1.data/file1.meta")):oid;
	    assert order ==1: order;
        }
	
	myss = new ObjId("/root.data/dir2");
	try{
	  key = new DatabaseEntry(myss.getPath().getBytes("UTF-8"));
	}catch(UnsupportedEncodingException uee){
	  assert(false);
	}
	status = cursor.getSearchKeyRange(key, data, null);
	if(status == OperationStatus.SUCCESS){
          oid = new ObjId(new String(key.getData()));
	  order = IntegerBinding.entryToInt(data);
	  assert oid.equals(new ObjId("/root.data/dir2.meta")):oid;
	    assert order == 3: order;
        }

	//test SubscriptionSet
	
	System.out.println("going to work for SubscriptionSet:" + searchsub);
	SubscriptionSet subset = SubscriptionSet.makeSubscriptionSet(searchsub);
	String ss = subset.toString();
	
	System.out.println("ss=" + ss);
	String[] ssItem = ss.split(":");
	boolean matchPrefix;
	String searchKeyStr = null;
	for(int i = 0; i < ssItem.length; i ++){
	  
	  ssItem[i].trim();
	  searchKeyStr = ssItem[i];
	  if(ssItem[i].endsWith("/*")){
	    matchPrefix = true;
	    searchKeyStr = ssItem[i].substring(0, ssItem[i].length()-1);//get rid of the *
	  }else{
	    matchPrefix = false;
	  }
	  assert searchKeyStr != null;
	  System.out.println("searchKeyStr: " + searchKeyStr);
	  try{
	    key = new DatabaseEntry(searchKeyStr.getBytes("UTF-8"));
	  }catch(UnsupportedEncodingException e){
	    assert false;
	  }
	  if (matchPrefix){
	    status = cursor.getSearchKeyRange(key, data, null);
	  }else{
	    status = cursor.getSearchKey(key, data, null);
	  }
	  //OperationStatus status = posCursor.getNext(posKey, posData, null);
	  while(status == OperationStatus.SUCCESS){
	    ObjId objId = new ObjId(new String(key.getData()));
	    if(!matchPrefix){
	      assert objId.getPath().equals(searchKeyStr);
	      System.out.println("find exact match for " + searchKeyStr);
	    }else{
	      if(!objId.getPath().startsWith(searchKeyStr)){
		System.out.println("find non prefix match for " + searchKeyStr + " : "+ objId);
		break;//stop here: this objId does not contains a prefix of the searchKeyStr
		//and don't need to check next record for perObjState
	      }
	      System.out.println("find prefix match for " + searchKeyStr + " : "+ objId);
	    }
	    if(matchPrefix){
	      status = cursor.getNext(key, data, null);
	      System.out.println("continue search for : " + searchKeyStr);
	    }else{//match exactly one
	      System.out.println("stop search for exact match of : " + searchKeyStr);
	      break;//no more record exactly match   
	    }
	  }
	}
    }

   
    public void 
    close()
    throws DatabaseException{
        if(cursor != null){
            cursor.close();
            cursor = null;
        }
        db.close();
        //classDb.close();
        env.sync();
        env.close();
    }
    
    public static void 
    main(String[] argv)
      throws Exception{
      TestStringOrder myCursor = null;
      try{
	myCursor = new TestStringOrder();
	System.out.println("argv:"+argv[0]);
	myCursor.testCursor(argv[0]);
      } finally {
	if( myCursor != null){
	  myCursor.close();
	}
      }
      
      
    }
}



