package code;

/* TimeKey.java
 * 
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */

import java.util.Comparator;

public class TimeKey implements Comparator
{
    private long timeMS;
    private long uniq;

    public TimeKey(long timeMS, long uniq)
    {
	this.timeMS = timeMS;
	this.uniq = uniq;
    }

    public long
    getTimeMS()
    {
	return timeMS;
    }

    public boolean 
    equals(Object o)
    {
	try{
	    TimeKey k = (TimeKey)o;
	    if(k.timeMS != this.timeMS){
		return false;
	    }
	    if(k.uniq != this.uniq){
		return false;
	    }
	    return true;
	}
	catch(ClassCastException e){
	    return false;
	}
    }

    public int
    compare(Object o1, Object o2)
    {
	try{
	    TimeKey k1 = (TimeKey)o1;
	    TimeKey k2 = (TimeKey)o2;
	    if(k1.timeMS < k2.timeMS){
		return -1;
	    }
	    if(k2.timeMS < k1.timeMS){
		return 1;
	    }
	    if(k1.uniq < k2.uniq){
		return -1;
	    }
	    if(k2.uniq < k1.uniq){
		return 1;
	    }
	    return 0;
	}
	catch(ClassCastException e){
	    assert(false); // This comparitor should only be used for comparing
	                   // TimeKey s.
	    return -1;
	}
	
    }
}
