package code;

 /** 
 *  Worker gets timeouts from TimeoutQueue and applies them to TimeoutHandler 
 **/ 

public class TimeoutQueueWorker extends Thread
{
    TimeoutQueue timeouts;
    TimeoutHandler receiver;

    public TimeoutQueueWorker(TimeoutQueue t, TimeoutHandler r)
    {
	timeouts = t;
	receiver = r;
    }

    public void run()
    {
	while(true){
	    Object event = timeouts.getNext();
	    receiver.handleTimeout(event);
	}
    }

    public static void main(String s[])
    {
	long delay;
	Long item;
	
	System.err.print("TimoutQueueWorker self test ...");

	TimeoutQueue q = new TimeoutQueue();
	TestHandler h = new TestHandler(5);
	TimeoutQueueWorker w = new TimeoutQueueWorker(q, h);
	w.start();
	
	delay = 1000;
	item = new Long(1);
	q.insert(delay, item);
	
	delay = 3000;
	item = new Long(3);
	q.insert(delay, item);
	
	Thread.yield();

	delay = 5000;
	item = new Long(5);
	q.insert(delay, item);

	delay = 2000;
	item = new Long(2);
	q.insert(delay, item);

	delay = 4000;
	item = new Long(4);
	q.insert(delay, item);

	try{
	    w.join(); // Never returns
	}
	catch(java.lang.InterruptedException e){
	    assert(false);
	}
    }
}




class TestHandler implements TimeoutHandler
{
    long lastOne = 0;
    long max;
    public 
    TestHandler(long max)
    {
	this.max = max;
    }

    public void 
    handleTimeout(Object event)
    {
	Long value = (Long)event;
	System.err.print(" " + value);
	if(value.longValue() != lastOne + 1){
	    System.err.println("Error in TimeoutQueueWorker self test");
	    System.exit(-1);
	}
	lastOne++;
	if(lastOne == max){
	    System.err.println("TimoutQueueWorker self test passes");
	    System.exit(0);
	}
    }

}

//---------------------------------------------------------------------------
/* $Log: TimeoutQueueWorker.java,v $
/* Revision 1.2  2004/05/10 20:52:57  dahlin
/* Fixed ^M formatting
/*
/* Revision 1.1  2004/05/08 22:20:17  dahlin
/* Partially complete version of SDIMSController (it should compile w/o error, though)
/*
 */
//---------------------------------------------------------------------------
