package code;

/* 
 * TimingStats
 * 
 * Keeps track of various timing info
 */

import java.util.*;

public class TimingStats {
  protected LinkedHashMap resultStatsData = new LinkedHashMap(); 
  protected Hashtable startTimes = new Hashtable();

  private boolean enableTimingStats = false;

  public TimingStats() {
    enableTimingStats = false;
  }

  public TimingStats(boolean enable) {
    enableTimingStats = enable;
  }

  public void enableTimingStats(){
    enableTimingStats = true;
  }

  // initialize table entry so that it does not need to be done 
  //  on the fly
  public void initialize(String key) {
    resultStatsData.put(key, new ResultStats());
  }

  public void totalTime(String key, double time){
    if(enableTimingStats) {
      ResultStats stats = (ResultStats) resultStatsData.get(key);
      if(stats == null){
        stats = new ResultStats();
        resultStatsData.put(key, stats);
      }
      stats.enter(time);
    }
  }

  
  public void startTimer(String key) {
    //
    //  Note: we only can have one start timer per key
    //
    if(enableTimingStats){
      startTimes.put(key, new Double(System.currentTimeMillis()));
    }
  }

  public void endTimer(String key) {
    if(enableTimingStats){
      double endTime = (double) System.currentTimeMillis();
      Double startTimeD = (Double) startTimes.get(key);
      if (startTimeD != null) {
        double time = endTime - startTimeD.doubleValue();
        totalTime(key, time);
      }
    }
  }

  public ResultStats getResultStats(String key){
    return (ResultStats) resultStatsData.get(key);
  }

  public String toString() {
    String str = "";
    Iterator i = resultStatsData.entrySet().iterator();
    while(i.hasNext()){
      Map.Entry entry = (Map.Entry) i.next();
      str += (String) entry.getKey() + "::\t" +
        ((ResultStats) entry.getValue()).toString() + "\n";
    }

    return str;
            
  }

  public String getSummary(int ignoreFirst){
    String str = "";
    Iterator i = resultStatsData.entrySet().iterator();
    while(i.hasNext()){
      Map.Entry entry = (Map.Entry) i.next();
      str += (String) entry.getKey() + "::\t" +
        ((ResultStats) entry.getValue()).getSummary(ignoreFirst) + "\t" + 
        ((ResultStats) entry.getValue()).getAverage90() + "\n";
    }
    
    return str;
  }

  public String getAllData(){
    String str = "";
    Iterator i = resultStatsData.entrySet().iterator();
    while(i.hasNext()){
      Map.Entry entry = (Map.Entry) i.next();
      str += (String) entry.getKey() + "::\n" +
        ((ResultStats) entry.getValue()).getAllData() + "\n";
    }
    
    return str;
  }

}