package code;

/* TreeMapValueSearch --
 *
 * A TreeMap that also allows search by/remove by value. (Just linear search
 * of all values -- works OK for cases when we don't expect long lists.)
 * 
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */

import java.util.TreeMap;
import java.util.Comparator;
import java.util.Iterator;


public class TreeMapValueSearch extends TreeMap
{

 /** 
 *  constructor
 
 **/ 
  public TreeMapValueSearch(Comparator c){
    super(c);
  }

 /** 
 *  Find and return a reference to an Object stored in the TreeMap
 
 *  whose value EQUALS val
 
 **/ 
  public Object findByValue(Object val){
    Iterator i = this.values().iterator();
    while(i.hasNext()){
      Object pendingObj = i.next();
      if (pendingObj.equals(val)){
        return pendingObj;
      }
    }
    return null;
  }


 /** 
 *  Find, remove, and return a reference to an Object stored in the TreeMap
 
 *  whose value EQUALS val. Return null if no match.
 
 **/ 
  public Object removeByValue(Object val) {
    Iterator i = this.values().iterator();
    while(i.hasNext()){
      Object pendingObj = i.next();
      if (pendingObj.equals(val)){
        i.remove();
        return pendingObj;
      }
    }
    return null;
  }

  public String toString() {
    String str= "<";
    Iterator i = this.values().iterator();
    while(i.hasNext()){
      Object obj = i.next();
      str = str + obj.toString() + ":";
    }
    
    int j = str.length();
    str = str.substring(0, j-1);
    str = str + ">";
    return str;
  }
}
