package code;

 /** 
 *  Trivial version of spanning tree directory -- use a static list of nodes 
 *  and always return the lowest-numbered nodeId that is larger than my nodeId 
 *  (or my nodeId if I am the highest numbered node.) 
 **/ 
import java.util.Enumeration;

public class TrivialSpanningDirectory implements SpanningDirectory{

NodeId parent;
public TrivialSpanningDirectory(NodeId myNodeId_)
{
    parent = getTargetFromConfig(myNodeId_);
}
    
/*
 *------------------------------------------------------------------
 *
 *  getTargetAndSubscribeNotifyChanges --
 *
 *          Return node that is parent in the spanning tree for the
 *          specified interest set (or my node ID if I am the root 
 *          for that spanning tree).
 *
 *          Additionally, register a callback -- if my parent
 *          changes, the directory will call SpanningChangeHandler
 *
 * Arguments:
 *      SubscribeInvalRequest r -- identifies the spanning tree as well
 *                                 as info about the request (e.g., retry
 *                                 count)
 *      SpanningChangeHandler controllerToNotify -- who to callback on change
 *
 * Results:
 *      NodeId of parent in spanning tree
 *      null on error (caller should retry after timeout. No callback registered.)
 *      Return my own NodeId if I am the root of this spanning tree.
 *
 * Side effects:
 *      None.
 *
 *------------------------------------------------------------------
 */
public NodeId getTargetAndSubscribeNotifyChanges(SubscribeInvalRequest r, 
						 SpanningChangeHandler controllerToNotify)
{
    return parent;
}


/*
 *------------------------------------------------------------------
 *
 * getTargetFromConfig --
 *
 *          Return the node with the lowest nodeId that is higher
 *          than mine or my own nodeID if I have the max.
 *
 * Arguments:
 *      None.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *------------------------------------------------------------------
 */
private static NodeId
getTargetFromConfig(NodeId myNodeId)
{
    assert(Config.isInitialized());
    
    Enumeration e = Config.getKnownNodeIds();
    NodeId current;
    NodeId minBiggerThanMe = null;
    while(e.hasMoreElements()){
	current = (NodeId)e.nextElement();
	if(current.equals(myNodeId)){
	    continue;
	}
	assert(!current.equals(myNodeId));
	if(current.compareTo(myNodeId) > 0){
	    if(minBiggerThanMe == null){
		minBiggerThanMe = current;
	    }
	    else{
		if(current.compareTo(minBiggerThanMe) < 0){
		    minBiggerThanMe = current;
		}
	    }
	}
    }
    if(minBiggerThanMe == null){
	return myNodeId; // I am root
    }
    assert(minBiggerThanMe.compareTo(myNodeId) > 0);
    return minBiggerThanMe;
}
    



public static void 
main(String s[])
{
    System.err.print("TrivialSpanningDirectory self test...");

    NodeId n = new NodeId(1);
    Config.readConfig("test/spanning-tree-worker-test.config");
    NodeId expect = new NodeId(2);
    
    NodeId got = getTargetFromConfig(n);
    assert(got.equals(expect));

    n = new NodeId(2);
    Config.readConfig("test/spanning-tree-worker-test.config");
    expect = new NodeId(11);
    got = getTargetFromConfig(n);
    assert(got.equals(expect));

    n = new NodeId(11);
    Config.readConfig("test/spanning-tree-worker-test.config");
    expect = new NodeId(13);
    got = getTargetFromConfig(n);
    assert(got.equals(expect));

    n = new NodeId(13);
    Config.readConfig("test/spanning-tree-worker-test.config");
    expect = new NodeId(13);
    got = getTargetFromConfig(n);
    assert(got.equals(expect));

    System.err.println("TrivialSpanningTreeDirectory self test succeeds");
    System.exit(0);
    
}



}

//---------------------------------------------------------------------------
/* $Log: TrivialSpanningDirectory.java,v $
/* Revision 1.3  2005/10/13 00:24:24  zjiandan
/* remove Config.getMy* fixed Garbage Collection and Checkpoint exchange code
/*
/* Revision 1.2  2004/05/19 02:14:44  dahlin
/* Making progress on SDIMSController spanning test
/*
/* Revision 1.1  2004/05/13 18:49:17  dahlin
/* Clean SDIMSController by moving SpanningTree directory out as separate class (rather than using raw SDIMSInterface)
/*
 */
//---------------------------------------------------------------------------

