package code;

/* TwoNodesSubscriptionUnitHelper.java
 * 
 * Helper for TwoNodesSubscriptionUnit -- when invoked by that code, start
 * a PicShareWriterProcess that writes a bunch of known files.
 * 
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */

import java.util.*;
import java.io.*;
import code.security.SecureURANode;
import code.security.holesync.filter.Filter;
import code.security.holesync.filter.SubscriptionSetFilter;

public class TwoNodesSubscriptionUnitHelper {
  private final static boolean verbose = true;
  private final static boolean vverbose = true;

  private static Core core;

 /** 
 *  Write the specified PRACTI files. Then wait until reading done. Then write
 
 *  more stuff. Then die. When restarted, read the old stuff and write some 
 
 *  different stuff.
 
 **/ 
  public static void main(String s[]) {
    doFirst();
    System.exit(0);
  }

 /** 
 *  First time around -- write a bunch of stuff.
 
 **/ 
  private static void doFirst(){
    BarrierClient c = new BarrierClient("127.0.0.1", TwoNodesSubscriptionUnit.BARRIER_PORT, 1);
    NodeId myNodeId = new NodeId(TwoNodesSubscriptionUnit.HELPER_NODE_ID);
    NodeId unitNodeId = new NodeId(TwoNodesSubscriptionUnit.UNIT_NODE_ID);
    int ni = TwoNodesSubscriptionUnit.ni;
    int nj = TwoNodesSubscriptionUnit.nj;
    int nk = TwoNodesSubscriptionUnit.nk;
  
    if(vverbose){
      System.out.println("UNIT ID: " + myNodeId.toString());
    }
    assert(myNodeId.equals(new NodeId(TwoNodesSubscriptionUnit.HELPER_NODE_ID)));

    URANode node;
    if(TwoNodesSubscriptionUnit.useSecure){
      SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
      LinkedList<Filter> f = new LinkedList<Filter>();
      f.add(ssf);
        
      node = new SecureURANode(TwoNodesSubscriptionUnit.CONFIG_PATH, myNodeId, 
          Controller.NULL_CONTROLLER, 
          true,//cleanDB 
          true, new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);//noSynLog
    }else{
      node = new URANode(TwoNodesSubscriptionUnit.CONFIG_PATH, myNodeId, 
          Controller.NULL_CONTROLLER, 
          true,//cleanDB 
          true);//noSynLog
    }
    // make sure the accumulate time is long enoug so that we don't
    // get PInvals when we are expecting ImpInval
    core = node.getCore();
    node.getCore().setMaxAccumulateTime(2000);
    LocalInterface li = node.getLocalInterface();
    RMIClient ci = node.getRMIClientInterface();
    if(verbose){
      System.out.println("HELLO from TwoNodesSubscriptionUnitHelper");
    }


    if(verbose){
      System.out.println("TwoNodesSubscriptionUnitHelper constructor done");
    }

    if(verbose){
      System.out.println("barrier 1");
    }
    c.sendBarrierRequest(0, 1); // 1 Tell TwoNodesSubscriptionUnit that we are up and running

    

    if(verbose){
      System.out.println("Both nodes up and running. Initial " + ni*nj*nk + " writes done.");
      
    }
    try{
      String waitPath = TwoNodesSubscriptionUnit.COARSE_PATH + "/"+(ni-1)+"/"+(nj-1)+"/"+(nk-1);
      if(verbose){
        System.out.println("stage 1 get coarse all: Helper will wait to see " +  ni*nj*nk + " writes " + waitPath);
        System.out.println("1 wait for " + waitPath);
        
      }
      //subscribe for all objects in coarse path and wait for the last one
      TwoNodesSubscriptionUnit.subscribeAndWait(TwoNodesSubscriptionUnit.COARSE_PATH +"/*", 
          unitNodeId, myNodeId,
          waitPath,
          li, ci,
          true);

      if(verbose){ 
        System.out.println("1 wait for return " + waitPath);
        System.out.println("Helper has subscribed and received " + ni*nj*nk + " invals");
      }
//      
//      try {
//		Thread.sleep(10000);
//	} catch (InterruptedException e) {
//		// TODO Auto-generated catch block
//		e.printStackTrace();
//	}
	
	if(verbose){ 
        System.out.println("woke up after sleeping");
      }
      
      c.sendBarrierRequest(0, 1);  // 2

      //subscribe for the last object in the fine_log dir by catching up by log
      waitPath = TwoNodesSubscriptionUnit.FINE_PATH_LOG + "/"+(ni-1)+"/"+(nj-1)+"/"+(nk-1);
      if(verbose){
        System.out.println("stage 2 get last fine by log: Helper will wait to see " + waitPath);
        System.out.println("2 wait for " + waitPath);
        
      }
      TwoNodesSubscriptionUnit.subscribeAndWait(waitPath, //subscribe for last one 
          unitNodeId, myNodeId,
          waitPath,
          li, ci,
          false);//by log
      c.sendBarrierRequest(0, 1); // 3 Helper has subscribed and received ni*nj*nk invals
      
      
      if(verbose){
        System.out.println("Helper has subscribed and received " +  ni*nj*nk 
            + " invals from " + TwoNodesSubscriptionUnit.FINE_PATH_LOG);
      }
      
    //subscribe for the last object in the fine_cp dir by catching up by cp
      waitPath = TwoNodesSubscriptionUnit.FINE_PATH_CP + "/"+(ni-1)+"/"+(nj-1)+"/"+(nk-1);
      if(verbose){
        System.out.println("stage 3 get last fine by log: Helper will wait to see " + waitPath);
        System.out.println("3 wait for " + waitPath);
        
      }
//      TwoNodesSubscriptionUnit.subscribeAndWait(waitPath, //subscribe for last one 
//          unitNodeId, myNodeId,
//          waitPath,
//          li, ci,
//          true);//by cp
      if(verbose){
          System.out.println("Helper has subscribed and received " +  ni*nj*nk 
              + " invals from " + TwoNodesSubscriptionUnit.FINE_PATH_CP);
        }
      c.sendBarrierRequest(0, 1); // 4 Helper has subscribed and received ni*nj*nk invals
      
      if(verbose){
          System.out.println("Helper has subscribed and received " +  ni*nj*nk 
              + " invals from " + TwoNodesSubscriptionUnit.FINE_PATH_CP);
        }
      
      waitPath = TwoNodesSubscriptionUnit.LAST_STAGE_PATH + "/"+(ni-1)+"/"+(nj-1)+"/"+(nk-1);
      
      TwoNodesSubscriptionUnit.subscribe(waitPath, //subscribe for last one 
          unitNodeId, myNodeId,
          li, ci,
          false);//by log
      if(verbose){
        System.out.println("Helper has subscribed for " + waitPath );
      }
      
      c.sendBarrierRequest(0, 1); // 5 Helper has subscribed for last stage
      
      if(verbose){
        System.out.println("Helper waits for " + waitPath);
      }
      TwoNodesSubscriptionUnit.waitObj(waitPath, //wait until it receives the obj
          li);
      
      if(verbose){
        System.out.println("Helper waits for return " + waitPath );
      }
      c.sendBarrierRequest(0, 1); // 6 Helper has subscribed for last stage
      if(verbose){
        System.out.println("Helper is done");
      }

    }finally{
      //
      // Make sure we release all of the ports and mem so that next
      // unit test can run.
      //
      node.shutdown();
      node = null;
      System.gc();

    }
  }





}
