package code;

 /** 
 *  Unit test for UpdateLogUnit
 
 **/ 

import junit.textui.TestRunner;
import junit.framework.*;
import java.util.*;
import java.io.*;



/**
 * TBD: Update class name
 */
public class UpdateLogUnit extends TestCase {
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  protected static boolean verbose = false; // Start/end of test
  protected static boolean vverbose = false; // Test internals
  // private Process rmiregistry;
  
  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public UpdateLogUnit (final String s) {
    super (s);
  }


  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
    makePractiConfig();
    /*
    //
    // Start the registry
    //
    rmiregistry = Runtime.getRuntime().exec("rmiregistry");
    Env.dprintln(verbose, "rmiregistry started");
    Thread.sleep(2000);
    */
  }

  protected void tearDown() throws Exception{
    /*
      rmiregistry.destroy();
    */
    super.tearDown();
    
  }



 /** 
 *  Test basic functions
 
 **/ 
  public void testSimple(){
    if(vverbose){
      Env.dprintln(vverbose, "testSimple start...");
    }
    try{
    UpdateLog log = makeEmptyLog("test" + File.separatorChar + "UpdateLog_testSimple_log",
        new NodeId(9));
    GeneralInv ginv = null;
    SingleWriterInval sinv = null;
    BoundInval bi = null;
    log.verifyInvariants();
    if (verbose) System.out.println(log);
    System.out.println("Pass test 1.0");

    //multiple precise writes to multiple files by one writer
    byte[] bdy = null;
	    	    
    UnbindMsg ubm = null; 
    Object obj = null;
	    
    AcceptVV acceptVV1 = null;
    AcceptVV acceptVV2 = null;
    AcceptStamp[] as1 = null;
    AcceptStamp[] as2 = null;
    AcceptStamp[] as3 = null;
    CounterVV counterVV1 = null;
    CounterVV counterVV2 = null;
    CounterVV counterVV3 = null;
    bdy = new byte[5];
    bdy[0] = 10;
    bdy[1] = 9;
    bdy[2] = 8;
    bdy[3] = 7;
    bdy[4] = 6;
    ImmutableBytes body = new ImmutableBytes(bdy);
	
    as1 = new AcceptStamp[1];
	    
    as1[0] = log.write(new ObjId("/d1/bound1"), 
		       10, 
		       body.getLength(),
		       Core.DEFAULT_PRIORITY,
		       new AcceptStamp(System.currentTimeMillis(), 
				       new NodeId(9)),
		       body, 
		       true,//bound invalidate
		       Long.MAX_VALUE,
		       false);
    if (verbose) System.out.println(log);
	    
    as2 = new AcceptStamp[1];
    as2[0]=log.write(new ObjId("/d2/unbound1"), 
		     10, 
		     body.getLength(),
		     Core.DEFAULT_PRIORITY,
		     new AcceptStamp(System.currentTimeMillis(), 
				     new NodeId(9)),
		     body, 
		     false,//unbound invalidate
		     Long.MAX_VALUE,
		     false);
    if (verbose) System.out.println(log);
	    
    log.verifyInvariants();
	    
    counterVV3 = new CounterVV();
    
    obj = log.getNext(-1, counterVV3, 100);
    
    assert((obj instanceof BoundInval)
	   && (((ObjInvalTarget)(((BoundInval)(obj)).getInvalTarget())
		).getObjId().equals(new ObjId("/d1/bound1") )));
    assert((((BoundInval)(obj)).getAcceptStamp().getLocalClock() 
	    == as1[0].getLocalClock())
	   &&(((BoundInval)(obj)).getAcceptStamp().getNodeId()
	      .equals( as1[0].getNodeId())));
	    
    counterVV3.advanceTimestamps(new AcceptVV(as1));
    obj = log.getNext(-1, counterVV3, 5);
    assert((obj instanceof PreciseInv)
	   && (((ObjInvalTarget)(((PreciseInv)(obj)).getInvalTarget())
		).getObjId().equals(new ObjId("/d2/unbound1") )));
    assert((((PreciseInv)(obj)).getAcceptStamp().getLocalClock() 
	    == as2[0].getLocalClock())
	   &&(((PreciseInv)(obj)).getAcceptStamp().getNodeId()
	      .equals( as2[0].getNodeId())));
	    
    counterVV3.advanceTimestamps(new AcceptVV(as2));
    System.out.println("Pass Test 1.1");

    //imprecise writes overlappping in time
    SingleWriterImpreciseInv ii1 = null;
    ImpreciseInv ii2 = null;
	    
    String[] dir = new String[2];
    dir[0] = "/d1/*";
    dir[1] = "/d2/*";
	    
    String[] dir1=new String[1];
    dir1[0] = "/d1/*";
	    
    String[] dir2=new String[1];
    dir2[0] = "/d2/*"; 

    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(0, new NodeId(200));
    as1[1] = new AcceptStamp(0, new NodeId(300));
    as2 = new AcceptStamp[2];
    as2[0] = new AcceptStamp(30, new NodeId(200));
    as2[1] = new AcceptStamp(30, new NodeId(300));
	    
    ii2 = new ImpreciseInv(HierInvalTarget.makeHierInvalTarget(dir),
			   new AcceptVV(as1),
			   new AcceptVV(as2));
    if (verbose) System.out.println("Applying inv: "+ ii2);
    log.applyInval(ii2);
	    
    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(10, new NodeId(200));
    as1[1] = new AcceptStamp(10, new NodeId(300));
    as2 = new AcceptStamp[2];
    as2[0] = new AcceptStamp(20, new NodeId(200));
    as2[1] = new AcceptStamp(20, new NodeId(300));
    ii2 = new ImpreciseInv(HierInvalTarget.makeHierInvalTarget(dir1),
			   new AcceptVV(as1),
			   new AcceptVV(as2) );
    if (verbose) System.out.println("Applying inv: "+ ii2);
    log.applyInval(ii2);
    if (verbose) System.out.println(log);
    log.verifyInvariants();
	    
    obj = log.getNext(-1, counterVV3, 5);
    //should be ["200", 0-9, dir]
    assert((obj instanceof SingleWriterInval)
	   &&(((SingleWriterInval)(obj)).getEnd() == 9)
	   &&(((SingleWriterInval)(obj)).getStart() == 0)
	   &&(((SingleWriterInval)(obj)).getNodeId()
	      .equals( as1[0].getNodeId())));
	    
    counterVV3.advanceTimestamps(((SingleWriterInval)(obj)).getEndVV());
    obj = log.getNext(-1, counterVV3, 5);
    //should be ["300", 0-9, dir]
    assert((obj instanceof SingleWriterInval)
	   &&(((SingleWriterInval)(obj)).getEnd() == 9)
	   &&(((SingleWriterInval)(obj)).getStart() == 0)
	   &&(((SingleWriterInval)(obj)).getNodeId()
	      .equals( as1[1].getNodeId())));
	    
    counterVV3.advanceTimestamps(((SingleWriterInval)(obj)).getEndVV());
	    
    obj = log.getNext(-1, counterVV3, 5);
    //should be ["200", 10-20, dir1]
    assert((obj instanceof SingleWriterInval)
	   &&(((SingleWriterInval)(obj)).getEnd() == 20)
	   &&(((SingleWriterInval)(obj)).getStart() == 10)
	   &&(((SingleWriterInval)(obj)).getNodeId()
	      .equals( as1[0].getNodeId())));
	    
    counterVV3.advanceTimestamps(((SingleWriterInval)(obj)).getEndVV());
    obj = log.getNext(-1, counterVV3, 5);
    //should be ["300", 10-20, dir1]
    assert((obj instanceof SingleWriterInval)
	   &&(((SingleWriterInval)(obj)).getEnd() == 20)
	   &&(((SingleWriterInval)(obj)).getStart() == 10)
	   &&(((SingleWriterInval)(obj)).getNodeId()
	      .equals( as1[1].getNodeId())));
	    
    counterVV3.advanceTimestamps(((SingleWriterInval)(obj)).getEndVV());
	    
    log.verifyInvariants();
    obj = log.getNext(-1, counterVV3, 5);
    //should be ["200", 21-30, dir]
    assert((obj instanceof SingleWriterInval)
	   &&(((SingleWriterInval)(obj)).getEnd() == 30)
	   &&(((SingleWriterInval)(obj)).getStart() == 21)
	   &&(((SingleWriterInval)(obj)).getNodeId()
	      .equals( as1[0].getNodeId())));
	    
    counterVV3.advanceTimestamps(((SingleWriterInval)(obj)).getEndVV());
    obj = log.getNext(-1, counterVV3, 5);
    //should be ["300", 21-30, dir]
    assert((obj instanceof SingleWriterInval)
	   &&(((SingleWriterInval)(obj)).getEnd() == 30)
	   &&(((SingleWriterInval)(obj)).getStart() == 21)
	   &&(((SingleWriterInval)(obj)).getNodeId()
	      .equals( as1[1].getNodeId())));
	    
    counterVV3.advanceTimestamps(((SingleWriterInval)(obj)).getEndVV());

    System.out.println("Pass Test 1.2");
	
       
    as1 = new AcceptStamp[3];
    as1[0] = new AcceptStamp(1, log.getMyNodeId());
    as1[1] = new AcceptStamp(10, new NodeId(200));
    as1[2] = new AcceptStamp(30, new NodeId(300));
    obj = log.getNext(-1, new CounterVV(as1), 5);
    //should be uncommitted 11-20, nodeId 200, /d1/*
    assert(obj instanceof SingleWriterInval);
    sinv = (SingleWriterInval)obj;
    assert((!sinv.isCommitted()) 
	   && (sinv.getStart() == 10)
	   && (sinv.getEnd() == 20));
    System.out.println("Pass Test 1.3");
        
    //multiple precise writes with gaps
    PreciseInv pi1 = null;
    pi1 = new PreciseInv(new ObjInvalTarget(new ObjId("/d1/obj1"), 
					    10, 20),
			 new AcceptStamp(20, new NodeId(200)));
	    
    PreciseInv pi2 = null;
    pi2 = new PreciseInv(new ObjInvalTarget(new ObjId("/d2/obj2"), 
					    10, 20),
			 new AcceptStamp(30, new NodeId(200)));
	    
    PreciseInv pi3 = null;
    pi3 = new PreciseInv(new ObjInvalTarget(new ObjId("/d1/obj2"), 
					    10, 20),
			 new AcceptStamp(40, new NodeId(200)));
	    
    log.applyInval(pi1);
    if (verbose) System.out.println(log);
	    
    log.applyInval(pi2);
    if (verbose) System.out.println(log);
	    
    log.applyInval(pi3);
    if (verbose) System.out.println(log);
    log.verifyInvariants();
	    
    as1 = new AcceptStamp[3];
    as1[0] = new AcceptStamp(1, log.getMyNodeId());
    as1[1] = new AcceptStamp(10, new NodeId(200));
    as1[2] = new AcceptStamp(30, new NodeId(300));
    obj = log.getNext(-1, new CounterVV(as1), 5);
    //should be [200]:11-19 /d1/*
    assert(obj instanceof SingleWriterInval);
    sinv = (SingleWriterInval)obj;
    assert((!sinv.isCommitted()) 
	   && (sinv.getStart()==10)
	   && (sinv.getEnd() == 19));
		   
    as1 = new AcceptStamp[3];
    as1[0] = new AcceptStamp(1, log.getMyNodeId());
    as1[1] = new AcceptStamp(19, new NodeId(200));
    as1[2] = new AcceptStamp(30, new NodeId(300));
    obj = log.getNext(-1, new CounterVV(as1), 5);
    //should be [200]:20 /d1/obj1
    assert(obj instanceof SingleWriterInval);
    sinv = (SingleWriterInval)obj;
    assert((!sinv.isCommitted()) 
	   && (sinv.getStart()==20)
	   && (sinv.getEnd() ==20));

    as1 = new AcceptStamp[3];
    as1[0] = new AcceptStamp(1, log.getMyNodeId());
    as1[1] = new AcceptStamp(30, new NodeId(200));
    as1[2] = new AcceptStamp(30, new NodeId(300));
    obj = log.getNext(-1, new CounterVV(as1), 5);
    //should be [200]:40 /d1/obj2

    assert(obj instanceof SingleWriterInval);
    sinv = (SingleWriterInval)obj;
    assert((!sinv.isCommitted()) 
	   && (sinv.getStart()== 40)
	   && (sinv.getEnd() == 40));

    assert(log.getCurrentVV()
	   .includes(new AcceptStamp( 40, new NodeId(200))));
    System.out.println("Pass Test 1.5");
    //current state:
    //[200] <11-19 /d1/*> <20 /d1/obj1> <21-29 /d1/*:/d2/*> 
    //<30 /d2/obj2> <31-39 null> <40 /d1/obj2>
	    
    //multiple precise writes by multiple writers
    pi1 = new PreciseInv(new ObjInvalTarget(new ObjId("/d1/obj1"), 
					    10, 20),
			 new AcceptStamp(40, new NodeId(300)));
	    
    log.applyInval(pi1);
    if (verbose) System.out.println(log);
	    
    log.verifyInvariants();
    //[300] ...<21-30 /d1/*:/d2/*> <31-39, null> <40 /d1/obj1>
       
    as1 = new AcceptStamp[3];
    as1[0] = new AcceptStamp(1, log.getMyNodeId());
    as1[1] = new AcceptStamp(40, new NodeId(200));
    as1[2] = new AcceptStamp(30, new NodeId(300));
    obj = log.getNext(-1, new CounterVV(as1), 5);
    //should be [300]:40 [/d1/obj1]
	    
    assert(obj instanceof SingleWriterInval);
    sinv = (SingleWriterInval)obj;
    assert((!sinv.isCommitted()) 
	   && (sinv.getStart()==40)
	   && (sinv.getEnd() ==40)
	   && sinv.getNodeId().equals(new NodeId(300)));
    //assert nodeid and interestset
    System.out.println("Pass Test 1.6");
	    
    //----------------------------------------------------------------
    // Test UnbindMsg
    bi = new BoundInval(new ObjId("/d1/bound2"),
			10,
			body.getLength(),
			new AcceptStamp(50, new NodeId(200)),
			body, Long.MAX_VALUE);
    log.applyInval(bi);//...[200] <41-49 null> <50 /d1/bound2>
    as1 = new AcceptStamp[3];
    as1[0] = new AcceptStamp(1, log.getMyNodeId());
    as1[1] = new AcceptStamp(49, new NodeId(200));
    as1[2] = new AcceptStamp(40, new NodeId(300));
    obj = log.getNext(-1, new CounterVV(as1), 5);
    //should be [200]:50 [/d1/bound2]
    assert(obj instanceof BoundInval);
    bi = (BoundInval)obj;
    assert((!bi.isCommitted())
	   && (bi.getAcceptStamp().getLocalClock()==50));
	    
    ubm = new UnbindMsg(new ObjInvalTarget(new ObjId("/d1/bound2"), 
					   10, 5), 
			new AcceptStamp(50, new NodeId(200)));
	    
    log.applyUnbind(ubm);
    as1 = new AcceptStamp[3];
    as1[0] = new AcceptStamp(1, log.getMyNodeId());
    as1[1] = new AcceptStamp(49, new NodeId(200));
    as1[2] = new AcceptStamp(40, new NodeId(300));
    obj = log.getNext(2, new CounterVV(as1), 5);
    //should be [200]:50 [/d1/bound2] unbinded
    assert(obj instanceof GeneralInv);
    assert(!((GeneralInv)(obj)).isBound());
	    
    obj = log.getNext(-1, new CounterVV(as1), 5);//should be ubm
    assert(obj instanceof UnbindMsg);
    assert(((UnbindMsg)obj).getInvalTarget()
	   .equals(new ObjInvalTarget(new ObjId("/d1/bound2"), 
				      10, 5)));    
	    
    ubm = new UnbindMsg(new ObjInvalTarget(new ObjId("/d1/bound1"), 
					   10, 5), 
			new AcceptStamp(0, log.getMyNodeId()));
    log.applyUnbind(ubm);
	    
    obj = log.getNext(0, new CounterVV(as1), 5);
    //should be ubm(/d1/bound1)
    assert(obj instanceof UnbindMsg);
    assert(((UnbindMsg)obj).getInvalTarget()
	   .equals(new ObjInvalTarget(new ObjId("/d1/bound1"), 
				      10, 5)));
    
    ubm = new UnbindMsg(new ObjInvalTarget(new ObjId("/d2/unbound1"), 
					   10, 5), 
			new AcceptStamp(1, log.getMyNodeId()));
    log.applyUnbind(ubm);
    obj = log.getNext(1, new CounterVV(as1), 5);
    //should not be ubm(/d1/bound1)
    //becuase the unbind msg is ignored 
    //as no matching bound invalidate exists
    assert(!(obj instanceof UnbindMsg));
                
    if (verbose) System.out.println("After Unbind");
    if (verbose) System.out.println(log);
    log.verifyInvariants();
	    
    as1 = new AcceptStamp[3];
    as1[0] = new AcceptStamp(-1, log.getMyNodeId());
    as1[1] = new AcceptStamp(50, new NodeId(200));
    as1[2] = new AcceptStamp(40, new NodeId(300));
    obj = log.getNext(1, new CounterVV(as1), 5);
    //should be [myid]:0 [/d1/bound1] unbinded
    assert(obj instanceof GeneralInv);
    assert(!((GeneralInv) obj).isBound());
    assert(((GeneralInv) obj).getInvalTarget()
	   .equals(new ObjInvalTarget(new ObjId("/d1/bound1"), 
				      10, 5)));
    as1 = new AcceptStamp[3];
    as1[0] = new AcceptStamp(0, log.getMyNodeId());
    as1[1] = new AcceptStamp(50, new NodeId(200));
    as1[2] = new AcceptStamp(40, new NodeId(300));
    obj = log.getNext(2, new CounterVV(as1), 5);
    //should be [myid]:1 [/d1/unbound1] unbinded
    assert(obj instanceof GeneralInv);
    assert(!((GeneralInv) obj).isBound());
    assert(((GeneralInv) obj).isPrecise());
    assert(((GeneralInv) obj).getInvalTarget()
	   .equals(new ObjInvalTarget(new ObjId("/d2/unbound1"), 
				      10, 5)));
    System.out.println("Pass Test 1.7");
	
    //-------------------------------------------------------------------
    //Test InvalIterator
    //-------------------------------------------------------------------
    ii1 = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget(dir1),
				       new AcceptStamp( 41, 
							new NodeId(300)),
				       new AcceptStamp( 50,
							new NodeId(300)));
    log.applyInval(ii1);
	    
    ii1 = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget(dir2),
				       new AcceptStamp( 60, 
							new NodeId(300)),
				       new AcceptStamp( 70,
							new NodeId(300)));
    log.applyInval(ii1);
		
    ii1 = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget(dir1),
				       new AcceptStamp( 51, 
							new NodeId(200)),
				       new AcceptStamp( 60, 
							new NodeId(200)));
    log.applyInval(ii1);
		
    bi = new BoundInval(new ObjId("/d1/bound61"),
			10,
			body.getLength(),
			new AcceptStamp(61, new NodeId(200)),
			body, 
			Long.MAX_VALUE);
    log.applyInval(bi);//...[200]<61 /d1/bound61>

    ii1 = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget(dir1),
				       new AcceptStamp( 62, 
							new NodeId(200)),
				       new AcceptStamp( 70, 
							new NodeId(200)));
    log.applyInval(ii1);
    if (verbose){
      System.out.println("Current States");
      System.out.println(log);
      System.out.println("Testing InvalIterator........");
    }

    long ubc = 2;
    VV startVV = new CounterVV();
    obj=null;
    dir1=new String[1];
    dir1[0] = new String("/d2/*");
    
    InvalIterator invalIter = new InvalIterator(startVV,
						SubscriptionSet.makeSubscriptionSet(dir1),
						ubc,
						20,
						0,
						log);
    Vector v = new Vector();
    while ( true ){
      obj = invalIter.getNext(1000);
      if(vverbose){
	System.out.println("Iterator.getNext: " + obj);
      }
      if (obj instanceof GeneralInv){
	v.add(obj);
	if (verbose) {
	  System.out.println("@GeneralInv: "+(GeneralInv)obj);
	}	   
      }else if (obj instanceof UnbindMsg){
	if (verbose) {
	  System.out.println("@unbindMsg:"+(UnbindMsg)obj);
	}
	v.add(obj);
      } else {
	assert(obj == null);
	if (verbose) {
	  System.out.println("InvalIterator getNext() timeout");
	}
	break;
      }
    }
    assert(obj == null);
    //only when timeout happened, should it come out the while loop
    obj = v.get(4); //should be 300:10-20 200:10-20
    assert(obj instanceof GeneralInv);
    ginv = (GeneralInv)obj;
        
    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(10, new NodeId(200));
    as1[1] = new AcceptStamp(10, new NodeId(300));
    //System.out.println(log);
    
    assert(ginv.getStartVV().equals(new AcceptVV(as1)))
      :ginv.getStartVV().toString()+"expected: "+as1.toString();
    
    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(20, new NodeId(200));
    as1[1] = new AcceptStamp(20, new NodeId(300));
    assert(ginv.getEndVV().equals(new AcceptVV(as1)));
	   
    obj = v.get(8); //should be 300:40-50 200:40-60
    ginv = (GeneralInv)obj;
    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(40, new NodeId(200));
    as1[1] = new AcceptStamp(40, new NodeId(300));
    assert(ginv.getStartVV().equals(new AcceptVV(as1))):
      ginv.toString() + " expected: " + new AcceptVV(as1).toString();
	    
    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(60, new NodeId(200));
    as1[1] = new AcceptStamp(50, new NodeId(300));
    assert(ginv.getEndVV().equalsIgnoreNegatives(new AcceptVV(as1))):
      ginv.toString() + " expected: " + new AcceptVV(as1).toString();
   
    doTestParallelInserters(log);
    doTestParallelIterators(log);
    doTestIteratorInserter(log);
    }catch(Exception e){
      e.printStackTrace();
      assert false:e.toString();
    }
  }

  //------------------------------------------------------------------
  // Module Test for Parallel Inserters 
  //------------------------------------------------------------------
  private void doTestParallelInserters(UpdateLog log){
    System.out.println("Testing multi writers");
    try{
      Inserter i1 = new Inserter(log, 1);
      Inserter i2 = new Inserter(log, 2);
      i1.start();
      i2.start();
      i1.join();
      i2.join();
      log.verifyInvariants();
      if (verbose) System.out.println("after parallel"+log);
    }catch(Exception e){
      assert false;
    }
  }



  //------------------------------------------------------------------
  // Module Test for Parallel Iterators 
  // assume UpdateLog started with state after doTestParallelInserters
  //------------------------------------------------------------------
  private void doTestParallelIterators(UpdateLog log){
    CounterVV startVV;
    SubscriptionSet ss;
    long ubc;
    try{
      String[] dir=new String[2];
    dir[0] = "/d1/*";
    dir[1] = "/d2/*";
	    
    String[] dir1=new String[1];
    dir1[0] = "/d1/*";
	    
    String[] dir2=new String[1];
    dir2[0] = "/d2/*";
	    
    AcceptVV acceptVV1 = null;
	
    AcceptStamp[] as1 = null;
    CounterVV counterVV1 = null;
	

    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(200, new NodeId(190));
    as1[1] = new AcceptStamp(300, new NodeId(200));
    acceptVV1 = new AcceptVV(as1);
    counterVV1 = new CounterVV(acceptVV1);
	
    startVV = new CounterVV();
    ss = SubscriptionSet.makeSubscriptionSet(dir);
    ubc = -1;
	    
	    
    InvalIteratorWorker iworker1, iworker2;
	    
    iworker1 = new InvalIteratorWorker(log, 1, startVV,
				       ss,
				       ubc,
				       50); 
	    
    startVV = counterVV1;
    ss = SubscriptionSet.makeSubscriptionSet(dir1);
    ubc = 0;
	    
    iworker2 = new InvalIteratorWorker(log, 2, startVV,
				       ss,
				       ubc,
				       50);
	    
    iworker1.start();
    iworker2.start();
	    
    iworker1.join();
    iworker2.join();
	    
    log.verifyInvariants();
    //log.close();

    }catch(Exception e){
      assert false;
    }
  }
  //------------------------------------------------------------------
  // Iterators || Inserters
  //
  // note, assume state started from doTestParallelIterators
  //------------------------------------------------------------------
  private void doTestIteratorInserter(UpdateLog log){
    CounterVV startVV;
    SubscriptionSet ss;
    long ubc;
	    
    String[] dir=new String[2];
    dir[0] = "/d1/*";
    dir[1] = "/d2/*";
	    
    String[] dir1=new String[1];
    dir1[0] = "/d1/*";
	    
    String[] dir2=new String[1];
    dir2[0] = "/d2/*";
	    
    AcceptVV acceptVV1 = null;
	    
    AcceptStamp[] as1 = null;
    CounterVV counterVV1 = null;
	    
    try{
      as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(200, new NodeId(200));
    as1[1] = new AcceptStamp(300, new NodeId(300));
    acceptVV1 = new AcceptVV(as1);
    counterVV1 = new CounterVV(acceptVV1);
	
    startVV = new CounterVV();
    ss = SubscriptionSet.makeSubscriptionSet(dir);
    ubc = -1;
	    
	    
    InvalIteratorWorker iworker1, iworker2;
	    
    iworker1 = new InvalIteratorWorker(log, 1, startVV,
				       ss,
				       ubc,
				       50); 
	    
    startVV = counterVV1;
    ss = SubscriptionSet.makeSubscriptionSet(dir2);
    ubc = 0;
		
    iworker2 = new InvalIteratorWorker(log, 2, startVV,
				       ss,
				       ubc,
				       50);
	  
    Inserter i1 = new Inserter(log, 1);
	    
    //iworker1.start();
    iworker2.start();
    i1.start();
	    
    //iworker1.join();
    iworker2.join();
    i1.join();
	    
	  
    log.verifyInvariants();
    if (verbose) System.out.println(log);
    if (verbose) System.out.println("After currently running iterators:" 
				    +log);
    }catch(Exception e){
      assert false;
    }
  }
  


  //-------------------------------------------------------------
  // Test order error
  //-------------------------------------------------------------
  public void testOE()
    throws Exception{
    if(vverbose){
      Env.dprintln(vverbose, "OE Test start ...");
    }
   
    UpdateLog log = makeEmptyLog("test" + File.separatorChar + "UpdateLogUnit_testOE_log",
        new NodeId(9));
    LocalWriter lw = new LocalWriter(log);
    lw.start();
    try{
      Thread.sleep(1000);
    } catch (Exception e){
      //ignore;
    }
    LocalInvApplier li = new LocalInvApplier(log);
    li.start();
    lw.join();
    li.join();
    if(vverbose){
      Env.dprintln(vverbose, "OE Test succeed");
    }
    //log.close();
  }


  //------------------------------------------------------------------
  // test the hopCounts for BoundInval
  //------------------------------------------------------------------
  public void testHops() {
    
    UpdateLog log = makeEmptyLog("test" + File.separatorChar + "UpdateLogUnit_testHops_log",
        new NodeId(9));

    Env.tbd("add tests to make sure that the BoundInval is eventually unbound");
    if(vverbose){
      System.out.println("Trying to insert general Inval");
    }
    doApplyInv("/1",//objId
	       10,//nodeId
	       1,//localStamp
	       0,//offset
	       2,//len
	       1,//realStamp
	       false,
	       log);//embargoed
    if(vverbose){
      System.out.println("Trying to apply boundInval with hop = Long.MAX_VALUE");
    }
    doApplyBoundInv("/2",//objId
			  10,//nodeId
			  2,//localStamp
			  0,//offset
			  2,//len
			  2,//realStamp
			  (byte) 65, // val
			  Long.MAX_VALUE, // max bound hops
		    false,
		    log);//embargoed

    if(vverbose){
      System.out.println("Trying to apply boundInval with hop = 5");
    }
    doApplyBoundInv("/2",//objId
			  10,//nodeId
			  2,//localStamp
			  0,//offset
			  2,//len
			  2,//realStamp
			  (byte) 65, // val
			  5, // max bound hops
		    false,
		    log);//embargoed


    if(vverbose){
      System.out.println("Trying to apply boundInval with hop = 0");
    }
    doApplyBoundInv("/3",//objId
			  10,//nodeId
			  3,//localStamp
			  0,//offset
			  2,//len
			  3,//realStamp
			  (byte) 65, // val
			  0, // max bound hops
		    false,
		    log);//embargoed
    //log.close();
  }

  
  public void testIterator()
  throws Exception{
    //case 1: 1 log, 1 iter, write one, get one, write two, get two
    UpdateLog log = makeEmptyLog("test" + File.separatorChar + "UpdateLogUnit_testIterator_log",
        new NodeId(9));
    InMemLogIterator iter1 = log.makeInMemLogIterator(AcceptVV.makeVVAllNegatives());
    
    assert !iter1.hasNext();
    assert iter1.next() == null;
    
    PreciseInv pi1 = new PreciseInv(new ObjInvalTarget(new ObjId("/d1/obj1"), 
                                    10, 
                                    20),
                                    new AcceptStamp(0, new NodeId(200)));
    
    log.applyInval(pi1);
    assert iter1.hasNext();
    SingleWriterInval inv = iter1.next();
    assert inv.equals(pi1);
    assert !iter1.hasNext();
    
    PreciseInv pi2 = new PreciseInv(new ObjInvalTarget(new ObjId("/d1/obj1"), 
                                    10, 
                                    20),
                                    new AcceptStamp(1, new NodeId(200)));
    log.applyInval(pi2);
    assert iter1.hasNext();
    inv = iter1.next();
    assert inv.equals(pi2);
    assert !iter1.hasNext();
    
    //case 2: 2 log, 1 iter, write 1 pi, 1 ii to the second log, get 2
    
    AcceptStamp[] as = new AcceptStamp[1];
    as[0] = new AcceptStamp(2, new NodeId(200));
    InMemLogIterator iter2 = log.makeInMemLogIterator(new AcceptVV(as));
    InMemLogIterator iter3 = log.makeInMemLogIterator(new AcceptVV(as));
   
    
    PreciseInv pi3 = new PreciseInv(new ObjInvalTarget(new ObjId("/300/obj1"), 
        10, 
        20),
        new AcceptStamp(0, new NodeId(300)));
    
    SingleWriterImpreciseInv ii4 = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
        new AcceptStamp( 1, new NodeId(300)),
        new AcceptStamp( 10, new NodeId(300)) );

    log.applyInval(pi3);
    log.applyInval(ii4);
    assert iter1.next().equals(pi3);
    assert iter1.next().equals(ii4);
    assert iter1.next() == null;
    
    //now iter1 points to the end
    //    iter3 points to the start
    //make iter2 points to the first item
    
    assert iter2.next().equals(pi3);
    //case 3: log: 
    //        
    //        300: 0  1-10
    //    (1) merge: 300: 0-3
    //         
    //          0 1-3 4-10
    //          
    //          iter3 -> 0   next= 0
    //          iter2 -> 1    next = 1-3
    //          iter1 -> null    next = null
    //
    ii4 = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
        new AcceptStamp( 0, new NodeId(300)),
        new AcceptStamp( 3, new NodeId(300)) );

    log.applyInval(ii4);
    SingleWriterImpreciseInv exptII = null;
    exptII = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
        new AcceptStamp( 1, new NodeId(300)),
        new AcceptStamp( 3, new NodeId(300)) );
    
    assert iter3.next().equals(pi3);
    SingleWriterInval iter2Next = iter2.next();
    assert iter2Next.equals(exptII): iter2Next + " exptected: " + exptII;
    
    assert iter1.next() == null;
    
    //    (2) merge: 300: 8-20
    //
    //               0 1-3 4-7 8-10 11-20
    //
    //          iter3 -> 1   next= 1-3
    //          iter2 -> 4    next = 4-7
    //          iter1 -> null    next = 11-20
    //
    
    ii4 = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
        new AcceptStamp( 8, new NodeId(300)),
        new AcceptStamp( 20, new NodeId(300)) );

    log.applyInval(ii4);
    
    exptII = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
        new AcceptStamp( 1, new NodeId(300)),
        new AcceptStamp( 3, new NodeId(300)) );
    
    assert iter3.next().equals(exptII);
    exptII = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
        new AcceptStamp( 4, new NodeId(300)),
        new AcceptStamp( 7, new NodeId(300)) );
    
    iter2Next = iter2.next();
    assert iter2Next.equals(exptII): iter2Next + " exptected: " + exptII;
    
    exptII = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
        new AcceptStamp( 11, new NodeId(300)),
        new AcceptStamp( 20, new NodeId(300)) );
    
    SingleWriterInval iter1Next = iter1.next();
    assert iter1Next.equals(exptII): iter1Next + " exptected: " + exptII;
    assert iter1.next() == null;
    

    exptII = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
        new AcceptStamp( 8, new NodeId(300)),
        new AcceptStamp( 10, new NodeId(300)) );
    //      move iter2 one step to point to 11
    iter2.next().equals(exptII);
    
    //    (3) merge: 300: 18
    //           0 1-3 4-7 8-10 11-17 18 19-20
    //
    //          iter3 -> 4   next= 4-7 
    //          iter2 -> 11    next = 11-17
    //          iter1 -> null    next = null
    //
    ii4 = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
        new AcceptStamp( 18, new NodeId(300)),
        new AcceptStamp( 18, new NodeId(300)) );

    log.applyInval(ii4);
    
    exptII = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
        new AcceptStamp( 4, new NodeId(300)),
        new AcceptStamp( 7, new NodeId(300)) );
    
    assert iter3.next().equals(exptII);
    exptII = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
        new AcceptStamp( 11, new NodeId(300)),
        new AcceptStamp( 17, new NodeId(300)) );
    
    iter2Next = iter2.next();
    assert iter2Next.equals(exptII): iter2Next + " exptected: " + exptII;
    
    
    assert iter1.next() == null;
    
    //    (4) merge: 300: 22
    //          iter2 -> 18    next = 18
    //          iter1 -> null    next = 22
    ii4 = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
        new AcceptStamp( 22, new NodeId(300)),
        new AcceptStamp( 22, new NodeId(300)) );

    log.applyInval(ii4);
    
    
    exptII = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
        new AcceptStamp( 18, new NodeId(300)),
        new AcceptStamp( 18, new NodeId(300)) );
    
    iter2Next = iter2.next();
    assert iter2Next.equals(exptII): iter2Next + " exptected: " + exptII;
    
    exptII = new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
        new AcceptStamp( 22, new NodeId(300)),
        new AcceptStamp( 22, new NodeId(300)) );
    
    assert iter1.next().equals(exptII);
  }
  //------------------------------------------------------------------
  // test the hopCounts for BoundInval
  //------------------------------------------------------------------
  private static UpdateLog makeEmptyLog(String dbPath, NodeId nid) {
    
    File dbDir = new File(dbPath);
    
    try{
      
      File[] dbFiles = dbDir.listFiles();
      
      if (dbFiles != null){
	for (int i = 0; i < dbFiles.length; i ++){
	  dbFiles[i].delete();
	}
      }
      
    } catch (SecurityException se){
      assert false; //should never be here.
    }
    UpdateLog log = null;
    try{
      log = new UpdateLog(dbPath, nid, false);
    }catch(Exception e){
      e.printStackTrace();
      assert false;
    }
    return log;
  }
  
  


  //----------------------------------------------------------------------
  // testSetBytes
  //----------------------------------------------------------------------
  private static void
    doSetBytes(byte b[], int len, byte value){
    int ii;
    for(ii = 0; ii < len; ii++){
      b[ii] = value;
    }
  }

  //----------------------------------------------------------------------
  // do a write to log
  //----------------------------------------------------------------------
  protected static void doWrite(String obj,
		       long offset,
		       long len,
		       long real,
		       byte val,
		       boolean bound,
		       long targetOE,
		       boolean embargoed,
		       UpdateLog log){
    ObjId id = new ObjId(obj);
    AcceptStamp realAS = new AcceptStamp(real, log.getMyNodeId());
    
    byte b[] = new byte[(int)len];
    doSetBytes(b, (int)len, val);
    ImmutableBytes ib = new ImmutableBytes(b);
    
    if(verbose){
      Env.dprintln(verbose, "about to write: " + id);
    }
    log.write(id,
	      offset,
	      len,
	      Core.DEFAULT_PRIORITY,
	      realAS,
	      ib,
	      bound,
	      targetOE,
	      embargoed);
    if(verbose){
      Env.dprintln(verbose, "finish write: " + id);
    }
  }

  //----------------------------------------------------------------------
  // apply a boundinval to log
  //----------------------------------------------------------------------
  protected static void doApplyBoundInv(String obj,
			      long node,
			      long localStamp,
			      long offset,
			      long len,
			      long real,
			      byte val,
			      long maxBoundHop,
			      boolean embargoed,
			      UpdateLog log){
    ObjId id = new ObjId(obj);
    ObjInvalTarget oit = new ObjInvalTarget(id, offset, len);
    NodeId nodeId = new NodeId(node);
    AcceptStamp stamp = new AcceptStamp(localStamp, nodeId);
    AcceptStamp rStamp = new AcceptStamp(real, nodeId);
    int ii;
    byte b[] = new byte[(int)len];
    doSetBytes(b, (int)len, val);
    ImmutableBytes ib = new ImmutableBytes(b);
    BoundInval bi = new BoundInval(oit, stamp, ib, Core.DEFAULT_PRIORITY,
				   rStamp, maxBoundHop, embargoed);
    try{
      log.applyInval(bi);
    }catch(Exception e){
      assert false;
    }
    
    if(verbose){
      Env.dprintln(verbose, "finish applying inv: " + bi);
    }
  }

  //----------------------------------------------------------------------
  // apply an inval to log
  //----------------------------------------------------------------------
  protected static void doApplyInv(String obj,
			 long node,
			 long localStamp,
			 long offset,
			 long len,
			 long real,
			 boolean embargoed,
			 UpdateLog log){
    ObjId id = new ObjId(obj);
    ObjInvalTarget oit = new ObjInvalTarget(id, offset, len);
    NodeId nodeId = new NodeId(node);
    AcceptStamp stamp = new AcceptStamp(localStamp, nodeId);
    AcceptStamp rStamp = new AcceptStamp(real, nodeId);
    
    PreciseInv bi = new PreciseInv(oit, stamp, rStamp,
				   embargoed);
    
    
    try{
      log.applyInval(bi);
    }catch(Exception e){
      assert false;
    }
    if (verbose){
      Env.dprintln(verbose, "finish applying inv: " + bi);
    }
  }

  private static void makePractiConfig(){
    Config.createEmptyConfig();
    long NODE_0_ID = 9;
    long NODE_1_ID = 10;
    long NODE_2_ID = 11;
    long NODE_3_ID = 12;
    
    String NODE_0_IP = "localhost";
    String NODE_1_IP = "localhost";
    String NODE_2_IP = "localhost";
    String NODE_3_IP = "localhost";
    
    Config.addOneNodeConfig(new NodeId(NODE_0_ID),
			    NODE_0_IP,
			    9921,
			    9922,
			    9923,
			    9924,
			    9925,
			    "test" + File.separatorChar + "local-" + 
			    NODE_0_ID + ".db",
			    "/*",
			    -1L,
			    NODE_0_IP,
			    9926,
			    9927,
			    -1,
			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
 
    Config.addOneNodeConfig(new NodeId(NODE_1_ID),
			    NODE_1_IP,
			    9821,
			    9822,
			    9823,
			    9824,
			    9825,
			    "test" + File.separatorChar + "local-" + 
			    NODE_1_ID+".db",
			    "/*",
			    -1L,
			    NODE_1_IP,
			    9826,
			    9827,
			    -1,
			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
  
    Config.addOneNodeConfig(new NodeId(NODE_2_ID),
			    NODE_2_IP,
			    9721,
			    9722,
			    9723,
			    9724,
			    9725,
			    "test" + File.separatorChar + "local-" + 
			    NODE_2_ID+".db",
			    "/*",
			    -1L,
			    NODE_2_IP,
			    9726,
			    9727,
			    -1,
			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);

    Config.addOneNodeConfig(new NodeId(NODE_3_ID),
			    NODE_3_IP,
			    9621,
			    9622,
			    9623,
			    9624,
			    9625,
			    "test" + File.separatorChar + "local-" + 
			    NODE_3_ID+".db",
			    "/*",
			    -1L,
			    NODE_3_IP,
			    9626,
			    9627,
			    -1,
			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
    
  }
  

  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(UpdateLogUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * usage: java <classname> [-verbose] [-vverbose] [testName]*
   * 
   *   If verbose or vverbose are included, print info to screen
   *
   *   If [testName]* are included, then run test called "test[testName]"
   *   for each such [testName]. E.g., "java UpdateLogUnit foo" runs
   *   UpdateLogUnit.testfoo() as a TestCase.
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "UpdateLogUnit";
    System.err.print(name + " self test begins...");
    Env.verifyAssertEnabled();
    //
    // Default: run all tests
    //
    TestSuite ste = new TestSuite();
    Test test;
    boolean doAllTests = true;

    if(s.length > 0){
      int ii;
      for(ii = 0; ii < s.length; ii++){
	if(s[ii].equals("-verbose")){
	  verbose = true;
	}
	else if(s[ii].equals("-vverbose")){
	  verbose = true;
	}
	else{
	  doAllTests = false;
	  ste.addTest(new UpdateLogUnit("test" + s[ii]));
	}
        
      }
    }
    if(doAllTests){
      test = suite();
    }
    else{
      test = ste;
    }
    TestRunner tr = new TestRunner();
    tr.doRun(test);
    System.err.println(name + " self test succeeds");
    System.exit(0); 
  }

}

 /** 
 *  Thread to insert a bunch of writes
 
 **/ 
class Inserter extends Thread{
  private UpdateLog ul;
  private static final boolean dbg = false;
  private final int myno;//thread id
  public Inserter(UpdateLog log, int no)
    throws Exception{
    ul = log;
    myno = no;
    if(dbg) System.out.println("Inserter " + no);
  }
  public void run(){
    UnbindMsg ubm = null; 
	
    ImpreciseInv ii2 = null;
	
    String[] dir=new String[2];
    dir[0] = new String("/d1/*");
    dir[1] = new String("/d2/*");
	
    String[] dir1=new String[1];
    dir1[0] = new String("/d1/*");
	
    String[] dir2=new String[1];
    dir2[0] = new String("/d2/*");

    AcceptStamp[] as1 = null;
    AcceptStamp[] as2 = null;
	
    for(int i=0; i<5; i++){
      try{
        sleep(100);
		
        as2 = new AcceptStamp[2];
        as2[0] = new AcceptStamp(100*(i+1)+50+myno, new NodeId(190));
        as2[1] = new AcceptStamp(100*(i+1) +50 +myno, new NodeId(200));
		
        as1 = new AcceptStamp[2];
        as1[0] = new AcceptStamp(100*(i+1)+myno, new NodeId(190));
        as1[1] = new AcceptStamp(100*(i+1) + myno, new NodeId(200));
		
        ii2 = new ImpreciseInv(HierInvalTarget.makeHierInvalTarget(dir2),
                               new AcceptVV(as1),
                               new AcceptVV(as2));
        ul.applyInval(ii2); 
		
      } catch (Exception e){
        System.out.println(e);
        e.printStackTrace();
      }
    }
  }	
}


//----------------------------------------------------------------------------
// Thread to insert a bunch of writes
//----------------------------------------------------------------------------
class LocalWriter extends Thread{
  private UpdateLog ul;
  
  public LocalWriter(UpdateLog log)
    throws Exception{
    ul = log;
  }
  public void run(){
    	
    for(int i=0; i<5; i++){
      try{
        sleep(100);
        UpdateLogUnit.doWrite(""+i,//objId
		0,//offset
		2,//len
		i,//realStamp
		(byte)i,//val to write
		true,//bound
		3,//targetOE
		false,
		ul);//embargoed
		
      } catch (Exception e){
        System.out.println(e);
        e.printStackTrace();
      }
    }
  }	
}

//----------------------------------------------------------------------------
// Thread to insert a bunch of writes
//----------------------------------------------------------------------------
class LocalInvApplier extends Thread{
  private UpdateLog ul;
  
  public LocalInvApplier(UpdateLog log)
    throws Exception{
    ul = log;
  }
  public void run(){
    	
    for(int i=0; i<2; i++){
      try{
        sleep(100);
        UpdateLogUnit.doApplyInv(""+i,//objId
                        10,//nodeId
                        i,//localStamp
                        0,//offset
                        2,//len
                        i,//realStamp
		   false,
		   ul);//embargoed
        UpdateLogUnit.doApplyInv(""+i,//objId
                        11,//nodeId
                        i,//localStamp
                        0,//offset
                        2,//len
                        i,//realStamp
		   false,
		   ul);//embargoed
        UpdateLogUnit.doApplyInv(""+i,//objId
                        12,//nodeId
                        i,//localStamp
                        0,//offset
                        2,//len
                        i,//realStamp
		   false,
		   ul);//embargoed
      } catch (Exception e){
        System.out.println(e);
        e.printStackTrace();
      }
    }
  }	
}

//-------------------------------------------------------------------------
// Thread to run an invalIterator which outputs the inval till end is meet 
//-------------------------------------------------------------------------
class InvalIteratorWorker extends Thread{
  private UpdateLog ul;
  private final int myno;
    
  private static boolean dbg = false;
  VV startVV;
  SubscriptionSet is;
  long ubc;
  long end;
 
  public InvalIteratorWorker(UpdateLog log, 
                             int no, 
                             VV startVV,
                             SubscriptionSet is,
                             long ubc,
                             long end)
    throws Exception{
    this.ul = log;
    this.myno = no;
    this.startVV = startVV;
    this.is = is;
    this.ubc = ubc;
    this.end = end;
    if (dbg) System.out.println("InvalIteratorWorker " 
				+ no);
	
  }
    
  public void run(){
    Object obj;
    InvalIterator invalIter = new InvalIterator(startVV,
                                                is,
                                                ubc,
                                                20,
                                                0,
                                                ul);
    while ( true ){
      try{
        obj = invalIter.getNext(1000);
        if (obj instanceof GeneralInv){
          if(dbg) 
            System.out.println("Worker " 
                               + myno +":"
                               +(GeneralInv)obj);
		    
        }else if (obj instanceof UnbindMsg){
          if (dbg) 
            System.out.println("Worker " 
                               + myno +":"
                               +(UnbindMsg)obj);
        } else { 
          assert(obj == null);
          if (dbg) 
            System.out.println("Worker " 
                               + myno +":" + "NULL");
          break;
        }
      }catch(Exception e){
        e.printStackTrace();
      }
    }
  }
}
