package code;

 /** 
 *  Used to compare update priority ranges 
 **/ 
import java.util.Comparator;

public class UpdatePriorityComparator implements Comparator{
 /** 
 *  Return -1 if o1 is greater than o2, 1 if o1 is less than o2, and 
 *  0 otherwise. 
 *  NOTE: This behavior is opposite to that described by 
 *        Comparator.compare(), but we implement this method this way 
 *        to trick the TreeMap data structure into giving us a priority 
 *        queue sorted in descending order. 
 **/ 
  public int
  compare(Object o1, Object o2){
    UpdateRangeList url1 = null;
    UpdateRangeList url2 = null;
    double p1 = 0;
    double p2 = 0;
    int retVal = 0;

    url1 = (UpdateRangeList)o1;
    url2 = (UpdateRangeList)o2;
    p1 = url1.getPriority();
    p2 = url2.getPriority();
    if(p1 > p2){
      retVal = -1;
    }else if(p1 < p2){
      retVal = 1;
    }else{
      retVal = (-1 * url1.getOID().compareTo(url2.getOID()));
    }
    return(retVal);
  }
}

//---------------------------------------------------------------------------
/* $Log: UpdatePriorityComparator.java,v $
/* Revision 1.5  2005/03/08 23:18:17  nayate
/* Changed UpdatePriorityComparator to allow us to sort in descending order of priority
/*
/* Revision 1.4  2005/03/08 22:58:53  nayate
/* Changed priorities to doubles from ints
/*
/* Revision 1.3  2004/04/27 07:59:05  lgao
/* Initial implementation for UpdatePriorityQueue
/*
/* Revision 1.2  2004/04/15 20:04:25  nayate
/* New Makefile; added provision to allow CVS to append file modification
/* logs to files.
/* */
//---------------------------------------------------------------------------
