package code;

/* UpdatePriorityQueueWatcher
 * 
 * transfers bodies from updatePriorityQueue to specified outgoing body queue
 * when required. transfer will be blocked until an obj is available in upq
 * 
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */

import java.util.*;
import java.lang.*;

public class UpdatePriorityQueueWatcher extends Thread {

  private UpdatePriorityQueue upq;
  private OutgoingBodyQueue obq;
  private int transfer;


  private boolean dbg = false;

  public UpdatePriorityQueueWatcher(UpdatePriorityQueue upq, OutgoingBodyQueue obq){
    this.upq = upq;
    this.obq = obq;
    this.transfer = 0;
  }
    
  public synchronized void transfer(){
    transfer++;
    notifyAll();
    if( dbg ){
      Env.dprintln(dbg, "UpdatePriorityQueueWatcher: transfer called");
    }
  }

  public void run(){
    while(true) {
      synchronized(this) {
        while(transfer == 0) {
          try{
	    if( dbg ){
	      Env.dprintln(dbg, "UpdatePriorityQueueWatcher: waiting to be asked to transfer");
	    }
            wait();
          }catch(InterruptedException e) {
          }
        }
        assert(transfer > 0);
        transfer--;
      }
      getNext();
    }
  }

  void getNext(){
    if( dbg ){
      Env.dprintln(dbg, "UpdatePriorityQueueWatcher: trying to getNext from upq");
    }
    Object obj = upq.getNext();
    obq.add(obj);
    if( dbg ){
      Env.dprintln(dbg, "UpdatePriorityQueueWatcher: got " + obj + "from upq and added to queue");
    }
  }
}   


//---------------------------------------------------------------------------
/* $Log: UpdatePriorityQueueWatcher.java,v $
/* Revision 1.2  2007/04/02 21:11:39  zjiandan
/* snapshort for sosp2007.
/*
/* Revision 1.1  2006/10/31 21:43:33  nalini
/* added control msgs to body streams
/*
 */
//---------------------------------------------------------------------------