package code;

 /** 
 *  VV: Common class from which all version vectors inherit 
 **/ 
import java.io.Serializable;
import java.util.Collection;

public abstract class VV implements Serializable
{
   public abstract boolean containsNodeId(NodeId n);
	//return true if this contains NodeId n

    public abstract boolean includes(VV vv);
    //return true if this *includes* vv
    //version vector A *includes* version vector B if
    //every {serverId, counterB} in B has a corresponding
    //{serverId, counterA} in A with counterA >= counterB

    public abstract boolean includesAnyPartOf(VV vv);
    //return true if this *includesAnyPartOf* vv

    //that is, if any event that happened before vv could also have
    //happened before this

    //that is, if there exists any server s.t. this.getStampByServer(s)
    //>= vv.getStampByServer(s)

    public abstract boolean isAnyPartGreaterThan(VV vv);
    //return true, only if there exists any server s s.t.
    //   (1)s is a valid component in both this and vv 
    //&& (2)this.getStampByServer(s) > vv.getStampByServer(s)
    // Note. the difference of this method and the above method
    //    is > and >=
    //    and if there's a s exists in "this", but not exist in "vv",
    //           isAnyPartGreaterThan() will not return true
    //       but includesAnyPartOf() will return true

    public abstract long getMaxTimeStamp();
    // of all the <NodeId, TimeStamp> pairs in the version vector,
    // return the largest TimeStamp.

    public abstract long getMinTimeStamp();
    // of all the <NodeId, TimeStamp> pairs in the version vector,
    // return the smallest TimeStamp.

    // Return number of elements in VV
    public abstract int getSize();
  
    public abstract boolean includes(AcceptStamp ts);
    //return true if this has an entry for ts.nodeId and if
    //that entry has at least as high a counter as ts.acceptStamp

    public abstract long getStampByServer(NodeId nodeId)
	throws NoSuchEntryException;
    //return the clock value for the specified server 
    //or throw exception if no server

    public abstract VVIterator getIterator(); // getNext() of this
    // iterator returns a token

    public abstract NodeId getServerByIteratorToken(Object token);
    public abstract long getStampByIteratorToken(Object token);

    public abstract boolean greaterThan(VV vv);
    // return true if this > vv, where A > B if (1) for all {node, stamp}
    // in A, B either does not contain node or has a smaller or equal
    // stamp, and (2) at least one stamp has a lower value than the
    // corresponding value in A.

    public abstract Collection<NodeId> getNodes();
    
    public abstract Object clone();
}

//---------------------------------------------------------------------------
/* $Log: VV.java,v $
/* Revision 1.11  2007/05/30 20:30:19  dahlin
/* Added checkpoint to SubscribeBWUnit. Changed outgoingconnection checkpoint send to not send body by default. Told barrier to close sockets when done with them.
/*
/* Revision 1.10  2004/10/12 20:40:13  zjiandan
/* add a new public method: boolean isAnyPartGreaterThan(VV vv)
/*
/* Revision 1.9  2004/05/10 20:48:19  dahlin
/* Clarified RMI exceptions; full version of (stub) DemandReadWorker
/*
/* Revision 1.8  2004/04/28 01:38:47  nayate
/* Added a "greaterThan" method
/*
/* Revision 1.7  2004/04/26 03:58:03  zjiandan
/* add containsNodeId() method
/*
/* Revision 1.6  2004/04/21 16:07:24  nayate
/* Added new methods
/*
/* Revision 1.5  2004/04/20 18:58:06  nayate
/* Added a new getMaxTimeStamp() method to VV and AcceptVV
/*
/* Revision 1.4  2004/04/16 22:38:58  nayate
/* Finished (but untested) AcceptVV
/*
/* Revision 1.3  2004/04/16 16:05:17  nayate
/* Subset of PreciseInv implemented + removed some compiler errors.
/*
/* Revision 1.2  2004/04/15 20:04:25  nayate
/* New Makefile; added provision to allow CVS to append file modification
/* logs to files.
/* */
//---------------------------------------------------------------------------
