package code;

 /** 
 *  Used to iterate through version vectors 
 **/ 
import java.util.Enumeration;

// Used for testing
import java.util.Vector;

public final class VVIterator
{
    private Enumeration<NodeId> nodeIds;

 /** 
 *  Constructor 
 **/ 
    public VVIterator(Enumeration<NodeId> nodeIds_)
    {
	this.nodeIds = nodeIds_;
    }

 /** 
 *  Return a token for the next element in the version vector 
 **/ 
    public NodeId getNext()
    {
	NodeId token = null;

	assert(this.nodeIds.hasMoreElements());
	token = this.nodeIds.nextElement();
	return(token);
    }

 /** 
 *  Return true if we have more elements 
 **/ 
    public boolean hasMoreElements()
    {
	return(this.nodeIds.hasMoreElements());
    }

 /** 
 *  Return a string representation 
 **/ 
    public final String toString()
    {
	// NOTE: We know secretly that elements in VVIterator are nodeIds
	// but everyone else should see these as "tokens."
	String str = null;
	NodeId nodeId = null;

	str = "(";
	for(Enumeration<NodeId> e = this.nodeIds; e.hasMoreElements();){
	    nodeId = (NodeId)e.nextElement();
	    str += "" + nodeId + " ";
	}
	str += ")";
	return(str);
    }

 /** 
 *  Used for testing 
 **/ 
    public static void main(String[] argv)
    {
	Vector<NodeId> vec1 = null;
	Vector<NodeId> vec2 = null;
	VVIterator vvIter = null;
	NodeId nodeId = null;

	vec1 = new Vector<NodeId>();
	vec2 = new Vector<NodeId>();

	vec1.add(new NodeId(35));
	vec1.add(new NodeId(42));
	vec1.add(new NodeId(78));
	vec1.add(new NodeId(108));
	vec1.add(new NodeId(128));
	vec1.add(new NodeId(156));
	vec1.add(new NodeId(180));
	vec1.add(new NodeId(195));
	vec1.add(new NodeId(200));

	System.out.println("First iterator:");
	vvIter = new VVIterator(vec1.elements());
	while(vvIter.hasMoreElements()){
	    nodeId = (NodeId)vvIter.getNext();
	    System.out.println("Pulled out: " + nodeId);
	}

	System.out.println("Second iterator:");
	vvIter = new VVIterator(vec2.elements());
	while(vvIter.hasMoreElements()){
	    nodeId = (NodeId)vvIter.getNext();
	    System.out.println("Pulled out: " + nodeId);
	}

	System.out.println("Rest of the iterator: " + vvIter);
    }
}

//---------------------------------------------------------------------------
/* $Log: VVIterator.java,v $
/* Revision 1.4  2004/04/20 21:13:22  nayate
/* Minor modifications
/*
/* Revision 1.3  2004/04/20 05:25:48  nayate
/* Finished and tested VVIterator
/* */
//---------------------------------------------------------------------------
