package code;

/** WaitObj
 * 
 * Simple implementation which causes currentthread to wait on obj unit notified.
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */


public class WaitObj {
 
  int notified = 0;
  boolean dbg = false;

  public synchronized void waitOnObj() {
    while (notified <= 0) {
      try{
	if( dbg ){
	  Env.dprintln(dbg, "WaitObj: waiting...");
	}
        wait();
      } catch(Exception e) {
        //ignore exception
      }
    }
    notified--;
  }


  public synchronized void  notifyThreads(){
    notified++;
    notifyAll();
    if( dbg ){
      Env.dprintln(dbg, "WaitObj: notified");
    }
  }

  public synchronized void reset(){
    notified = 0;
  }
}

//---------------------------------------------------------------------------
/* $Log: WaitObj.java,v $
/* Revision 1.2  2007/04/02 21:11:39  zjiandan
/* snapshort for sosp2007.
/*
/* Revision 1.1  2007/01/05 01:19:54  nalini
/* support for sync with VV added
/*
 */
//---------------------------------------------------------------------------