package code;

 /** 
 *  WorkQueue -- a synchronized producer consumer queue with blocking getNext().
 
 **/ 
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.lang.InterruptedException;

public class WorkQueue
{
    private LinkedList l;
    private final static int QUEUE_TOO_BIG = 100; 
    private int count;
    private String myName;

    public WorkQueue(String name)
    {
	l = new LinkedList();
	count = 0;
	myName = name;
    }

    public synchronized Object
    getNext()
    {
	Object o;
	
	while(isEmptyInternal()){
	    try{
		wait();
	    }
	    catch(InterruptedException i){
		assert(false);
	    }
	}

	try{
	    o = l.removeFirst();
	}
	catch(NoSuchElementException e){
	    assert(false);
	    return null;
	}
	count--;
	assert(count >= 0);
	return o;
    }


    public synchronized void
    insert(Object o)
    {
	assert(count >= 0);
	l.addLast(o);
	count++;
	if(o instanceof PendingDemandRequest) { 
	  	Env.sprinterrln(((PendingDemandRequest)o).getObjId().toString());
	}
	else if(o instanceof SubscribeInvalRequest) {
	  	Env.sprinterrln(((SubscribeInvalRequest)o).toString());
	}
	else if(o instanceof DirectoryUpdate) {
	  	Env.sprinterrln(((DirectoryUpdate)o).toString());
	}
	if(count >= QUEUE_TOO_BIG && (count % QUEUE_TOO_BIG == 0)){
	    Env.performanceWarning("Work Queue " + myName + " is falling behind "
				   + "(" + count + " pending requests)");
	}
	notify();
    }

    public synchronized boolean 
    isEmpty()
    {
	return isEmptyInternal();
    }

    private boolean
    isEmptyInternal()
    {
	try{
	    Object o = l.getFirst();
	    return false;
	}
	catch(NoSuchElementException e){
	    return true;
	}
    }




  //
  // main() self test moved to WorkQueueUnit.java for junit support
  //

}


//---------------------------------------------------------------------------
/* $LOG
 */
//---------------------------------------------------------------------------


