package code;

import junit.textui.TestRunner;
import code.utils.junit.*;

public class WorkQueueUnit extends MultiThreadedTestCase{
  public static final String TEST_ALL_TEST_TYPE = "UNIT";

  WorkQueue q;

  public WorkQueueUnit(String s){
    super(s);
  }

  protected void setUp() throws Exception{
    super.setUp();
    q = new WorkQueue("test");
  }

  protected void tearDown() throws Exception{
    super.tearDown();
  }

  public void testWorkQueue(){
    int testCount = 10000;
    TestCaseRunnable tcr[] = new TestCaseRunnable[2];
    tcr[0] = new TestConsumer(q, testCount);
    tcr[1] = new TestProducer(q, testCount);
    runTestCaseRunnables(tcr);
    assertTrue(q.isEmpty());
  }

  public static junit.framework.Test suite(){
    junit.framework.TestSuite suite 
      = new junit.framework.TestSuite(WorkQueueUnit.class);
    return suite;
  }


  public static void main(String s[]) {
    System.err.print("WorkQueue self test begins...");
    TestRunner tr = new TestRunner();
    tr.doRun(suite());
    System.err.println("Work queue self test succeeds");
  }



class TestConsumer extends TestCaseRunnable
{
    WorkQueue q;
    int max;
    TestConsumer(WorkQueue q, int max)
    {
	this.q = q;
	this.max = max;
    }

    public void runTestCase() 
    {
	int ii;
	for(ii = 0; ii < max; ii++){
          if(Thread.currentThread().isInterrupted()){
            return;
          }
          Long l = (Long)q.getNext();
          if(l.intValue() != ii){
            System.err.println("WorkQueue self test fails");
            fail(); // junit failure
          }
	}
	if(!q.isEmpty()){
          System.err.println("Work queue not empty in self test");
          fail(); // junit failure
	}
	return;
    }
}


class TestProducer extends TestCaseRunnable
{
  WorkQueue q;
  int testCount;
  TestProducer(WorkQueue q, int max){
    this.q = q;
    this.testCount = max;
  }
  
  public void runTestCase(){
    int ii;
    
    for(ii = 0; ii < testCount; ii++){
      Long l = new Long(ii);
      if(Thread.currentThread().isInterrupted()){
        return;
      }
      if(ii % 47 == 0){
        Thread.yield();
      }
      q.insert(l);
    }
    return;
  }

}


}
