package code.branchDetecting;

import code.AcceptStamp;
import code.NodeId;
import code.ObjId;
import code.ObjInvalTarget;
import code.PreciseInv;
import code.security.SangminConfig;
import code.security.ahs.DependencyVV;
import code.serialization.IrisInputStream;
import code.serialization.IrisObjectInputStream;
import code.serialization.IrisObjectOutputStream;
import code.serialization.IrisOutputStream;
import code.serialization.IrisSerializable;
import code.serialization.SerializationHelper;
import code.simulator.Hash;
import code.simulator.HashedVV;
import code.simulator.Node;
import code.simulator.Obj2Bytes;
import code.simulator.POMRemap;
import code.simulator.SecureSimPreciseInv;
import code.simulator.SimPreciseInv;
import code.simulator.log.Log;
import code.Immutable;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.TreeSet;

public class BranchID extends NodeId implements Serializable, Immutable, Comparable, Obj2Bytes, IrisSerializable{
  

  final long startTS;
  final Hash hash;
//  final BranchID parent;

  public BranchID(long id, long startTS, Hash hash){
    super(id);
    this.startTS = startTS;
    this.hash = hash;    
//    this.parent = parent;
  }
  
  public BranchID(long id){
    super(id);
    startTS = -1;
    hash = Hash.NullHash;
//    parent = null;
  }
  
  public NodeId getBaseId(){
    return new NodeId(this.getIDint());
  }

  public boolean isConcurrentForkedBranch(NodeId n){
    if(n.getIDint() != this.getIDint()){
      return false;
    }else{
      if(!(n instanceof BranchID)){
        return false;
      }else{
        BranchID bid = (BranchID)n;
        if(hash.equals(bid.hash)){
          return false;
        }else{
          assert false;
          return true;
        }
      }
    }
  }

  public boolean contains(NodeId bid){
    if(this.getIDint() != bid.getIDint()){
      return false;
    }else{
      return true;
    }
    
  }
  
  public boolean isForked(){
    assert startTS == -1?this.hash.equals(Hash.NullHash):!this.hash.equals(Hash.NullHash);
    return !this.hash.equals(Hash.NullHash);
  }
  
  /* overrides hashCode in class object */
  public int hashCode(){
    //if(this.startTS < 0)
    //  return super.hashCode();
    
    return super.hashCode() ^ ((int)startTS) ^ hash.hashCode();
  }
  @Override
  /**
   * Compare NodeId first, then start time stamp and then hash value
   */
  public int compareTo(Object o)
  {
    int res = super.compareTo(o);
    if(res != 0)
      return res;
    BranchID bid2 = (BranchID)o;
    if(this.startTS != bid2.startTS)
      return this.startTS<bid2.startTS?-1:1;
    int h1 = this.hashCode();
    int h2 = bid2.hashCode();
    if(h1==h2)
      return 0;
    return h1<h2?-1:1;
  }

  /* overrides equals in class object */
  public boolean equals(Object nid){
    BranchID bid2 = (BranchID)nid;
    return (super.equals(nid)
        && this.startTS == bid2.startTS
        && this.hash.equals(bid2.hash));
  }
  
  public String toString(){
    if(startTS != -1){
      return "RootID_"+super.toString()+"_"+startTS + "_" + hash.toShortString();//+"_hashcode_"+hashCode();
    }
    else{
      return super.toString();
    }
    //return "[RootID:"+super.toString()+", startTS:"+startTS+", hashcode:"+hashCode()+",parent:"+parent+"]";
  }

  public long getStartTS(){
    return startTS;
  }

  public Hash getHash(){
    return hash;
  }
  
  public void writeExternal(ObjectOutput out) throws IOException{
    out.writeLong(super.getIDint());
    if(startTS != -1){
      out.writeBoolean(true);
      out.writeLong(this.startTS);
      out.write(hash.getHashVal());
    }else{
      out.writeBoolean(false);
    }
    
  }
  
  public void readExternal(ObjectInput in) 
  throws IOException, ClassNotFoundException{
    long __id = in.readLong();
    long _startTS;
    Hash _hash = null; 
    if(in.readBoolean()){
      _startTS = in.readLong();
      byte[] _hashA = new byte[Hash.Length];
      in.readFully(_hashA);
      _hash = new Hash(_hashA, false);
    }else{
      _startTS = -1;
      _hash = Hash.NullHash;
    }
    Field[] f = new Field[3];
    
    try{
      f[0] = NodeId.class.getDeclaredField("_id");
      f[1] = BranchID.class.getDeclaredField("startTS");
      f[2] = BranchID.class.getDeclaredField("hash");
    }catch(NoSuchFieldException ne){
      System.err.println(ne.toString());
      ne.printStackTrace();
      System.exit(-1);
    }
    
    try{
      AccessibleObject.setAccessible(f, true);
    } catch (SecurityException se){
      System.err.println(se.toString());
      se.printStackTrace();
      System.exit(-1);
    }
    try{
      f[0].set(this, __id);
      f[1].set(this, _startTS);
      f[2].set(this, _hash);
    }catch(IllegalArgumentException ie){
      System.err.println(ie.toString());
      ie.printStackTrace();
      System.exit(-1);
    }catch(IllegalAccessException iae){
      System.err.println(iae.toString());
      iae.printStackTrace();
      System.exit(-1);
    }

    try{
      AccessibleObject.setAccessible(f, false);
    } catch (SecurityException se){
      System.err.println(se.toString());
      se.printStackTrace();
      System.exit(-1);
    }
    
  }
  
  public static void testWriteExt(){
    try{
      byte[] bytes = new byte[Hash.Length];
      for(int i=0; i<Hash.Length; i++){
        bytes[i] = 'a';
      }

      
      BranchID bid1 = new BranchID(1,2,new Hash(bytes,false));
      
      ByteArrayOutputStream bs;
      ObjectOutputStream oos;


      bs = new ByteArrayOutputStream();
//      oos = new ObjectOutputStream(bs);
      oos = new IrisObjectOutputStream(bs);
      System.out.println("Serialise it");
      bid1.writeExternal(oos);
//      oos.writeObject(bid1);
//      bid1.writeToStream(oos);
//      bid1.writeToStream(oos);
      oos.flush();
      //bs.toByteArray();
      System.out.println("read it " + bs.toByteArray().length + "\n " + Arrays.toString(bs.toByteArray()));
      
      BranchID bid2 = null;
      
      SecureSimPreciseInv sspi2 = null;
//      ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bs.toByteArray()));
      ObjectInputStream ois = new IrisObjectInputStream(new ByteArrayInputStream(bs.toByteArray()));
      try{
        bid2 = new BranchID(-1);
        bid2.readExternal(ois); 
      //(BranchID)ois.readObject();
      
      }catch(ClassNotFoundException e){
        // TODO Auto-generated catch block
        e.printStackTrace();
      }

      if(bid1.equals(bid2)){
        System.out.println("Success");
      } else {
        System.out.println("Fail : \n" + bid1 + "\n" + bid2);

      }
      } catch(IOException e){
        e.printStackTrace();
        System.out.println(e.getLocalizedMessage());
      }
  }
  
  public static void testWriteStr(){
    try{
      byte[] bytes = new byte[Hash.Length];
      for(int i=0; i<Hash.Length; i++){
        bytes[i] = 'a';
      }

      
      BranchID bid1 = new BranchID(1,2,new Hash(bytes,false));
      
      ByteArrayOutputStream bs;
      IrisOutputStream oos;


      bs = new ByteArrayOutputStream();
//      oos = new ObjectOutputStream(bs);
      oos = new IrisOutputStream(bs);
      System.out.println("Serialise it");
      bid1.writeToStream(oos, false);
//      oos.writeObject(bid1);
//      bid1.writeToStream(oos);
//      bid1.writeToStream(oos);
      oos.flush();
      //bs.toByteArray();
      System.out.println("read it " + bs.toByteArray().length + "\n " + Arrays.toString(bs.toByteArray()));
      
      BranchID bid2 = null;
      
      SecureSimPreciseInv sspi2 = null;
      //      ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bs.toByteArray()));
      IrisInputStream ois = new IrisInputStream(new ByteArrayInputStream(bs.toByteArray()));
      bid2 = new BranchID(-1);
      bid2.readFromStream(ois, false); 
      //(BranchID)ois.readObject();


      if(bid1.equals(bid2)){
        System.out.println("Success");
      } else {
        System.out.println("Fail : \n" + bid1 + "\n" + bid2);

      }
      } catch(IOException e){
        e.printStackTrace();
        System.out.println(e.getLocalizedMessage());
      }
  }
  public static void main(String[] args) {
    testWriteExt();
    testWriteStr();
  }

  public byte[] obj2Bytes(){
    byte[] ret = null;
    try{
      ByteArrayOutputStream bs = new ByteArrayOutputStream();
      ObjectOutputStream oos = new ObjectOutputStream(bs);
      oos.writeLong(this.getIDint());
      if(startTS!=-1){
        oos.writeLong(startTS);
        oos.write(hash.obj2Bytes());
      }

      oos.flush();
      ret = bs.toByteArray();
      bs.close();
      oos.close();
      return ret;
    } catch (Exception e){
      e.printStackTrace();
    }
    assert false;
    return null;
  }

  
  public void readFromStream(IrisInputStream in, boolean optimized)
      throws IOException{
    long __id = in.readLong();
    boolean longID = (__id&0x01)==1;
    __id = __id>>1;
    long _startTS;
    Hash _hash = null; 
    if(longID){
      _startTS = in.readLong();
      byte[] _hashA = new byte[Hash.Length];
      in.readFully(_hashA);
      _hash = new Hash(_hashA, false);
    }else{
      _startTS = -1;
      _hash = Hash.NullHash;
    }
    
//    
//    long _startTS;
//    Hash _hash = null; 
//    if(in.readBoolean()){
//      _startTS = in.readLong();
//      byte[] _hashA = new byte[Hash.Length];
//      in.readFully(_hashA);
//      _hash = new Hash(_hashA, false);
//    }else{
//      _startTS = -1;
//      _hash = Hash.NullHash;
//    }
    Field[] f = new Field[3];
    
    try{
      f[0] = NodeId.class.getDeclaredField("_id");
      f[1] = BranchID.class.getDeclaredField("startTS");
      f[2] = BranchID.class.getDeclaredField("hash");
    }catch(NoSuchFieldException ne){
      System.err.println(ne.toString());
      ne.printStackTrace();
      System.exit(-1);
    }
    
    try{
      AccessibleObject.setAccessible(f, true);
    } catch (SecurityException se){
      System.err.println(se.toString());
      se.printStackTrace();
      System.exit(-1);
    }
    try{
      f[0].set(this, __id);
      f[1].set(this, _startTS);
      f[2].set(this, _hash);
    }catch(IllegalArgumentException ie){
      System.err.println(ie.toString());
      ie.printStackTrace();
      System.exit(-1);
    }catch(IllegalAccessException iae){
      System.err.println(iae.toString());
      iae.printStackTrace();
      System.exit(-1);
    }

    try{
      AccessibleObject.setAccessible(f, false);
    } catch (SecurityException se){
      System.err.println(se.toString());
      se.printStackTrace();
      System.exit(-1);
    }
  }

  public void writeToStream(IrisOutputStream out, boolean optimized)
      throws IOException{
//    if(SangminConfig.useShortId){
//      out.writeShort((short)super.getIDint());
//    }else{
//      out.writeLong(super.getIDint());
//    }
//    if(startTS != -1){
//      out.writeBoolean(true);
//      out.writeLong(this.startTS);
//      out.write(hash.getHashVal());
//    }else{
//      out.writeBoolean(false);
//    }
    long idFlagBuffer= (super.getIDint()<<1);
    idFlagBuffer |= ((startTS ==-1)?0L:1L);
    out.writeLong(idFlagBuffer);
    if(startTS != -1){
      out.writeLong(startTS);
      out.write(hash.getHashVal());
    }
  }

  
}
