package code.branchDetecting;

import java.util.Arrays;

import code.PreciseInv;

public class BranchManager implements SegmentCheckInterface {
  final private BranchKnowledge knowledge;
  final private ForkableLog forkaleLog;

  public BranchManager(BranchKnowledge knowledge, ForkableLog ahsmap){
    this.knowledge = knowledge;
    this.forkaleLog = ahsmap;
  }
  
  public HashTSTuple checkCompatibility(Segment segShort, Segment segLong)
  throws ConflictingSegmentsException{
    //  segLong - local history
    //  segShort - remote history
    //System.out.println("CheckCompatibility : "
    //    + "\n"+segShort+"\n"+segLong+"\n");
    if(segShort.getEndTS() == segLong.getEndTS()){
      if(segShort.getEndHash().equals(segLong.getEndHash())){
        return null;
      } else {
        throw new ConflictingSegmentsException();
      }
    }

    HashTSTuple ht = forkaleLog.getSummaryHashAtOrBefore(segShort.bid, segShort.getEndTS());
    
    
    if(ht.timeStamp != segShort.getEndTS() ||
        !ht.hash.equals(segShort.getEndHash())){
      throw new ConflictingSegmentsException();
    }

    if(segShort.isLeaf()){
      return null;
    }    

    HashTSTuple tuple = getSummaryHashAfter(
        segShort.getBid(), segShort.getEndTS());
    assert tuple!=null;

    return tuple;
  }
  
  public void createNewBranch(BranchID bid, long startTSOfNewBranch){
    //First, split the segment     
    Segment seg = knowledge.getSegment(bid);
    assert seg != null;
    // Create a new segment and put it back to knowledge
    BranchID newBID =
      new BranchID(bid.getIDint(), startTSOfNewBranch,
          forkaleLog.getSummaryHashAtOrBefore(bid, startTSOfNewBranch).hash);
    Segment newSeg = new Segment(startTSOfNewBranch, seg.getEndTS(),
        newBID, seg.getEndHash(), seg.isLeaf());
    knowledge.getSegmentGroups(newBID).addSegment(newSeg);

    // Shorten the old segment and make it non-leaf
    HashTSTuple oldBranchInfo =
      forkaleLog.getSummaryHashAtOrBefore(bid, startTSOfNewBranch -1);
    seg.setEndTS(oldBranchInfo.timeStamp);
    seg.setEndHash(oldBranchInfo.hash);
    seg.makeNonLeaf();

    
    //Second, split the underlying log
    forkaleLog.createNewBranch(bid, startTSOfNewBranch);
  }
  
  public HashTSTuple getSummaryHashAfter(BranchID bid, long timestamp){
    return forkaleLog.getSummaryHashAfter(bid, timestamp);
  }
  
  public HashTSTuple getSummaryHashAtOrBefore(BranchID bid, long timestamp){
    return forkaleLog.getSummaryHashAtOrBefore(bid, timestamp);
  }

  public BranchKnowledge getKnowledge(){    
    return knowledge.clone();
  }

//  public boolean apply(PreciseInv pi){
//    assert false;
//    return this.forkaleLog.apply(pi);
//  }
  
}
