package code.branchDetecting;

import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;

import code.AcceptVV;
import code.Config;
import code.Env;
import code.NodeId;
import code.RMIApplicationException;
import code.RMINetworkException;
import code.RMIServerImpl;
import code.SubscriptionSet;
import code.security.SecureRMIClient;
import code.security.SecureRMIServer;
import code.security.SecureRMIServerImpl;

public class ForkJoinRMIClient extends SecureRMIClient {

  BranchKnowledge branchKnowledge;

  public ForkJoinRMIClient(){
    super();
  }

  public void setBranchKnowledge(BranchKnowledge bK){
    assert bK != null;
    branchKnowledge = bK;
  }

  public AcceptVV 
  subscribeInval(NodeId supplierNodeId,
      NodeId subscriberNodeId,
      String subscriberNodeDNS, 
      int subscriberPortInval,
      SubscriptionSet ss, 
      AcceptVV startVV,
      boolean catchupWithCP,
      boolean cpWithBody/*, 
                 boolean includeAll*/)
  throws RMINetworkException, RMIApplicationException
  {

    AcceptVV returnVV = null;
    if(dbg){
      Env.dprintln(dbg, "RMIClient::subscribeInval(senderID="+supplierNodeId.toString()
          + " receiverId="+ subscriberNodeId.toString() + "SS= "+ ss.toString()
          + "startvv=" + startVV.toString());
    }

    long end, totalTime, start;
    if(dbgPerformance ||printTime){
      start = System.currentTimeMillis();
      Env.dprintln(dbgPerformance, " start@ "
          + start + " ---rmiClient::subscribeInval(senderID="+supplierNodeId.toString()
          + " receiverId="+ subscriberNodeId.toString() + "SS= "+ ss.toString()
          + "startvv=" + startVV.toString());
    }
    ForkJoinRMIServer rmiServer = null;
    try{

      rmiServer = (ForkJoinRMIServer)Naming.lookup(Config.getRMIUrl(supplierNodeId));


      if(dbgPerformance){
        end = System.currentTimeMillis();
        Env.dprintln(dbgPerformance, " Naminglookup****** "
            + (end-start) + " ---rmiClient::subscribeInval(senderID="+supplierNodeId.toString()
            + " receiverId="+ subscriberNodeId.toString() + "SS= "+ ss.toString()
            + "startvv=" + startVV.toString());
      }
      assert subscriberNodeId instanceof BranchID;
      returnVV = rmiServer.subscribeInval(subscriberNodeId, 
          subscriberNodeDNS, 
          subscriberPortInval,
          ss, 
          startVV,
          catchupWithCP,
          cpWithBody, branchKnowledge/*, 
                               includeAll*/);

      if(dbgPerformance){
        end = System.currentTimeMillis();
        totalTime = (end-start);
        Env.dprintln(dbgPerformance, "end@ " + end + "---- take @@@@@@@" + totalTime
            + "ms " + "RMIClient::subscribeInval(senderID="+supplierNodeId.toString()
            + " receiverId="+ subscriberNodeId.toString() + "SS= "+ ss.toString()
            + "startvv=" + startVV.toString());
      }

      return returnVV;
    }catch(java.net.MalformedURLException e){
      e.printStackTrace();
      System.exit(-1);
    }catch(ConnectException a){

      Env.dprintln(true, "RMIClient::subscribeInval(senderID="+supplierNodeId.toString()
          + " receiverId="+ subscriberNodeId.toString() + "SS= "+ ss.toString()
          + "startvv=" + startVV.toString());
      //a.printStackTrace();
      throw new RMINetworkException(a);
    }catch(ConnectIOException b){
      //b.printStackTrace();
      throw new RMINetworkException(b);
    }catch(NotBoundException c){
      //c.printStackTrace();
      throw new RMINetworkException(c);
    }catch(UnknownHostException d){
      //d.printStackTrace();
      throw new RMINetworkException(d);
    }catch(RemoteException e){
      //e.printStackTrace();
      throw new RMIApplicationException(e);
    }
    return returnVV;
  }


  public HashTSTuple checkCompatibility(
      Segment segShort,
      Segment segLong,
      NodeId receiver) throws ConflictingSegmentsException,
      RMINetworkException, RMIApplicationException{

    ForkJoinRMIServer rmiServer = null;

    try {      
      rmiServer = (ForkJoinRMIServer)Naming.lookup(Config.getRMIUrl(receiver));
      return rmiServer.checkCompatibility(segShort, segLong);
    }catch(java.net.MalformedURLException e){
      e.printStackTrace();
      System.exit(-1);
    }catch(ConnectException a){
      a.printStackTrace();
      assert false;
      throw new RMINetworkException(a);
    }catch(ConnectIOException b){
      b.printStackTrace();
      assert false;
      throw new RMINetworkException(b);
    }catch(NotBoundException c){
      c.printStackTrace();
      assert false;
      throw new RMINetworkException(c);
    }catch(UnknownHostException d){
      d.printStackTrace();
      assert false;
      throw new RMINetworkException(d);
    }catch(RemoteException e){
      if(e instanceof RemoteConflictingSegmentsException){
        throw new ConflictingSegmentsException();
      }
      e.printStackTrace();
      assert false;
      throw new RMIApplicationException(e);
    }
    return null;
  }

  public void createNewBranch(BranchID bid, long startTSOfNewBranch,
      NodeId receiver) throws RMINetworkException, RMIApplicationException{

    ForkJoinRMIServer rmiServer = null;
    try{
      rmiServer = (ForkJoinRMIServer)Naming.lookup(Config.getRMIUrl(receiver));

      rmiServer.createNewBranch(bid, startTSOfNewBranch);
    }catch(java.net.MalformedURLException e){
      e.printStackTrace();
      System.exit(-1);
    }catch(ConnectException a){
      a.printStackTrace();
      assert false;
      throw new RMINetworkException(a);
    }catch(ConnectIOException b){
      b.printStackTrace();
      assert false;
      throw new RMINetworkException(b);
    }catch(NotBoundException c){
      c.printStackTrace();
      assert false;
      throw new RMINetworkException(c);
    }catch(UnknownHostException d){
      d.printStackTrace();
      assert false;
      throw new RMINetworkException(d);
    }catch(RemoteException e){
      e.printStackTrace();
      assert false;
      throw new RMIApplicationException(e);
    }
  }

  public HashTSTuple getSummaryHashAfter(BranchID bid, long timestamp, 
      NodeId receiver) throws RMINetworkException, RMIApplicationException{

    ForkJoinRMIServer rmiServer = null;

    try {
      rmiServer = (ForkJoinRMIServer)Naming.lookup(Config.getRMIUrl(receiver));
      return rmiServer.getSummaryHashAfter(bid, timestamp);
    }catch(java.net.MalformedURLException e){
      e.printStackTrace();
      System.exit(-1);
    }catch(ConnectException a){
      a.printStackTrace();
      assert false;
      throw new RMINetworkException(a);
    }catch(ConnectIOException b){
      b.printStackTrace();
      assert false;
      throw new RMINetworkException(b);
    }catch(NotBoundException c){
      c.printStackTrace();
      assert false;
      throw new RMINetworkException(c);
    }catch(UnknownHostException d){
      d.printStackTrace();
      assert false;
      throw new RMINetworkException(d);
    }catch(RemoteException e){
      e.printStackTrace();
      assert false;
      throw new RMIApplicationException(e);
    }
    return null;
  }

  public HashTSTuple getSummaryHashAtOrBefore(BranchID bid, long timestamp,
      NodeId receiver) throws RMINetworkException, RMIApplicationException{
    ForkJoinRMIServer rmiServer = null;

    try {

      rmiServer = (ForkJoinRMIServer)Naming.lookup(Config.getRMIUrl(receiver));
      return rmiServer.getSummaryHashAtOrBefore(bid, timestamp);
    }catch(java.net.MalformedURLException e){
      e.printStackTrace();
      System.exit(-1);
    }catch(ConnectException a){
      a.printStackTrace();
      assert false;
      throw new RMINetworkException(a);
    }catch(ConnectIOException b){
      b.printStackTrace();
      assert false;
      throw new RMINetworkException(b);
    }catch(NotBoundException c){
      c.printStackTrace();
      assert false;
      throw new RMINetworkException(c);
    }catch(UnknownHostException d){
      d.printStackTrace();
      assert false;
      throw new RMINetworkException(d);
    }catch(RemoteException e){
      e.printStackTrace();
      assert false;
      throw new RMIApplicationException(e);
    }
    return null;
  }


}
