package code.branchDetecting;

import java.rmi.RemoteException;

import code.AcceptVV;
import code.Controller;
import code.Core;
import code.Env;
import code.NodeId;
import code.Stats;
import code.SubscriptionSet;
import code.security.SangminConfig;
import code.security.SecureCore;
import code.security.SecureNewOutgoingInvalConnectionPool;
import code.security.SecureRMIServerImpl;

public class ForkJoinRMIServerImpl extends SecureRMIServerImpl 
implements ForkJoinRMIServer {

  SegmentCheckInterface branchChecker;
  ForkableAHSMap ahsmap;
  BranchManager bm;
  
  public ForkJoinRMIServerImpl(Core core, Controller controller_)
  throws RemoteException{
    super(core, controller_);
    SecureCore seCore = (SecureCore)core;
    bm = seCore.getSecurityFilter().getBranchManager();
  }

  public HashTSTuple checkCompatibility(Segment segShort, Segment segLong)
  throws java.rmi.RemoteException{
    try{
      return bm.checkCompatibility(segShort, segLong);
    }catch(ConflictingSegmentsException e){
      throw new RemoteConflictingSegmentsException();
    }
  }

  public void createNewBranch(BranchID bid, long startTSOfNewBranch)
  throws java.rmi.RemoteException{
  	bm.createNewBranch(bid, startTSOfNewBranch);
  }

  public HashTSTuple getSummaryHashAfter(BranchID bid, long timestamp)
  throws java.rmi.RemoteException{
    return bm.getSummaryHashAfter(bid, timestamp);
  }

  public HashTSTuple getSummaryHashAtOrBefore(BranchID bid, long timestamp)
  throws java.rmi.RemoteException{
    return bm.getSummaryHashAtOrBefore(bid, timestamp);
  }

  public AcceptVV subscribeInval(NodeId subscriberNodeId,
      String subscriberNodeDNS, int subscriberPortInval, SubscriptionSet ss,
      AcceptVV startVV, boolean catchupWithCP, boolean cpWithBody,
      BranchKnowledge bk) throws RemoteException{

    AcceptVV returnVV = null;
    if(testRawRMIPerformance){
      return returnVV;
    }
    long start, end, totalTime;
    if(dbgPerformance){
      start = System.currentTimeMillis();
      Env.dprintln(dbgPerformance, " start@ "+ start + " ---rmiServer::subscribeInval("
                   + " receiverId="+ subscriberNodeId.toString() + "SS= "+ ss.toString() 
                   + "startvv=" + startVV.toString());
    }

    if(dbgInvalSub){
      Env.dprintln(dbgInvalSub, "RMIServerImpl:: SubscribeInval "
                   + " receiverId="+ subscriberNodeId.toString() + "SS= "+ ss.toString() 
                   + "startvv=" + startVV.toString());
    }
    if(useNewIterator){
      if(SangminConfig.forkjoin){
        returnVV = ((SecureNewOutgoingInvalConnectionPool)icp).addToConnection(subscriberNodeId, subscriberNodeDNS, 
            subscriberPortInval, ss, startVV, cpWithBody, catchupWithCP, bk/*, includeAll*/);
      } else {
        returnVV = icp.addToConnection(subscriberNodeId, subscriberNodeDNS, 
                        subscriberPortInval, ss, startVV, cpWithBody, catchupWithCP/*, includeAll*/);
      }
    }else{
      ocp.addToConnection(subscriberNodeId, subscriberNodeDNS, 
                          subscriberPortInval, ss, startVV, cpWithBody, catchupWithCP);
    }
    if(doStats){
      Stats.countBytes("RMIServer:subscribeInval", subscriberNodeId);
      Stats.countBytes("RMIServer:subscribeInval", subscriberNodeDNS);
      Stats.countBytes("RMIServer:subscribeInval", new Integer(subscriberPortInval));
      Stats.countBytes("RMIServer:subscribeInval", ss);
      Stats.countBytes("RMIServer:subscribeInval", startVV);
    }

    if(dbgPerformance){
      end = System.currentTimeMillis();
      totalTime = (end-start);
      Env.dprintln(dbgPerformance, " @@@@@@@ "+ totalTime + " ---rmiServer::subscribeInval("
                   + " receiverId="+ subscriberNodeId.toString() + "SS= "+ ss.toString());
    }
    return returnVV;
  }

}
