package code.branchDetecting;

import java.util.Arrays;
import java.util.Enumeration;

import code.NodeId;
import code.PreciseInv;
import code.security.SecurePreciseInv;
import code.security.SecurityFilter;
import code.security.ahs.AHS;
import code.security.ahs.AHSMap;
import code.security.ahs.DVVMap;
import code.security.ahs.DVVMapEntry;
import code.security.ahs.RootList;
import code.security.ahs.TreeNode;
import code.security.ahs.UnmatchingTreeNodeException;
import code.simulator.*;

public class ForkableAHSMap extends AHSMap //{
implements ForkableLog{
  SecurityFilter securityFilter;
  public ForkableAHSMap(){
    super();
  }
  public ForkableAHSMap(SecurityFilter sf){
    super();
    securityFilter = sf;
  }

  public synchronized HashTSTuple getSummaryHashAfter(BranchID bid, long timestamp){
    TreeNode tn = super.getTreeNodeAfter(bid, timestamp);
    if(tn==null) return null;
    long ts = tn.getStartTS();
    byte[] hash = super.asAHS(bid, ts).getHash();    
    return new HashTSTuple(ts, new Hash(hash, false));
  }

  public synchronized HashTSTuple getSummaryHashAtOrBefore(BranchID bid, long timestamp){
    assert timestamp >= 0;
    AHS ahs = super.asAHS(bid, timestamp);    
    return new HashTSTuple(ahs.elementAt(ahs.size()-1).getEndTS(), new Hash(ahs.getHash(), false));      
  }

  public boolean apply(PreciseInv pi){
    try{
      super.applySecurePreciseInv((SecurePreciseInv)pi);
    }catch(UnmatchingTreeNodeException e){
      // TODO Auto-generated catch block
      e.printStackTrace();
      return false;
    }
    return true;
  }

  public synchronized void createNewBranch(BranchID bid, long startTSOfNewBranch){
    System.out.println("Before forking :\n " + super.toString());
    System.out.println("Before forking(Long) :\n " + super.toLongString());
    
    RootList rootlist = super.ahsMap.remove(bid);
    super.knowledge.dropNode(bid);
    
    long start = rootlist.getStartTS();
    assert rootlist.getEndTS() >= startTSOfNewBranch;
    TreeNode tn = rootlist.getTreeNodeTS(start);
    
    TreeNode tn2 = rootlist.getTreeNodeTS(start);
    
    while(tn2!=null){
      System.out.println("INV : " + tn2.getInv());
      System.out.println("TreeNode : " + tn2);
      System.out.println("local hash : " + DVVMapEntry.byteString(rootlist.asAHS(tn2.getEndTS()).getHash()));      
      tn2 = tn2.getNext();
    }
    
    assert tn != null;
    while(tn.getEndTS() < startTSOfNewBranch){
      try{
        super.applySecurePreciseInv((SecurePreciseInv)tn.getInv());
      }catch(UnmatchingTreeNodeException e1){
        // TODO Auto-generated catch block
        e1.printStackTrace();
        assert false;
      }
      //securityFilter.verifyAndApply((SecurePreciseInv)tn.getInv(), bid);
      
      tn = tn.getNext();
      assert tn != null;
    }
    assert tn.getEndTS() == startTSOfNewBranch;
    
    /*
     * Start of new branch
     */
    //AHS ahs = rootlist.asAHS(startTSOfNewBranch);
    //System.out.println("AHS : " + ahs.toString());
    byte[] hash = rootlist.asAHS(startTSOfNewBranch).getHash();
    
    assert hash !=null;
    BranchID newBranchID = new BranchID(bid.getIDint(),startTSOfNewBranch, new Hash(hash, false));        
    
    // Link Hash
    RootList rt = super.getRootList(newBranchID);
    rt.getDummyNode().setSuperHash(tn.getPrev().getSuperHash());
    
    while(tn != null){
      SecurePreciseInv orgSPI = (SecurePreciseInv)tn.getInv();
      System.out.println("Org SPI : " + orgSPI);
      SecurePreciseInv spi = orgSPI.cloneWithNewNodeId(newBranchID);   
      spi.updateDVV(bid, startTSOfNewBranch, newBranchID);
      System.out.println("New SPI : " + spi);
      //securityFilter.verifyAndApply(spi, newBranchID);
      try{
        super.applySecurePreciseInv(spi);
      }catch(UnmatchingTreeNodeException e1){
        // TODO Auto-generated catch block
        e1.printStackTrace();
        assert false;
      }
      tn = tn.getNext();
    }
    //System.out.println("Before dvv update (Long) :\n " + super.toLongString());
    /*
     * Update DVVs of leaf tree-nodes and spi that point to the old(stale) branch
     */
    Enumeration<RootList> e =  super.ahsMap.elements();
    while(e.hasMoreElements()){
      RootList rl = e.nextElement();
      long sts = rl.getStartTS();
      TreeNode t = rl.getTreeNodeTS(sts);
      while(t != null){
        t.getMaxDVVMap().updateNodeId(bid, startTSOfNewBranch, newBranchID);
        SecurePreciseInv spi = (SecurePreciseInv)t.getInv();
        assert spi != null;
        spi.updateDVV(bid, startTSOfNewBranch, newBranchID);
        t = t.getNext();
      }
      /*
       * Update DVVs of root tree-nodes that point to the old(stale) branch
       */
      for(int i=0; i < rl.size(); i++){
        rl.NodeAt(i).getMaxDVVMap().updateNodeId(bid, startTSOfNewBranch, newBranchID);
      }
    }

      
    System.out.println("After forking :\n " + super.toString());
    System.out.println("After forking(Long) :\n " + super.toLongString());

  }

}
