package code.branchDetecting;

import code.PreciseInv;

public interface ForkableLog{
  /**
   * Return a tuple of a largest time stamp that is equal to or less than the given
   * time stamp and the corresponding summary hash
   */
  public HashTSTuple getSummaryHashAtOrBefore(BranchID bid, long timestamp);

  /**
   * Return a tuple of a smallest time stamp that is greater than the given
   * time stamp and the corresponding summary hash
   */
  public HashTSTuple getSummaryHashAfter(BranchID bid, long timestamp);
 
  /**
   * Create a new branch whose parent's is bid and that starts from startTS
   * @param bid branchID of the new branch's parent
   * @param startTS start time stamp of the new branch
   */
  public void createNewBranch(BranchID bid, long startTSOfNewBranch);
  
//  public boolean apply(PreciseInv pi);
}
