package code.branchDetecting;

import java.io.Serializable;
import java.util.Arrays;
import code.simulator.Hash;
/**
 * Container to store a time stamp and a hash value
 */
public class HashTSTuple implements Serializable{
  final long timeStamp; // time stamp
  final Hash hash; // summary hash 
  
  public HashTSTuple(long ts, Hash hash){
    this.timeStamp = ts;
    this.hash = hash;
    assert hash != null;
  }
  
  @Override
  public boolean equals(Object obj){
    if(!(obj instanceof HashTSTuple)){
      return false;
    }
    HashTSTuple o = (HashTSTuple)obj;
    return (this.timeStamp == o.timeStamp) && hash.equals(o.hash);

  }

  public long getTimeStamp(){
    return timeStamp;
  }

  public Hash getHash(){
    return hash;
  }
  
  public String toString(){
    return "TS: " + timeStamp + ", hash : " + hash;
  }
}
