package code.branchDetecting;

import code.NodeId;
import code.RMIApplicationException;
import code.RMINetworkException;

public class RemoteBranchManager implements SegmentCheckInterface {

  BranchKnowledge branchKnowledge;
  ForkJoinRMIClient rmiClient;
  NodeId receiverId;
  
  public RemoteBranchManager(BranchKnowledge bK, ForkJoinRMIClient rc,
  		NodeId receiver){
    branchKnowledge = bK;
    rmiClient = rc;
    receiverId = receiver;
  }
  
  public HashTSTuple checkCompatibility(Segment segShort, Segment segLong)
      throws ConflictingSegmentsException{
    try {
			return rmiClient.checkCompatibility(segShort, segLong, receiverId);
		} catch (RMINetworkException e) {
			assert false;
			return null;
		} catch (RMIApplicationException e) {
			assert false;
			return null;
		}
  }

  public BranchKnowledge getKnowledge(){
    return branchKnowledge;
  }

  public void createNewBranch(BranchID bid, long startTSOfNewBranch){
    try {
			rmiClient.createNewBranch(bid, startTSOfNewBranch, receiverId);
		} catch (RMINetworkException e) {
			assert false;
			e.printStackTrace();
		} catch (RMIApplicationException e) {
			assert false;
			e.printStackTrace();
		}
    
  }

  public HashTSTuple getSummaryHashAfter(BranchID bid, long timestamp){
    try {
			return rmiClient.getSummaryHashAfter(bid, timestamp, receiverId);
		} catch (RMINetworkException e) {
			assert false;
			e.printStackTrace();
		} catch (RMIApplicationException e) {
			assert false;
			e.printStackTrace();
		}
		return null;
  }

  public HashTSTuple getSummaryHashAtOrBefore(BranchID bid, long timestamp){
    try {
			return rmiClient.getSummaryHashAtOrBefore(bid, timestamp, receiverId);
		} catch (RMINetworkException e) {
			assert false;
			e.printStackTrace();
		} catch (RMIApplicationException e) {
			assert false;
			e.printStackTrace();
		}
		return null;
  }

}
