package code.branchDetecting;

import code.NodeId;
import java.io.Serializable;
import java.util.Arrays;
import code.simulator.*;

public class Segment implements Comparable<Segment>, Serializable {
  
  final long startTS; // timestamp of beginning of this segment
  private long endTS; // timestamp of end of this segment
  
  final BranchID bid;
  // hash that summarize branch's history till the end of this segment
  private Hash endHash;    

  private boolean isLeaf; // whether this segment is a leaf or not
  
  public Segment(long startTS, long endTS, BranchID bid, Hash endHash,
      boolean isLeaf){
    assert bid.startTS == -1 || startTS == bid.startTS;
    this.startTS = startTS;
    this.endTS = endTS;
    this.bid = bid;
    this.endHash = endHash;
    this.isLeaf = isLeaf;
  }
  
  
  /**
   * Compare Segment objects based on its startTS (start time stamp) 
   * Note: this class has a natural ordering that is inconsistent with equals.
   */
  public int compareTo(Segment s){
    
    if(this.startTS < s.startTS){
      return -1;
    }else if(this.startTS > s.startTS){
      return 1;
    }else if(endTS < s.endTS){
      
      return 1;
    }else if(endTS > s.endTS){
      return -1;
    }else if(s.isLeaf && !isLeaf){
      return 1;
    }else if(isLeaf && !s.isLeaf){
      return -1;
    }else if(bid.compareTo(s.bid) != 0){
      return bid.compareTo(s.bid);
    }else if(endHash.equals(s.endHash)){
      return 0;
    }else if(endHash.hashCode() > s.hashCode()){
      return 1;
    }else{
      return -1;
    }

  }

  public boolean equals(Object o){
    if(!(o instanceof Segment)){
      return false;
    }else{
      Segment s = (Segment)o;
      return this.startTS == s.startTS && this.endHash.equals(s.endHash) && this.isLeaf == s.isLeaf && this.endTS == s.endTS;
    }
  }
  public long getStartTS(){
    return startTS;
  }

  public long getEndTS(){
    return endTS;
  }


  public void setEndTS(long endTS){
    this.endTS = endTS;
  }


  public Hash getEndHash(){
    return endHash;
  }


  public void setEndHash(Hash endHash){
    this.endHash = endHash;
  }


  public boolean isLeaf(){
    return isLeaf;
  }


  public void makeNonLeaf(){
    this.isLeaf = false;
  }


  public BranchID getBid(){
    return bid;
  }
  
  public String toString(){
    return "["
    + "startTS:"+ startTS
    + ",endTS:" + endTS
    + ",branchID:" + bid
    + ",endHash:" + endHash
    + ",isLeaf:" + isLeaf
    + "]";
  }
  
  public Segment clone(){
    return new Segment(startTS, endTS, bid, endHash, isLeaf);
  }

  
}
