package code.branchDetecting;

import java.util.HashSet;

/**
 * This exposes an interface that underlying data structure for meta-data
 * has to implement 
 */
public interface SegmentCheckInterface extends ForkableLog{

  /**
   * Check if the longer segment includes the short one.
   * If not, ConflictingSegmentsException is thrown.
   * If so, and also if the short one is a non-leaf segment,
   * it returns Hash-TimeStamp tuple for the start of the uncommon 
   * part of the long segment.
   * If the short one is a leaf segment, returns null;
   */
  public HashTSTuple checkCompatibility(Segment segShort, Segment segLong) 
    throws ConflictingSegmentsException;

  /**
   * 
   * @return cloned version of knowledge
   */
  public BranchKnowledge getKnowledge();


}
